/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import org.apache.hop.ui.core.dialog.EnterPrintDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintSpool {
    private PrinterData printerdata = Printer.getDefaultPrinterData();
    private Printer printer;
    private PaletteData palette;

    public PrintSpool() {
        if (this.printerdata != null) {
            this.printer = new Printer(this.printerdata);
        }
    }

    public PrinterData getPrinterData() {
        return this.printerdata;
    }

    public Printer getPrinter(Shell sh) {
        PrintDialog pd = new PrintDialog(sh);
        this.printerdata = pd.open();
        if (this.printerdata != null) {
            if (this.printer != null) {
                this.printer.dispose();
            }
            this.printer = new Printer(this.printerdata);
        }
        return this.printer;
    }

    public void dispose() {
        if (this.printer != null) {
            this.printer.dispose();
        }
    }

    public int getDepth() {
        return this.printer.getDepth();
    }

    public PaletteData getPaletteData() {
        switch (this.getDepth()) {
            case 1: {
                this.palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
                break;
            }
            default: {
                this.palette = new PaletteData(0, 0, 0);
                this.palette.isDirect = true;
            }
        }
        return this.palette;
    }

    public void printImage(Shell sh, Image img) {
        if (this.printerdata != null) {
            double margin_bottom;
            double marginTop;
            double margin_right;
            double margin_left;
            Rectangle imgbounds = img.getBounds();
            Point max = new Point(imgbounds.width, imgbounds.height);
            Point dpi_printer = this.printer.getDPI();
            Point dpi_screen = Display.getCurrent().getDPI();
            double factorx = (double)dpi_printer.x / (double)dpi_screen.x;
            double factory = (double)dpi_printer.y / (double)dpi_screen.y;
            Rectangle page = this.printer.getBounds();
            EnterPrintDialog epd = new EnterPrintDialog(sh, 1, 1, 100, factorx, factory, page, margin_left = 0.4, margin_right = 0.4, marginTop = 0.4, margin_bottom = 0.4, img);
            if (epd.open() == 32) {
                double page_left = epd.leftMargin * (double)dpi_printer.x;
                double page_right = epd.rightMargin * (double)dpi_printer.x;
                double pageTop = epd.topMargin * (double)dpi_printer.y;
                double page_bottom = epd.bottomMargin * (double)dpi_printer.y;
                double page_sizex = (double)page.width - page_left - page_right;
                double page_sizey = (double)page.height - pageTop - page_bottom;
                double size_on_paperx = (double)max.x * factorx;
                double size_on_papery = (double)max.y * factory;
                double actual_sizex = size_on_paperx * (double)epd.scale / 100.0;
                double actual_sizey = size_on_papery * (double)epd.scale / 100.0;
                this.printer.startJob("HopGui : print workflow");
                for (int c = 0; c < epd.nrcols; ++c) {
                    double leftToPrintX = actual_sizex - page_sizex * (double)c;
                    double printx = leftToPrintX > page_sizex ? page_sizex : (leftToPrintX >= 0.0 ? leftToPrintX : 0.0);
                    for (int r = 0; r < epd.nrrows; ++r) {
                        double leftToPrintY = actual_sizey - page_sizey * (double)r;
                        double printy = leftToPrintY > page_sizey ? page_sizey : (leftToPrintY >= 0.0 ? leftToPrintY : 0.0);
                        int startx = (int)(actual_sizex - leftToPrintX);
                        int starty = (int)(actual_sizey - leftToPrintY);
                        int fromx = (int)((double)startx / (factorx * (double)epd.scale / 100.0));
                        int fromy = (int)((double)starty / (factory * (double)epd.scale / 100.0));
                        int imx = (int)((double)max.x * printx / actual_sizex) - 1;
                        int imy = (int)((double)max.y * printy / actual_sizey) - 1;
                        this.printer.startPage();
                        GC gc_printer = new GC((Drawable)this.printer);
                        gc_printer.drawImage(img, fromx, fromy, imx, imy, (int)page_left, (int)pageTop, (int)printx, (int)printy);
                        System.out.println("img dept = " + img.getImageData().depth);
                        System.out.println("prn dept = " + this.printer.getDepth());
                        System.out.println("img size = (" + img.getBounds().x + "," + img.getBounds().y + ") : (" + img.getBounds().width + "," + img.getBounds().height + ")");
                        System.out.println("fromx=" + fromx + ", fromy=" + fromy + ", imx=" + imx + ", imy=" + imy + ", page_left=" + (int)page_left + ", page_top=" + (int)pageTop + ", printx=" + (int)printx + ", printy=" + (int)printy);
                        this.printer.endPage();
                        gc_printer.dispose();
                    }
                }
                this.printer.endJob();
                this.printer.dispose();
            }
            img.dispose();
        }
    }
}

