/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.hop.core.config.DescribedVariable;
import org.apache.hop.core.config.DescribedVariablesConfigFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;

@ExtensionPoint(id="HopImportVariables", description="Imports variables into a Hop project", extensionPointId="HopImportVariables")
public class HopImportVariables
implements IExtensionPoint<Object[]> {
    public void callExtensionPoint(ILogChannel iLogChannel, IVariables variables, Object[] payload) throws HopException {
        String configFilename = (String)payload[0];
        IVariables collectedVariables = (IVariables)payload[1];
        try {
            DescribedVariablesConfigFile configFile = new DescribedVariablesConfigFile(configFilename);
            if (HopVfs.fileExists((String)configFilename)) {
                configFile.readFromFile();
            }
            for (String variableName : collectedVariables.getVariableNames()) {
                String value = collectedVariables.getVariable(variableName);
                DescribedVariable describedVariable = configFile.findDescribedVariable(variableName);
                if (describedVariable == null) {
                    describedVariable = new DescribedVariable();
                    describedVariable.setDescription("Imported from Kettle");
                }
                describedVariable.setName(variableName);
                describedVariable.setValue(value);
                configFile.setDescribedVariable(describedVariable);
            }
            configFile.saveToFile();
        }
        catch (Exception e) {
            throw new HopException("Error importing variables to environment config file '" + configFilename, (Throwable)e);
        }
    }
}

