/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.history.AuditEvent;
import org.apache.hop.history.AuditManager;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.gui.ProjectsGuiPlugin;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;

@ExtensionPoint(id="HopGuiStartProjectLoad", description="Load the previously used project", extensionPointId="HopGuiStart")
public class HopGuiStartProjectLoad
implements IExtensionPoint {
    public void callExtensionPoint(ILogChannel logChannelInterface, IVariables variables, Object o) throws HopException {
        HopGui hopGui = HopGui.getInstance();
        try {
            ProjectsConfig config = ProjectsConfigSingleton.getConfig();
            if (ProjectsConfigSingleton.getConfig().isEnabled()) {
                ProjectConfig projectConfig;
                logChannelInterface.logBasic("Projects enabled");
                String lastProjectName = null;
                List auditEvents = AuditManager.getActive().findEvents("projects", "project", true);
                if (auditEvents.isEmpty()) {
                    lastProjectName = config.getDefaultProject();
                } else {
                    AuditEvent auditEvent;
                    logChannelInterface.logDetailed("Audit events found for hop-gui/project : " + auditEvents.size());
                    Iterator iterator = auditEvents.iterator();
                    while (iterator.hasNext() && (!StringUtils.isNotEmpty((String)(lastProjectName = (auditEvent = (AuditEvent)iterator.next()).getName())) || config.findProjectConfig(lastProjectName) == null)) {
                    }
                }
                if (StringUtils.isNotEmpty((String)lastProjectName) && (projectConfig = config.findProjectConfig(lastProjectName)) != null) {
                    Project project = projectConfig.loadProject(variables);
                    logChannelInterface.logBasic("Enabling project : '" + lastProjectName + "'");
                    LifecycleEnvironment environment = null;
                    List<LifecycleEnvironment> environments = config.findEnvironmentsOfProject(lastProjectName);
                    if (!environments.isEmpty()) {
                        environment = environments.get(0);
                    }
                    ProjectsGuiPlugin.enableHopGuiProject(lastProjectName, project, environment);
                    HopGui.getInstance().setOpeningLastFiles(false);
                }
            } else {
                logChannelInterface.logBasic("No last projects history found");
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error initializing the Projects system", e);
        }
    }
}

