/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileOpenedExtension;

@ExtensionPoint(id="HopGuiFileReplaceHomeVariable", extensionPointId="HopGuiFileOpenedDialog", description="Replace ${PROJECT_HOME} in selected filenames as a best practice aid")
public class HopGuiFileReplaceHomeVariable
implements IExtensionPoint<HopGuiFileOpenedExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiFileOpenedExtension ext) {
        String projectName = HopNamespace.getNamespace();
        if (StringUtil.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            return;
        }
        String homeFolder = projectConfig.getProjectHome();
        try {
            if (StringUtils.isNotEmpty((String)homeFolder)) {
                FileObject file = HopVfs.getFileObject((String)ext.filename);
                String absoluteFile = file.getName().getURI();
                FileObject home = HopVfs.getFileObject((String)homeFolder);
                String absoluteHome = home.getName().getURI();
                if (!absoluteHome.endsWith(Const.FILE_SEPARATOR)) {
                    absoluteHome = absoluteHome + Const.FILE_SEPARATOR;
                }
                if (absoluteFile.startsWith(absoluteHome)) {
                    ext.filename = "${PROJECT_HOME}/" + absoluteFile.substring(absoluteHome.length());
                }
            }
        }
        catch (Exception e) {
            log.logError("Error setting default folder for project " + projectName, (Throwable)e);
        }
    }
}

