/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.project;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.DescribedVariable;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.util.ProjectsUtil;
import picocli.CommandLine;

@ConfigPlugin(id="ManageProjectsOptionPlugin", description="Allows command line editing of the projects")
public class ManageProjectsOptionPlugin
implements IConfigOptions {
    @CommandLine.Option(names={"-pc", "--project-create"}, description={"Create a new project. Also specify the name and its home"})
    private boolean createProject;
    @CommandLine.Option(names={"-p", "--project"}, description={"The name of the project to manage"})
    private String projectName;
    @CommandLine.Option(names={"-ph", "--project-home"}, description={"The home directory of the project"})
    private String projectHome;
    @CommandLine.Option(names={"-pr", "--project-parent"}, description={"The name of the parent project to inherit metadata and variables from"})
    private String projectParent;
    @CommandLine.Option(names={"-pf", "--project-config-file"}, description={"The configuration file relative to the home folder. The default value is project-config.json"})
    private String projectConfigFile;
    @CommandLine.Option(names={"-ps", "--project-description"}, description={"The description of the project"})
    private String projectDescription;
    @CommandLine.Option(names={"-pp", "--project-company"}, description={"The company"})
    private String projectCompany;
    @CommandLine.Option(names={"-pt", "--project-department"}, description={"The department"})
    private String projectDepartment;
    @CommandLine.Option(names={"-pa", "--project-metadata-base"}, description={"The metadata base folder (relative to home)"})
    private String projectMetadataBaseFolder;
    @CommandLine.Option(names={"-pu", "--project-unit-tests-base"}, description={"The unit tests base folder (relative to home)"})
    private String projectUnitTestsBasePath;
    @CommandLine.Option(names={"-pb", "--project-datasets-base"}, description={"The data sets CSV folder (relative to home)"})
    private String projectDataSetsCsvFolder;
    @CommandLine.Option(names={"-px", "--project-enforce-execution"}, description={"Validate before execution that a workflow or pipeline is located in the project home folder or a sub-folder (true/false)."})
    private String projectEnforceExecutionInHome;
    @CommandLine.Option(names={"-pv", "--project-variables"}, description={"A list of variable=value combinations separated by a comma"}, split=",")
    private String[] projectVariables;
    @CommandLine.Option(names={"-pm", "--project-modify"}, description={"Modify a project"})
    private boolean modifyProject;
    @CommandLine.Option(names={"-pd", "--project-delete"}, description={"Delete a project"})
    private boolean deleteProject;
    @CommandLine.Option(names={"-pl", "-projects-list"}, description={"List the defined projects"})
    private boolean listProjects;
    @CommandLine.Option(names={"-xm", "--export-metadata"}, description={"Export project metadata to a single JSON file which you can specify with this option. Also specify the -p option."})
    private String metadataJsonFilename;

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.createProject) {
                this.createProject(log, config, variables);
                changed = true;
            } else if (this.modifyProject) {
                this.modifyProject(log, config, variables);
                changed = true;
            } else if (this.deleteProject) {
                this.deleteProject(log, config, variables);
                changed = true;
            } else if (this.listProjects) {
                this.listProjects(log, config, variables);
                changed = true;
            } else if (StringUtils.isNotEmpty((String)this.metadataJsonFilename)) {
                this.exportMetadataToJson(log, config, variables, hasHopMetadataProvider);
                changed = true;
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling environment configuration options", (Throwable)e);
        }
    }

    private void listProjects(ILogChannel log, ProjectsConfig config, IVariables variables) throws HopException {
        log.logBasic("Projects:");
        List<String> names = config.listProjectConfigNames();
        for (String name : names) {
            ProjectConfig projectConfig = config.findProjectConfig(name);
            try {
                Project project = projectConfig.loadProject(Variables.getADefaultVariableSpace());
                this.logProjectDetails(log, projectConfig, project);
            }
            catch (Exception e) {
                log.logBasic("  " + projectConfig.getProjectName() + " : " + this.projectHome);
                log.logBasic("    Configuration error: " + Const.getSimpleStackTrace((Throwable)e));
            }
        }
    }

    private void logProjectDetails(ILogChannel log, ProjectConfig projectConfig, Project project) throws HopException {
        String projectHome = projectConfig.getProjectHome();
        log.logBasic("  " + projectConfig.getProjectName() + " : " + projectHome);
        if (StringUtils.isNotEmpty((String)project.getParentProjectName())) {
            log.logBasic("    Parent project: " + project.getParentProjectName());
        }
        log.logBasic("    Configuration file: " + projectConfig.getActualProjectConfigFilename(Variables.getADefaultVariableSpace()));
        if (!project.getDescribedVariables().isEmpty()) {
            log.logBasic("    Described variables: ");
            for (DescribedVariable variable : project.getDescribedVariables()) {
                log.logBasic("      " + variable.getName() + " = " + variable.getValue() + (StringUtils.isEmpty((String)variable.getDescription()) ? "" : " (" + variable.getDescription() + ")"));
            }
        }
    }

    private void deleteProject(ILogChannel log, ProjectsConfig config, IVariables variables) throws Exception {
        this.validateProjectNameSpecified();
        ProjectConfig projectConfig = config.findProjectConfig(this.projectName);
        if (projectConfig == null) {
            throw new HopException("Project '" + this.projectName + "' doesn't exists, it can't be deleted");
        }
        config.removeProjectConfig(this.projectName);
        ProjectsConfigSingleton.saveConfig();
        log.logBasic("Project '" + this.projectName + " was removed from the configuration");
    }

    private void modifyProject(ILogChannel log, ProjectsConfig config, IVariables variables) throws Exception {
        this.validateProjectNameSpecified();
        ProjectConfig projectConfig = config.findProjectConfig(this.projectName);
        if (projectConfig == null) {
            throw new HopException("Project '" + this.projectName + "' doesn't exists, it can't be modified");
        }
        if (StringUtils.isNotEmpty((String)this.projectHome)) {
            projectConfig.setProjectHome(this.projectHome);
        }
        if (StringUtils.isNotEmpty((String)this.projectConfigFile)) {
            projectConfig.setConfigFilename(this.projectConfigFile);
        }
        config.addProjectConfig(projectConfig);
        String projectConfigFilename = projectConfig.getActualProjectConfigFilename(variables);
        Project project = projectConfig.loadProject(variables);
        log.logBasic("Project configuration for '" + this.projectName + "' was modified in " + HopConfig.getInstance().getConfigFilename());
        if (this.modifyProjectSettings(project)) {
            project.verifyProjectsChain(this.projectName, variables);
            project.saveToFile();
            log.logBasic("Project settings for '" + this.projectName + "' were modified in file " + projectConfigFilename);
        }
    }

    private boolean modifyProjectSettings(Project project) {
        boolean changed = false;
        if (StringUtils.isNotEmpty((String)this.projectParent)) {
            project.setParentProjectName(this.projectParent);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.projectDescription)) {
            project.setDescription(this.projectDescription);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.projectCompany)) {
            project.setCompany(this.projectCompany);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.projectDepartment)) {
            project.setDepartment(this.projectDepartment);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.projectMetadataBaseFolder)) {
            project.setMetadataBaseFolder(this.projectMetadataBaseFolder);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.projectUnitTestsBasePath)) {
            project.setUnitTestsBasePath(this.projectUnitTestsBasePath);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.projectDataSetsCsvFolder)) {
            project.setDataSetsCsvFolder(this.projectDataSetsCsvFolder);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.projectEnforceExecutionInHome)) {
            boolean enabled = "y".equalsIgnoreCase(this.projectEnforceExecutionInHome) || "true".equalsIgnoreCase(this.projectEnforceExecutionInHome);
            project.setEnforcingExecutionInHome(enabled);
            changed = true;
        }
        if (this.projectVariables != null) {
            for (String projectVariable : this.projectVariables) {
                int equalsIndex = projectVariable.indexOf("=");
                if (equalsIndex <= 0) continue;
                String varName = projectVariable.substring(0, equalsIndex);
                String varValue = projectVariable.substring(equalsIndex + 1);
                DescribedVariable describedVariable = new DescribedVariable(varName, varValue, "");
                project.setDescribedVariable(describedVariable);
                changed = true;
            }
        }
        return changed;
    }

    private void createProject(ILogChannel log, ProjectsConfig config, IVariables variables) throws Exception {
        this.validateProjectNameSpecified();
        this.validateProjectHomeSpecified();
        log.logBasic("Creating project '" + this.projectName + "'");
        ProjectConfig projectConfig = config.findProjectConfig(this.projectName);
        if (projectConfig != null) {
            throw new HopException("Project '" + this.projectName + "' already exists.");
        }
        String defaultProjectConfigFilename = variables.resolve(config.getDefaultProjectConfigFile());
        projectConfig = new ProjectConfig(this.projectName, this.projectHome, Const.NVL((String)this.projectConfigFile, (String)defaultProjectConfigFilename));
        config.addProjectConfig(projectConfig);
        ProjectsConfigSingleton.saveConfig();
        log.logBasic("Project '" + this.projectName + "' was created for home folder : " + this.projectHome);
        Project project = projectConfig.loadProject(variables);
        project.setParentProjectName(config.getStandardParentProject());
        this.modifyProjectSettings(project);
        project.verifyProjectsChain(this.projectName, variables);
        project.saveToFile();
        log.logBasic("Configuration file for project '" + this.projectName + "' was saved to : " + project.getConfigFilename());
    }

    private void validateProjectNameSpecified() throws Exception {
        if (StringUtil.isEmpty((String)this.projectName)) {
            throw new HopException("Please specify the name of the project");
        }
    }

    private void validateProjectHomeSpecified() throws Exception {
        if (StringUtil.isEmpty((String)this.projectHome)) {
            throw new HopException("Please specify the home directory of the project to create");
        }
    }

    private void exportMetadataToJson(ILogChannel log, ProjectsConfig config, IVariables variables, IHasHopMetadataProvider hasHopMetadataProvider) throws HopException {
        if (StringUtils.isEmpty((String)this.projectName)) {
            throw new HopException("Please specify the name of the project for which you want to export the metadata");
        }
        ProjectConfig projectConfig = config.findProjectConfig(this.projectName);
        if (projectConfig == null) {
            throw new HopException("Project '" + this.projectName + "' couldn't be found in the Hop configuration");
        }
        Project project = projectConfig.loadProject(Variables.getADefaultVariableSpace());
        ProjectsUtil.enableProject(log, this.projectName, project, variables, new ArrayList<String>(), null, hasHopMetadataProvider);
        log.logBasic("Enabled project " + this.projectName);
        String realFilename = variables.resolve(this.metadataJsonFilename);
        log.logBasic("Exporting project metadata to a single file: " + realFilename);
        SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(hasHopMetadataProvider.getMetadataProvider());
        String jsonString = metadataProvider.toJson();
        try {
            try (OutputStream outputStream = HopVfs.getOutputStream((String)realFilename, (boolean)false);){
                outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
            }
            log.logBasic("Metadata was exported successfully.");
        }
        catch (Exception e) {
            throw new HopException("There was an error exporting metadata to file: " + realFilename, (Throwable)e);
        }
    }

    public boolean isCreateProject() {
        return this.createProject;
    }

    public void setCreateProject(boolean createProject) {
        this.createProject = createProject;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectHome() {
        return this.projectHome;
    }

    public void setProjectHome(String projectHome) {
        this.projectHome = projectHome;
    }

    public String getProjectConfigFile() {
        return this.projectConfigFile;
    }

    public void setProjectConfigFile(String projectConfigFile) {
        this.projectConfigFile = projectConfigFile;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public String getProjectCompany() {
        return this.projectCompany;
    }

    public void setProjectCompany(String projectCompany) {
        this.projectCompany = projectCompany;
    }

    public String getProjectDepartment() {
        return this.projectDepartment;
    }

    public void setProjectDepartment(String projectDepartment) {
        this.projectDepartment = projectDepartment;
    }

    public String getProjectMetadataBaseFolder() {
        return this.projectMetadataBaseFolder;
    }

    public void setProjectMetadataBaseFolder(String projectMetadataBaseFolder) {
        this.projectMetadataBaseFolder = projectMetadataBaseFolder;
    }

    public String getProjectUnitTestsBasePath() {
        return this.projectUnitTestsBasePath;
    }

    public void setProjectUnitTestsBasePath(String projectUnitTestsBasePath) {
        this.projectUnitTestsBasePath = projectUnitTestsBasePath;
    }

    public String getProjectDataSetsCsvFolder() {
        return this.projectDataSetsCsvFolder;
    }

    public void setProjectDataSetsCsvFolder(String projectDataSetsCsvFolder) {
        this.projectDataSetsCsvFolder = projectDataSetsCsvFolder;
    }

    public String getProjectEnforceExecutionInHome() {
        return this.projectEnforceExecutionInHome;
    }

    public void setProjectEnforceExecutionInHome(String projectEnforceExecutionInHome) {
        this.projectEnforceExecutionInHome = projectEnforceExecutionInHome;
    }

    public String[] getProjectVariables() {
        return this.projectVariables;
    }

    public void setProjectVariables(String[] projectVariables) {
        this.projectVariables = projectVariables;
    }

    public boolean isModifyProject() {
        return this.modifyProject;
    }

    public void setModifyProject(boolean modifyProject) {
        this.modifyProject = modifyProject;
    }

    public boolean isDeleteProject() {
        return this.deleteProject;
    }

    public void setDeleteProject(boolean deleteProject) {
        this.deleteProject = deleteProject;
    }

    public boolean isListProjects() {
        return this.listProjects;
    }

    public void setListProjects(boolean listProjects) {
        this.listProjects = listProjects;
    }

    public String getProjectParent() {
        return this.projectParent;
    }

    public void setProjectParent(String projectParent) {
        this.projectParent = projectParent;
    }
}

