/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.window;

import org.apache.hop.beam.core.BeamDefaults;
import org.apache.hop.beam.transforms.window.BeamWindowMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BeamWindowDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = BeamWindowDialog.class;
    private final BeamWindowMeta input;
    int middle;
    int margin;
    private Combo wWindowType;
    private TextVar wDuration;
    private TextVar wEvery;
    private TextVar wStartTimeField;
    private TextVar wEndTimeField;
    private TextVar wMaxTimeField;

    public BeamWindowDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (BeamWindowMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamWindowDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlWindowType = new Label((Composite)this.shell, 131072);
        wlWindowType.setText(BaseMessages.getString(PKG, (String)"BeamWindowDialog.WindowType", (String[])new String[0]));
        this.props.setLook((Control)wlWindowType);
        FormData fdlWindowType = new FormData();
        fdlWindowType.left = new FormAttachment(0, 0);
        fdlWindowType.top = new FormAttachment((Control)lastControl, this.margin);
        fdlWindowType.right = new FormAttachment(this.middle, -this.margin);
        wlWindowType.setLayoutData((Object)fdlWindowType);
        this.wWindowType = new Combo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wWindowType);
        this.wWindowType.setItems(BeamDefaults.WINDOW_TYPES);
        FormData fdWindowType = new FormData();
        fdWindowType.left = new FormAttachment(this.middle, 0);
        fdWindowType.top = new FormAttachment((Control)wlWindowType, 0, 0x1000000);
        fdWindowType.right = new FormAttachment(100, 0);
        this.wWindowType.setLayoutData((Object)fdWindowType);
        lastControl = this.wWindowType;
        Label wlDuration = new Label((Composite)this.shell, 131072);
        wlDuration.setText(BaseMessages.getString(PKG, (String)"BeamWindowDialog.Duration", (String[])new String[0]));
        this.props.setLook((Control)wlDuration);
        FormData fdlDuration = new FormData();
        fdlDuration.left = new FormAttachment(0, 0);
        fdlDuration.top = new FormAttachment((Control)lastControl, this.margin);
        fdlDuration.right = new FormAttachment(this.middle, -this.margin);
        wlDuration.setLayoutData((Object)fdlDuration);
        this.wDuration = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDuration);
        FormData fdDuration = new FormData();
        fdDuration.left = new FormAttachment(this.middle, 0);
        fdDuration.top = new FormAttachment((Control)wlDuration, 0, 0x1000000);
        fdDuration.right = new FormAttachment(100, 0);
        this.wDuration.setLayoutData((Object)fdDuration);
        lastControl = this.wDuration;
        Label wlEvery = new Label((Composite)this.shell, 131072);
        wlEvery.setText(BaseMessages.getString(PKG, (String)"BeamWindowDialog.Every", (String[])new String[0]));
        this.props.setLook((Control)wlEvery);
        FormData fdlEvery = new FormData();
        fdlEvery.left = new FormAttachment(0, 0);
        fdlEvery.top = new FormAttachment((Control)lastControl, this.margin);
        fdlEvery.right = new FormAttachment(this.middle, -this.margin);
        wlEvery.setLayoutData((Object)fdlEvery);
        this.wEvery = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEvery);
        FormData fdEvery = new FormData();
        fdEvery.left = new FormAttachment(this.middle, 0);
        fdEvery.top = new FormAttachment((Control)wlEvery, 0, 0x1000000);
        fdEvery.right = new FormAttachment(100, 0);
        this.wEvery.setLayoutData((Object)fdEvery);
        lastControl = this.wEvery;
        Label wlStartTimeField = new Label((Composite)this.shell, 131072);
        wlStartTimeField.setText(BaseMessages.getString(PKG, (String)"BeamWindowDialog.StartTimeField", (String[])new String[0]));
        this.props.setLook((Control)wlStartTimeField);
        FormData fdlStartTimeField = new FormData();
        fdlStartTimeField.left = new FormAttachment(0, 0);
        fdlStartTimeField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlStartTimeField.right = new FormAttachment(this.middle, -this.margin);
        wlStartTimeField.setLayoutData((Object)fdlStartTimeField);
        this.wStartTimeField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStartTimeField);
        FormData fdStartTimeField = new FormData();
        fdStartTimeField.left = new FormAttachment(this.middle, 0);
        fdStartTimeField.top = new FormAttachment((Control)wlStartTimeField, 0, 0x1000000);
        fdStartTimeField.right = new FormAttachment(100, 0);
        this.wStartTimeField.setLayoutData((Object)fdStartTimeField);
        lastControl = this.wStartTimeField;
        Label wlEndTimeField = new Label((Composite)this.shell, 131072);
        wlEndTimeField.setText(BaseMessages.getString(PKG, (String)"BeamWindowDialog.EndTimeField", (String[])new String[0]));
        this.props.setLook((Control)wlEndTimeField);
        FormData fdlEndTimeField = new FormData();
        fdlEndTimeField.left = new FormAttachment(0, 0);
        fdlEndTimeField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlEndTimeField.right = new FormAttachment(this.middle, -this.margin);
        wlEndTimeField.setLayoutData((Object)fdlEndTimeField);
        this.wEndTimeField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEndTimeField);
        FormData fdEndTimeField = new FormData();
        fdEndTimeField.left = new FormAttachment(this.middle, 0);
        fdEndTimeField.top = new FormAttachment((Control)wlEndTimeField, 0, 0x1000000);
        fdEndTimeField.right = new FormAttachment(100, 0);
        this.wEndTimeField.setLayoutData((Object)fdEndTimeField);
        lastControl = this.wEndTimeField;
        Label wlMaxTimeField = new Label((Composite)this.shell, 131072);
        wlMaxTimeField.setText(BaseMessages.getString(PKG, (String)"BeamWindowDialog.MaxTimeField", (String[])new String[0]));
        this.props.setLook((Control)wlMaxTimeField);
        FormData fdlMaxTimeField = new FormData();
        fdlMaxTimeField.left = new FormAttachment(0, 0);
        fdlMaxTimeField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlMaxTimeField.right = new FormAttachment(this.middle, -this.margin);
        wlMaxTimeField.setLayoutData((Object)fdlMaxTimeField);
        this.wMaxTimeField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wMaxTimeField);
        FormData fdMaxTimeField = new FormData();
        fdMaxTimeField.left = new FormAttachment(this.middle, 0);
        fdMaxTimeField.top = new FormAttachment((Control)wlMaxTimeField, 0, 0x1000000);
        fdMaxTimeField.right = new FormAttachment(100, 0);
        this.wMaxTimeField.setLayoutData((Object)fdMaxTimeField);
        lastControl = this.wMaxTimeField;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wWindowType.setText(Const.NVL((String)this.input.getWindowType(), (String)""));
        this.wDuration.setText(Const.NVL((String)this.input.getDuration(), (String)""));
        this.wEvery.setText(Const.NVL((String)this.input.getEvery(), (String)""));
        this.wStartTimeField.setText(Const.NVL((String)this.input.getStartWindowField(), (String)""));
        this.wEndTimeField.setText(Const.NVL((String)this.input.getEndWindowField(), (String)""));
        this.wMaxTimeField.setText(Const.NVL((String)this.input.getMaxWindowField(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamWindowMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setWindowType(this.wWindowType.getText());
        in.setDuration(this.wDuration.getText());
        in.setEvery(this.wEvery.getText());
        in.setStartWindowField(this.wStartTimeField.getText());
        in.setEndWindowField(this.wEndTimeField.getText());
        in.setMaxWindowField(this.wMaxTimeField.getText());
        this.input.setChanged();
    }
}

