/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.window;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.TimestampFn;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.window.BeamTimestampDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.Dummy;
import org.apache.hop.pipeline.transforms.dummy.DummyData;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;

@Transform(id="BeamTimestamp", name="Beam Timestamp", description="Add timestamps to a bounded data source", image="beam-timestamp.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", documentationUrl="/pipeline/transforms/beamtimestamp.html")
public class BeamTimestampMeta
extends BaseTransformMeta
implements ITransformMeta<Dummy, DummyData>,
IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="field_name")
    private String fieldName = "";
    @HopMetadataProperty(key="read_timestamp")
    private boolean readingTimestamp;

    public Dummy createTransform(TransformMeta transformMeta, DummyData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new Dummy(transformMeta, new DummyMeta(), data, copyNr, pipelineMeta, pipeline);
    }

    public DummyData getTransformData() {
        return new DummyData();
    }

    public String getDialogClassName() {
        return BeamTimestampDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.readingTimestamp) {
            ValueMetaDate valueMeta = new ValueMetaDate(this.fieldName);
            valueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)valueMeta);
        }
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, org.apache.beam.sdk.Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        if (!this.readingTimestamp && StringUtils.isNotEmpty((String)this.fieldName) && rowMeta.searchValueMeta(this.fieldName) == null) {
            throw new HopException("Please specify a valid field name '" + transformMeta.getName() + "'");
        }
        PCollection transformPCollection = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new TimestampFn(transformMeta.getName(), JsonRowMeta.toJson(rowMeta), variables.resolve(this.fieldName), this.readingTimestamp, transformPluginClasses, xpPluginClasses)));
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)transformPCollection);
        log.logBasic("Handled transform (TIMESTAMP) : " + transformMeta.getName() + ", gets data from " + previousTransforms.size() + " previous transform(s)");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isReadingTimestamp() {
        return this.readingTimestamp;
    }

    public void setReadingTimestamp(boolean readingTimestamp) {
        this.readingTimestamp = readingTimestamp;
    }
}

