/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.pubsub;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamSubscribeTransform;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.pubsub.BeamSubscribe;
import org.apache.hop.beam.transforms.pubsub.BeamSubscribeData;
import org.apache.hop.beam.transforms.pubsub.BeamSubscribeDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaSerializable;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="BeamSubscribe", name="Beam GCP Pub/Sub : Subscribe", description="Subscribe to data from a Pub/Sub topic", image="beam-gcp-pubsub-subscribe.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", documentationUrl="/pipeline/transforms/beamgcpsubscriber.html")
public class BeamSubscribeMeta
extends BaseTransformMeta
implements ITransformMeta<BeamSubscribe, BeamSubscribeData>,
IBeamPipelineTransformHandler {
    @HopMetadataProperty
    private String topic = "Topic";
    @HopMetadataProperty
    private String subscription = "Subscription";
    @HopMetadataProperty(key="message_type")
    private String messageType = "String";
    @HopMetadataProperty(key="message_field")
    private String messageField = "message";

    public BeamSubscribe createTransform(TransformMeta transformMeta, BeamSubscribeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new BeamSubscribe(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public BeamSubscribeData getTransformData() {
        return new BeamSubscribeData();
    }

    public String getDialogClassName() {
        return BeamSubscribeDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (StringUtils.isEmpty((String)this.messageType)) {
            throw new HopTransformException("You need to specify the type of message to read");
        }
        if (StringUtils.isEmpty((String)this.messageField)) {
            throw new HopTransformException("You need to specify the field name of the message to read");
        }
        String type = variables.resolve(this.messageType);
        String fieldName = variables.resolve(this.messageField);
        Object valueMeta = "String".equalsIgnoreCase(type) ? new ValueMetaString(fieldName) : new ValueMetaSerializable(fieldName);
        valueMeta.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)valueMeta);
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, org.apache.beam.sdk.Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        IRowMeta outputRowMeta = pipelineMeta.getTransformFields(variables, transformMeta);
        String rowMetaJson = JsonRowMeta.toJson(outputRowMeta);
        if (StringUtils.isEmpty((String)this.topic)) {
            throw new HopException("Please specify a topic to read from in Beam Pub/Sub Subscribe transform '" + transformMeta.getName() + "'");
        }
        BeamSubscribeTransform subscribeTransform = new BeamSubscribeTransform(transformMeta.getName(), transformMeta.getName(), variables.resolve(this.subscription), variables.resolve(this.topic), this.messageType, rowMetaJson, transformPluginClasses, xpPluginClasses);
        PCollection afterInput = (PCollection)pipeline.apply((PTransform)subscribeTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (SUBSCRIBE) : " + transformMeta.getName());
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }
}

