/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kafka;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamKafkaOutputTransform;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.kafka.BeamProduce;
import org.apache.hop.beam.transforms.kafka.BeamProduceDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyData;

@Transform(id="BeamKafkaProduce", name="Beam Kafka Produce", description="Send messages to a Kafka Topic (Producer)", image="beam-kafka-output.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", documentationUrl="/pipeline/transforms/beamkafkaproduce.html")
public class BeamProduceMeta
extends BaseTransformMeta
implements ITransformMeta<BeamProduce, DummyData>,
IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="bootstrap_servers")
    private String bootstrapServers = "bootstrapServer1:9001,bootstrapServer2:9001";
    @HopMetadataProperty
    private String topic = "Topic1";
    @HopMetadataProperty(key="key_field")
    private String keyField = "";
    @HopMetadataProperty(key="message_field")
    private String messageField = "";

    public BeamProduce createTransform(TransformMeta transformMeta, DummyData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new BeamProduce(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public DummyData getTransformData() {
        return new DummyData();
    }

    public String getDialogClassName() {
        return BeamProduceDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, org.apache.beam.sdk.Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        BeamKafkaOutputTransform beamOutputTransform = new BeamKafkaOutputTransform(transformMeta.getName(), variables.resolve(this.getBootstrapServers()), variables.resolve(this.getTopic()), variables.resolve(this.getKeyField()), variables.resolve(this.getMessageField()), JsonRowMeta.toJson(rowMeta), transformPluginClasses, xpPluginClasses);
        if (previousTransforms.size() > 1) {
            throw new HopException("Combining data from multiple transforms is not supported yet!");
        }
        TransformMeta previousTransform = previousTransforms.get(0);
        input.apply((PTransform)beamOutputTransform);
        log.logBasic("Handled transform (KAFKA OUTPUT) : " + transformMeta.getName() + ", gets data from " + previousTransform.getName());
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }
}

