/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamKafkaInputTransform;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.kafka.BeamConsume;
import org.apache.hop.beam.transforms.kafka.BeamConsumeDialog;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyData;

@Transform(id="BeamKafkaConsume", name="Beam Kafka Consume", description="Get messages from Kafka topics (Kafka Consumer)", image="beam-kafka-input.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", documentationUrl="/pipeline/transforms/beamkafkaconsume.html")
public class BeamConsumeMeta
extends BaseTransformMeta
implements ITransformMeta<BeamConsume, DummyData>,
IBeamPipelineTransformHandler {
    @HopMetadataProperty
    private String topics;
    @HopMetadataProperty(key="bootstrap_servers")
    private String bootstrapServers;
    @HopMetadataProperty(key="key_field")
    private String keyField;
    @HopMetadataProperty(key="message_field")
    private String messageField;
    @HopMetadataProperty(key="group_id")
    private String groupId;
    @HopMetadataProperty(key="use_processing_time")
    private boolean usingProcessingTime;
    @HopMetadataProperty(key="use_log_append_time")
    private boolean usingLogAppendTime;
    @HopMetadataProperty(key="use_create_time")
    private boolean usingCreateTime;
    @HopMetadataProperty(key="restrict_to_committed")
    private boolean restrictedToCommitted;
    @HopMetadataProperty(key="allow_commit_on_consumed")
    private boolean allowingCommitOnConsumedOffset;
    @HopMetadataProperty(groupKey="config_options", key="config_option")
    private List<ConfigOption> configOptions = new ArrayList<ConfigOption>();

    public void setDefault() {
        this.bootstrapServers = "bootstrapServer1:9001,bootstrapServer2:9001";
        this.topics = "Topic1,Topic2";
        this.keyField = "key";
        this.messageField = "message";
        this.groupId = "GroupID";
        this.usingProcessingTime = true;
        this.usingLogAppendTime = false;
        this.usingCreateTime = false;
        this.restrictedToCommitted = false;
        this.allowingCommitOnConsumedOffset = true;
        this.configOptions = new ArrayList<ConfigOption>();
    }

    public BeamConsume createTransform(TransformMeta transformMeta, DummyData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new BeamConsume(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public DummyData getTransformData() {
        return new DummyData();
    }

    public String getDialogClassName() {
        return BeamConsumeDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString keyValueMeta = new ValueMetaString(variables.resolve(this.keyField));
        keyValueMeta.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)keyValueMeta);
        ValueMetaString messageValueMeta = new ValueMetaString(variables.resolve(this.messageField));
        messageValueMeta.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)messageValueMeta);
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, org.apache.beam.sdk.Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        RowMeta outputRowMeta = new RowMeta();
        this.getFields((IRowMeta)outputRowMeta, transformMeta.getName(), null, null, variables, null);
        String[] parameters = new String[this.getConfigOptions().size()];
        String[] values = new String[this.getConfigOptions().size()];
        String[] types = new String[this.getConfigOptions().size()];
        for (int i = 0; i < parameters.length; ++i) {
            ConfigOption option = this.getConfigOptions().get(i);
            parameters[i] = variables.resolve(option.getParameter());
            values[i] = variables.resolve(option.getValue());
            types[i] = option.getType() == null ? ConfigOption.Type.String.name() : option.getType().name();
        }
        BeamKafkaInputTransform beamInputTransform = new BeamKafkaInputTransform(transformMeta.getName(), transformMeta.getName(), variables.resolve(this.getBootstrapServers()), variables.resolve(this.getTopics()), variables.resolve(this.getGroupId()), this.isUsingProcessingTime(), this.isUsingLogAppendTime(), this.isUsingCreateTime(), this.isRestrictedToCommitted(), this.isAllowingCommitOnConsumedOffset(), parameters, values, types, JsonRowMeta.toJson((IRowMeta)outputRowMeta), transformPluginClasses, xpPluginClasses);
        PCollection afterInput = (PCollection)pipeline.apply((PTransform)beamInputTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (KAFKA INPUT) : " + transformMeta.getName());
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getTopics() {
        return this.topics;
    }

    public void setTopics(String topics) {
        this.topics = topics;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isUsingProcessingTime() {
        return this.usingProcessingTime;
    }

    public void setUsingProcessingTime(boolean usingProcessingTime) {
        this.usingProcessingTime = usingProcessingTime;
    }

    public boolean isUsingLogAppendTime() {
        return this.usingLogAppendTime;
    }

    public void setUsingLogAppendTime(boolean usingLogAppendTime) {
        this.usingLogAppendTime = usingLogAppendTime;
    }

    public boolean isUsingCreateTime() {
        return this.usingCreateTime;
    }

    public void setUsingCreateTime(boolean usingCreateTime) {
        this.usingCreateTime = usingCreateTime;
    }

    public boolean isRestrictedToCommitted() {
        return this.restrictedToCommitted;
    }

    public void setRestrictedToCommitted(boolean restrictedToCommitted) {
        this.restrictedToCommitted = restrictedToCommitted;
    }

    public boolean isAllowingCommitOnConsumedOffset() {
        return this.allowingCommitOnConsumedOffset;
    }

    public void setAllowingCommitOnConsumedOffset(boolean allowingCommitOnConsumedOffset) {
        this.allowingCommitOnConsumedOffset = allowingCommitOnConsumedOffset;
    }

    public List<ConfigOption> getConfigOptions() {
        return this.configOptions;
    }

    public void setConfigOptions(List<ConfigOption> configOptions) {
        this.configOptions = configOptions;
    }
}

