/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kafka;

import org.apache.hop.beam.transforms.kafka.BeamConsume;
import org.apache.hop.beam.transforms.kafka.BeamConsumeMeta;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BeamConsumeDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = BeamConsume.class;
    private final BeamConsumeMeta input;
    int middle;
    int margin;
    private TextVar wBootstrapServers;
    private TextVar wTopics;
    private TextVar wGroupId;
    private TextVar wKeyField;
    private TextVar wMessageField;
    private Button wUseProcessingTime;
    private Button wUseLogAppendTime;
    private Button wUseCreateTime;
    private Button wRestrictToCommitted;
    private Button wAllowCommitConsumed;
    private TableView wConfigOptions;

    public BeamConsumeDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (BeamConsumeMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamConsumeDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlBootstrapServers = new Label((Composite)this.shell, 131072);
        wlBootstrapServers.setText(BaseMessages.getString(PKG, (String)"BeamConsumeDialog.BootstrapServers", (String[])new String[0]));
        this.props.setLook((Control)wlBootstrapServers);
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment(0, 0);
        fdlBootstrapServers.top = new FormAttachment((Control)lastControl, this.margin);
        fdlBootstrapServers.right = new FormAttachment(this.middle, -this.margin);
        wlBootstrapServers.setLayoutData((Object)fdlBootstrapServers);
        this.wBootstrapServers = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBootstrapServers);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment(this.middle, 0);
        fdBootstrapServers.top = new FormAttachment((Control)wlBootstrapServers, 0, 0x1000000);
        fdBootstrapServers.right = new FormAttachment(100, 0);
        this.wBootstrapServers.setLayoutData((Object)fdBootstrapServers);
        lastControl = this.wBootstrapServers;
        Label wlTopics = new Label((Composite)this.shell, 131072);
        wlTopics.setText(BaseMessages.getString(PKG, (String)"BeamConsumeDialog.Topics", (String[])new String[0]));
        this.props.setLook((Control)wlTopics);
        FormData fdlTopics = new FormData();
        fdlTopics.left = new FormAttachment(0, 0);
        fdlTopics.top = new FormAttachment((Control)lastControl, this.margin);
        fdlTopics.right = new FormAttachment(this.middle, -this.margin);
        wlTopics.setLayoutData((Object)fdlTopics);
        this.wTopics = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTopics);
        FormData fdTopics = new FormData();
        fdTopics.left = new FormAttachment(this.middle, 0);
        fdTopics.top = new FormAttachment((Control)wlTopics, 0, 0x1000000);
        fdTopics.right = new FormAttachment(100, 0);
        this.wTopics.setLayoutData((Object)fdTopics);
        lastControl = this.wTopics;
        Label wlGroupId = new Label((Composite)this.shell, 131072);
        wlGroupId.setText(BaseMessages.getString(PKG, (String)"BeamConsumeDialog.GroupId", (String[])new String[0]));
        this.props.setLook((Control)wlGroupId);
        FormData fdlGroupId = new FormData();
        fdlGroupId.left = new FormAttachment(0, 0);
        fdlGroupId.top = new FormAttachment((Control)lastControl, this.margin);
        fdlGroupId.right = new FormAttachment(this.middle, -this.margin);
        wlGroupId.setLayoutData((Object)fdlGroupId);
        this.wGroupId = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wGroupId);
        FormData fdGroupId = new FormData();
        fdGroupId.left = new FormAttachment(this.middle, 0);
        fdGroupId.top = new FormAttachment((Control)wlGroupId, 0, 0x1000000);
        fdGroupId.right = new FormAttachment(100, 0);
        this.wGroupId.setLayoutData((Object)fdGroupId);
        lastControl = this.wGroupId;
        Label wlKeyField = new Label((Composite)this.shell, 131072);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"BeamConsumeDialog.KeyField", (String[])new String[0]));
        this.props.setLook((Control)wlKeyField);
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlKeyField.right = new FormAttachment(this.middle, -this.margin);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        this.wKeyField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wKeyField);
        FormData fdKeyField = new FormData();
        fdKeyField.left = new FormAttachment(this.middle, 0);
        fdKeyField.top = new FormAttachment((Control)wlKeyField, 0, 0x1000000);
        fdKeyField.right = new FormAttachment(100, 0);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        lastControl = this.wKeyField;
        Label wlMessageField = new Label((Composite)this.shell, 131072);
        wlMessageField.setText(BaseMessages.getString(PKG, (String)"BeamConsumeDialog.MessageField", (String[])new String[0]));
        this.props.setLook((Control)wlMessageField);
        FormData fdlMessageField = new FormData();
        fdlMessageField.left = new FormAttachment(0, 0);
        fdlMessageField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlMessageField.right = new FormAttachment(this.middle, -this.margin);
        wlMessageField.setLayoutData((Object)fdlMessageField);
        this.wMessageField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wMessageField);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(this.middle, 0);
        fdMessageField.top = new FormAttachment((Control)wlMessageField, 0, 0x1000000);
        fdMessageField.right = new FormAttachment(100, 0);
        this.wMessageField.setLayoutData((Object)fdMessageField);
        lastControl = this.wMessageField;
        Label wlUseProcessingTime = new Label((Composite)this.shell, 131072);
        wlUseProcessingTime.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.UseProcessingTime", (String[])new String[0]));
        this.props.setLook((Control)wlUseProcessingTime);
        FormData fdlUseProcessingTime = new FormData();
        fdlUseProcessingTime.left = new FormAttachment(0, 0);
        fdlUseProcessingTime.top = new FormAttachment((Control)lastControl, this.margin);
        fdlUseProcessingTime.right = new FormAttachment(this.middle, -this.margin);
        wlUseProcessingTime.setLayoutData((Object)fdlUseProcessingTime);
        this.wUseProcessingTime = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wUseProcessingTime);
        FormData fdUseProcessingTime = new FormData();
        fdUseProcessingTime.left = new FormAttachment(this.middle, 0);
        fdUseProcessingTime.top = new FormAttachment((Control)wlUseProcessingTime, 0, 0x1000000);
        fdUseProcessingTime.right = new FormAttachment(100, 0);
        this.wUseProcessingTime.setLayoutData((Object)fdUseProcessingTime);
        lastControl = this.wUseProcessingTime;
        Label wlUseLogAppendTime = new Label((Composite)this.shell, 131072);
        wlUseLogAppendTime.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.UseLogAppendTime", (String[])new String[0]));
        this.props.setLook((Control)wlUseLogAppendTime);
        FormData fdlUseLogAppendTime = new FormData();
        fdlUseLogAppendTime.left = new FormAttachment(0, 0);
        fdlUseLogAppendTime.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        fdlUseLogAppendTime.right = new FormAttachment(this.middle, -this.margin);
        wlUseLogAppendTime.setLayoutData((Object)fdlUseLogAppendTime);
        this.wUseLogAppendTime = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wUseLogAppendTime);
        FormData fdUseLogAppendTime = new FormData();
        fdUseLogAppendTime.left = new FormAttachment(this.middle, 0);
        fdUseLogAppendTime.top = new FormAttachment((Control)wlUseLogAppendTime, 0, 0x1000000);
        fdUseLogAppendTime.right = new FormAttachment(100, 0);
        this.wUseLogAppendTime.setLayoutData((Object)fdUseLogAppendTime);
        lastControl = this.wUseLogAppendTime;
        Label wlUseCreateTime = new Label((Composite)this.shell, 131072);
        wlUseCreateTime.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.UseCreateTime", (String[])new String[0]));
        this.props.setLook((Control)wlUseCreateTime);
        FormData fdlUseCreateTime = new FormData();
        fdlUseCreateTime.left = new FormAttachment(0, 0);
        fdlUseCreateTime.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        fdlUseCreateTime.right = new FormAttachment(this.middle, -this.margin);
        wlUseCreateTime.setLayoutData((Object)fdlUseCreateTime);
        this.wUseCreateTime = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wUseCreateTime);
        FormData fdUseCreateTime = new FormData();
        fdUseCreateTime.left = new FormAttachment(this.middle, 0);
        fdUseCreateTime.top = new FormAttachment((Control)wlUseCreateTime, 0, 0x1000000);
        fdUseCreateTime.right = new FormAttachment(100, 0);
        this.wUseCreateTime.setLayoutData((Object)fdUseCreateTime);
        lastControl = this.wUseCreateTime;
        Label wlRestrictToCommitted = new Label((Composite)this.shell, 131072);
        wlRestrictToCommitted.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.RestrictToCommitted", (String[])new String[0]));
        this.props.setLook((Control)wlRestrictToCommitted);
        FormData fdlRestrictToCommitted = new FormData();
        fdlRestrictToCommitted.left = new FormAttachment(0, 0);
        fdlRestrictToCommitted.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        fdlRestrictToCommitted.right = new FormAttachment(this.middle, -this.margin);
        wlRestrictToCommitted.setLayoutData((Object)fdlRestrictToCommitted);
        this.wRestrictToCommitted = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wRestrictToCommitted);
        FormData fdRestrictToCommitted = new FormData();
        fdRestrictToCommitted.left = new FormAttachment(this.middle, 0);
        fdRestrictToCommitted.top = new FormAttachment((Control)wlRestrictToCommitted, 0, 0x1000000);
        fdRestrictToCommitted.right = new FormAttachment(100, 0);
        this.wRestrictToCommitted.setLayoutData((Object)fdRestrictToCommitted);
        lastControl = wlRestrictToCommitted;
        Label wlAllowCommitConsumed = new Label((Composite)this.shell, 131072);
        wlAllowCommitConsumed.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.AllowCommitConsumed", (String[])new String[0]));
        this.props.setLook((Control)wlAllowCommitConsumed);
        FormData fdlAllowCommitConsumed = new FormData();
        fdlAllowCommitConsumed.left = new FormAttachment(0, 0);
        fdlAllowCommitConsumed.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        fdlAllowCommitConsumed.right = new FormAttachment(this.middle, -this.margin);
        wlAllowCommitConsumed.setLayoutData((Object)fdlAllowCommitConsumed);
        this.wAllowCommitConsumed = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wAllowCommitConsumed);
        FormData fdAllowCommitConsumed = new FormData();
        fdAllowCommitConsumed.left = new FormAttachment(this.middle, 0);
        fdAllowCommitConsumed.top = new FormAttachment((Control)wlAllowCommitConsumed, 0, 0x1000000);
        fdAllowCommitConsumed.right = new FormAttachment(100, 0);
        this.wAllowCommitConsumed.setLayoutData((Object)fdAllowCommitConsumed);
        lastControl = wlAllowCommitConsumed;
        Label wlConfigOptions = new Label((Composite)this.shell, 16384);
        wlConfigOptions.setText(BaseMessages.getString(PKG, (String)"BeamProduceDialog.ConfigOptions", (String[])new String[0]));
        this.props.setLook((Control)wlConfigOptions);
        FormData fdlConfigOptions = new FormData();
        fdlConfigOptions.left = new FormAttachment(0, 0);
        fdlConfigOptions.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        fdlConfigOptions.right = new FormAttachment(100, 0);
        wlConfigOptions.setLayoutData((Object)fdlConfigOptions);
        lastControl = wlConfigOptions;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamProduceDialog.ConfigOptions.Column.Parameter", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamProduceDialog.ConfigOptions.Column.Value", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamProduceDialog.ConfigOptions.Column.Type", (String[])new String[0]), 2, ConfigOption.Type.getTypeNames(), true)};
        columns[0].setUsingVariables(true);
        columns[1].setUsingVariables(true);
        this.wConfigOptions = new TableView(this.variables, (Composite)this.shell, 0, columns, this.input.getConfigOptions().size(), null, this.props);
        this.props.setLook((Control)this.wConfigOptions);
        FormData fdConfigOptions = new FormData();
        fdConfigOptions.left = new FormAttachment(0, 0);
        fdConfigOptions.right = new FormAttachment(100, 0);
        fdConfigOptions.top = new FormAttachment((Control)lastControl, this.margin);
        fdConfigOptions.bottom = new FormAttachment((Control)this.wOk, -this.margin * 2);
        this.wConfigOptions.setLayoutData((Object)fdConfigOptions);
        lastControl = this.wConfigOptions;
        this.wUseProcessingTime.addListener(13, e -> {
            this.wUseLogAppendTime.setSelection(false);
            this.wUseCreateTime.setSelection(false);
        });
        this.wUseLogAppendTime.addListener(13, e -> {
            this.wUseProcessingTime.setSelection(false);
            this.wUseCreateTime.setSelection(false);
        });
        this.wUseCreateTime.addListener(13, e -> {
            this.wUseProcessingTime.setSelection(false);
            this.wUseLogAppendTime.setSelection(false);
        });
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wBootstrapServers.setText(Const.NVL((String)this.input.getBootstrapServers(), (String)""));
        this.wTopics.setText(Const.NVL((String)this.input.getTopics(), (String)""));
        this.wGroupId.setText(Const.NVL((String)this.input.getGroupId(), (String)""));
        this.wKeyField.setText(Const.NVL((String)this.input.getKeyField(), (String)""));
        this.wMessageField.setText(Const.NVL((String)this.input.getMessageField(), (String)""));
        this.wUseProcessingTime.setSelection(this.input.isUsingProcessingTime());
        this.wUseLogAppendTime.setSelection(this.input.isUsingLogAppendTime());
        this.wUseCreateTime.setSelection(this.input.isUsingCreateTime());
        this.wRestrictToCommitted.setSelection(this.input.isRestrictedToCommitted());
        this.wAllowCommitConsumed.setSelection(this.input.isAllowingCommitOnConsumedOffset());
        for (int i = 0; i < this.input.getConfigOptions().size(); ++i) {
            ConfigOption option = this.input.getConfigOptions().get(i);
            TableItem item = this.wConfigOptions.table.getItem(i);
            item.setText(1, Const.NVL((String)option.getParameter(), (String)""));
            item.setText(2, Const.NVL((String)option.getValue(), (String)""));
            item.setText(3, option.getType() != null ? option.getType().name() : "");
        }
        this.wConfigOptions.removeEmptyRows();
        this.wConfigOptions.setRowNums();
        this.wConfigOptions.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamConsumeMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setBootstrapServers(this.wBootstrapServers.getText());
        in.setTopics(this.wTopics.getText());
        in.setKeyField(this.wKeyField.getText());
        in.setMessageField(this.wMessageField.getText());
        in.setGroupId(this.wGroupId.getText());
        in.setUsingProcessingTime(this.wUseProcessingTime.getSelection());
        in.setUsingLogAppendTime(this.wUseLogAppendTime.getSelection());
        in.setUsingCreateTime(this.wUseCreateTime.getSelection());
        in.setRestrictedToCommitted(this.wRestrictToCommitted.getSelection());
        in.setAllowingCommitOnConsumedOffset(this.wAllowCommitConsumed.getSelection());
        int nr = this.wConfigOptions.nrNonEmpty();
        in.getConfigOptions().clear();
        for (int i = 0; i < nr; ++i) {
            TableItem item = this.wConfigOptions.getNonEmpty(i);
            String parameter = item.getText(1);
            String value = item.getText(2);
            ConfigOption.Type type = ConfigOption.Type.getTypeFromName(item.getText(3));
            in.getConfigOptions().add(new ConfigOption(parameter, value, type));
        }
        this.input.setChanged();
    }
}

