/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.io;

import org.apache.hop.beam.metadata.FileDefinition;
import org.apache.hop.beam.transforms.io.BeamInput;
import org.apache.hop.beam.transforms.io.BeamInputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BeamInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = BeamInput.class;
    private final BeamInputMeta input;
    int middle;
    int margin;
    private boolean getpreviousFields = false;
    private TextVar wInputLocation;
    private MetaSelectionLine<FileDefinition> wFileDefinition;

    public BeamInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (BeamInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamInputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        MetaSelectionLine<FileDefinition> lastControl = this.wTransformName;
        Label wlInputLocation = new Label((Composite)this.shell, 131072);
        wlInputLocation.setText(BaseMessages.getString(PKG, (String)"BeamInputDialog.InputLocation", (String[])new String[0]));
        this.props.setLook((Control)wlInputLocation);
        FormData fdlInputLocation = new FormData();
        fdlInputLocation.left = new FormAttachment(0, 0);
        fdlInputLocation.top = new FormAttachment((Control)lastControl, this.margin);
        fdlInputLocation.right = new FormAttachment(this.middle, -this.margin);
        wlInputLocation.setLayoutData((Object)fdlInputLocation);
        this.wInputLocation = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wInputLocation);
        FormData fdInputLocation = new FormData();
        fdInputLocation.left = new FormAttachment(this.middle, 0);
        fdInputLocation.top = new FormAttachment((Control)wlInputLocation, 0, 0x1000000);
        fdInputLocation.right = new FormAttachment(100, 0);
        this.wInputLocation.setLayoutData((Object)fdInputLocation);
        lastControl = this.wInputLocation;
        this.wFileDefinition = new MetaSelectionLine(this.variables, this.metadataProvider, FileDefinition.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"BeamInputDialog.FileDefinition", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BeamInputDialog.FileDefinition", (String[])new String[0]));
        this.props.setLook(this.wFileDefinition);
        FormData fdFileDefinition = new FormData();
        fdFileDefinition.left = new FormAttachment(0, 0);
        fdFileDefinition.top = new FormAttachment((Control)lastControl, this.margin);
        fdFileDefinition.right = new FormAttachment(100, 0);
        this.wFileDefinition.setLayoutData((Object)fdFileDefinition);
        lastControl = this.wFileDefinition;
        try {
            this.wFileDefinition.fillItems();
        }
        catch (Exception e2) {
            this.log.logError("Error getting file definition items", (Throwable)e2);
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wFileDefinition.setText(Const.NVL((String)this.input.getFileDefinitionName(), (String)""));
        this.wInputLocation.setText(Const.NVL((String)this.input.getInputLocation(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamInputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setFileDefinitionName(this.wFileDefinition.getText());
        in.setInputLocation(this.wInputLocation.getText());
        this.input.setChanged();
    }
}

