/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bq;

import org.apache.hop.beam.transforms.bq.BeamBQOutputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BeamBQOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = BeamBQOutputDialog.class;
    private final BeamBQOutputMeta input;
    int middle;
    int margin;
    private TextVar wProjectId;
    private TextVar wDatasetId;
    private TextVar wTableId;
    private Button wCreateIfNeeded;
    private Button wTruncateTable;
    private Button wFailIfNotEmpty;

    public BeamBQOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (BeamBQOutputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamBQOutputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlProjectId = new Label((Composite)this.shell, 131072);
        wlProjectId.setText(BaseMessages.getString(PKG, (String)"BeamBQOutputDialog.ProjectId", (String[])new String[0]));
        this.props.setLook((Control)wlProjectId);
        FormData fdlProjectId = new FormData();
        fdlProjectId.left = new FormAttachment(0, 0);
        fdlProjectId.top = new FormAttachment((Control)lastControl, this.margin);
        fdlProjectId.right = new FormAttachment(this.middle, -this.margin);
        wlProjectId.setLayoutData((Object)fdlProjectId);
        this.wProjectId = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wProjectId);
        FormData fdProjectId = new FormData();
        fdProjectId.left = new FormAttachment(this.middle, 0);
        fdProjectId.top = new FormAttachment((Control)wlProjectId, 0, 0x1000000);
        fdProjectId.right = new FormAttachment(100, 0);
        this.wProjectId.setLayoutData((Object)fdProjectId);
        lastControl = this.wProjectId;
        Label wlDatasetId = new Label((Composite)this.shell, 131072);
        wlDatasetId.setText(BaseMessages.getString(PKG, (String)"BeamBQOutputDialog.DatasetId", (String[])new String[0]));
        this.props.setLook((Control)wlDatasetId);
        FormData fdlDatasetId = new FormData();
        fdlDatasetId.left = new FormAttachment(0, 0);
        fdlDatasetId.top = new FormAttachment((Control)lastControl, this.margin);
        fdlDatasetId.right = new FormAttachment(this.middle, -this.margin);
        wlDatasetId.setLayoutData((Object)fdlDatasetId);
        this.wDatasetId = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDatasetId);
        FormData fdDatasetId = new FormData();
        fdDatasetId.left = new FormAttachment(this.middle, 0);
        fdDatasetId.top = new FormAttachment((Control)wlDatasetId, 0, 0x1000000);
        fdDatasetId.right = new FormAttachment(100, 0);
        this.wDatasetId.setLayoutData((Object)fdDatasetId);
        lastControl = this.wDatasetId;
        Label wlTableId = new Label((Composite)this.shell, 131072);
        wlTableId.setText(BaseMessages.getString(PKG, (String)"BeamBQOutputDialog.TableId", (String[])new String[0]));
        this.props.setLook((Control)wlTableId);
        FormData fdlTableId = new FormData();
        fdlTableId.left = new FormAttachment(0, 0);
        fdlTableId.top = new FormAttachment((Control)lastControl, this.margin);
        fdlTableId.right = new FormAttachment(this.middle, -this.margin);
        wlTableId.setLayoutData((Object)fdlTableId);
        this.wTableId = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTableId);
        FormData fdTableId = new FormData();
        fdTableId.left = new FormAttachment(this.middle, 0);
        fdTableId.top = new FormAttachment((Control)wlTableId, 0, 0x1000000);
        fdTableId.right = new FormAttachment(100, 0);
        this.wTableId.setLayoutData((Object)fdTableId);
        lastControl = this.wTableId;
        Label wlCreateIfNeeded = new Label((Composite)this.shell, 131072);
        wlCreateIfNeeded.setText(BaseMessages.getString(PKG, (String)"BeamBQOutputDialog.CreateIfNeeded", (String[])new String[0]));
        this.props.setLook((Control)wlCreateIfNeeded);
        FormData fdlCreateIfNeeded = new FormData();
        fdlCreateIfNeeded.left = new FormAttachment(0, 0);
        fdlCreateIfNeeded.top = new FormAttachment((Control)lastControl, this.margin);
        fdlCreateIfNeeded.right = new FormAttachment(this.middle, -this.margin);
        wlCreateIfNeeded.setLayoutData((Object)fdlCreateIfNeeded);
        this.wCreateIfNeeded = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wCreateIfNeeded);
        FormData fdCreateIfNeeded = new FormData();
        fdCreateIfNeeded.left = new FormAttachment(this.middle, 0);
        fdCreateIfNeeded.top = new FormAttachment((Control)wlCreateIfNeeded, 0, 0x1000000);
        fdCreateIfNeeded.right = new FormAttachment(100, 0);
        this.wCreateIfNeeded.setLayoutData((Object)fdCreateIfNeeded);
        lastControl = this.wCreateIfNeeded;
        Label wlTruncateTable = new Label((Composite)this.shell, 131072);
        wlTruncateTable.setText(BaseMessages.getString(PKG, (String)"BeamBQOutputDialog.TruncateTable", (String[])new String[0]));
        this.props.setLook((Control)wlTruncateTable);
        FormData fdlTruncateTable = new FormData();
        fdlTruncateTable.left = new FormAttachment(0, 0);
        fdlTruncateTable.top = new FormAttachment((Control)lastControl, this.margin);
        fdlTruncateTable.right = new FormAttachment(this.middle, -this.margin);
        wlTruncateTable.setLayoutData((Object)fdlTruncateTable);
        this.wTruncateTable = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wTruncateTable);
        FormData fdTruncateTable = new FormData();
        fdTruncateTable.left = new FormAttachment(this.middle, 0);
        fdTruncateTable.top = new FormAttachment((Control)wlTruncateTable, 0, 0x1000000);
        fdTruncateTable.right = new FormAttachment(100, 0);
        this.wTruncateTable.setLayoutData((Object)fdTruncateTable);
        lastControl = this.wTruncateTable;
        Label wlFailIfNotEmpty = new Label((Composite)this.shell, 131072);
        wlFailIfNotEmpty.setText(BaseMessages.getString(PKG, (String)"BeamBQOutputDialog.FailIfNotEmpty", (String[])new String[0]));
        this.props.setLook((Control)wlFailIfNotEmpty);
        FormData fdlFailIfNotEmpty = new FormData();
        fdlFailIfNotEmpty.left = new FormAttachment(0, 0);
        fdlFailIfNotEmpty.top = new FormAttachment((Control)lastControl, this.margin);
        fdlFailIfNotEmpty.right = new FormAttachment(this.middle, -this.margin);
        wlFailIfNotEmpty.setLayoutData((Object)fdlFailIfNotEmpty);
        this.wFailIfNotEmpty = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wFailIfNotEmpty);
        FormData fdFailIfNotEmpty = new FormData();
        fdFailIfNotEmpty.left = new FormAttachment(this.middle, 0);
        fdFailIfNotEmpty.top = new FormAttachment((Control)wlFailIfNotEmpty, 0, 0x1000000);
        fdFailIfNotEmpty.right = new FormAttachment(100, 0);
        this.wFailIfNotEmpty.setLayoutData((Object)fdFailIfNotEmpty);
        lastControl = this.wFailIfNotEmpty;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wProjectId.setText(Const.NVL((String)this.input.getProjectId(), (String)""));
        this.wDatasetId.setText(Const.NVL((String)this.input.getDatasetId(), (String)""));
        this.wTableId.setText(Const.NVL((String)this.input.getTableId(), (String)""));
        this.wCreateIfNeeded.setSelection(this.input.isCreatingIfNeeded());
        this.wTruncateTable.setSelection(this.input.isTruncatingTable());
        this.wFailIfNotEmpty.setSelection(this.input.isFailingIfNotEmpty());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamBQOutputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setProjectId(this.wProjectId.getText());
        in.setDatasetId(this.wDatasetId.getText());
        in.setTableId(this.wTableId.getText());
        in.setCreatingIfNeeded(this.wCreateIfNeeded.getSelection());
        in.setTruncatingTable(this.wTruncateTable.getSelection());
        in.setFailingIfNotEmpty(this.wFailIfNotEmpty.getSelection());
        this.input.setChanged();
    }
}

