/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bq;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamBQInputTransform;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.bq.BQField;
import org.apache.hop.beam.transforms.bq.BeamBQInput;
import org.apache.hop.beam.transforms.bq.BeamBQInputData;
import org.apache.hop.beam.transforms.bq.BeamBQInputDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="BeamBQInput", name="Beam BigQuery Input", description="Reads from a BigQuery table in Beam", image="beam-bq-input.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", documentationUrl="/pipeline/transforms/beambigqueryinput.html")
public class BeamBQInputMeta
extends BaseTransformMeta
implements ITransformMeta<BeamBQInput, BeamBQInputData>,
IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="project_id")
    private String projectId;
    @HopMetadataProperty(key="dataset_id")
    private String datasetId;
    @HopMetadataProperty(key="table_id")
    private String tableId;
    @HopMetadataProperty(key="query")
    private String query;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<BQField> fields = new ArrayList<BQField>();

    public BeamBQInput createTransform(TransformMeta transformMeta, BeamBQInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new BeamBQInput(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public BeamBQInputData getTransformData() {
        return new BeamBQInputData();
    }

    public String getDialogClassName() {
        return BeamBQInputDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            for (BQField field : this.fields) {
                int type = ValueMetaFactory.getIdForValueMeta((String)field.getHopType());
                IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)field.getNewNameOrName(), (int)type, (int)-1, (int)-1);
                valueMeta.setOrigin(name);
                inputRowMeta.addValueMeta(valueMeta);
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error getting Beam BQ Input transform output", (Throwable)e);
        }
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, org.apache.beam.sdk.Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        RowMeta outputRowMeta = new RowMeta();
        this.getFields((IRowMeta)outputRowMeta, transformMeta.getName(), null, null, variables, null);
        BeamBQInputTransform beamInputTransform = new BeamBQInputTransform(transformMeta.getName(), transformMeta.getName(), variables.resolve(this.projectId), variables.resolve(this.datasetId), variables.resolve(this.tableId), variables.resolve(this.query), JsonRowMeta.toJson((IRowMeta)outputRowMeta), transformPluginClasses, xpPluginClasses);
        PCollection afterInput = (PCollection)pipeline.apply((PTransform)beamInputTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (BQ INPUT) : " + transformMeta.getName());
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<BQField> getFields() {
        return this.fields;
    }

    public void setFields(List<BQField> fields) {
        this.fields = fields;
    }
}

