/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.run;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;

public class MainBeam {
    public static void main(String[] args) {
        try {
            System.out.println("Argument 1 : Pipeline filename (.hpl)   : " + args[0]);
            System.out.println("Argument 2 : Metadata filename (.json)  : " + args[1]);
            System.out.println("Argument 3 : Pipeline run configuration : " + args[2]);
            System.out.println(">>>>>> Initializing Hop...");
            HopEnvironment.init();
            Configuration hadoopConfiguration = new Configuration();
            String pipelineMetaXml = MainBeam.readFileIntoString(args[0], hadoopConfiguration, "UTF-8");
            String metadataJson = MainBeam.readFileIntoString(args[1], hadoopConfiguration, "UTF-8");
            String runConfigName = args[2];
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metadataJson);
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(PipelineRunConfiguration.class);
            if (!serializer.exists(runConfigName)) {
                throw new HopException("The specified pipeline run configuration '" + runConfigName + "' doesn't exist");
            }
            System.out.println(">>>>>> Loading pipeline metadata");
            PipelineMeta pipelineMeta = new PipelineMeta(XmlHandler.loadXmlString((String)pipelineMetaXml, (String)"pipeline"), (IHopMetadataProvider)metadataProvider);
            String hadoopConfDir = System.getenv("HADOOP_CONF_DIR");
            System.out.println(">>>>>> HADOOP_CONF_DIR='" + hadoopConfDir + "'");
            System.out.println(">>>>>> Building Apache Beam Pipeline...");
            PluginRegistry registry = PluginRegistry.getInstance();
            IPlugin beamInputPlugin = registry.getPlugin(TransformPluginType.class, "BeamInput");
            if (beamInputPlugin == null) {
                throw new HopException("ERROR: Unable to find Beam Input transform plugin. Is it in the fat jar? ");
            }
            System.out.println(">>>>>> Found Beam Input transform plugin class loader");
            IVariables variables = Variables.getADefaultVariableSpace();
            IPipelineEngine pipelineEngine = PipelineEngineFactory.createPipelineEngine((IVariables)variables, (String)runConfigName, (IHopMetadataProvider)metadataProvider, (PipelineMeta)pipelineMeta);
            System.out.println(">>>>>> Pipeline executing starting...");
            pipelineEngine.execute();
            pipelineEngine.waitUntilFinished();
            System.out.println(">>>>>> Execution finished...");
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Error running Beam pipeline: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String readFileIntoString(String filename, Configuration hadoopConfiguration, String encoding) throws IOException {
        Path path = new Path(filename);
        FileSystem fileSystem = FileSystem.get((URI)path.toUri(), (Configuration)hadoopConfiguration);
        FSDataInputStream inputStream = fileSystem.open(path);
        String fileContent = IOUtils.toString((InputStream)inputStream, (String)encoding);
        return fileContent;
    }
}

