/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.pipeline.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.StringToHopRowFn;
import org.apache.hop.beam.core.shared.VariableValue;
import org.apache.hop.beam.core.transform.TransformBatchTransform;
import org.apache.hop.beam.core.transform.TransformTransform;
import org.apache.hop.beam.core.util.HopBeamUtil;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamBaseTransformHandler;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;

public class BeamGenericTransformHandler
extends BeamBaseTransformHandler
implements IBeamPipelineTransformHandler {
    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        boolean inputTransform = input == null;
        boolean reduceParallelism = this.checkTransformCopiesForReducedParallelism(transformMeta);
        reduceParallelism = reduceParallelism || BeamGenericTransformHandler.needsSingleThreading(transformMeta);
        String transformMetaInterfaceXml = XmlHandler.openTag((String)"transform") + transformMeta.getTransform().getXml() + XmlHandler.closeTag((String)"transform");
        List infoTransformMetas = pipelineMeta.findPreviousTransforms(transformMeta, true);
        ArrayList<String> infoTransforms = new ArrayList<String>();
        ArrayList<String> infoRowMetaJsons = new ArrayList<String>();
        ArrayList<PCollectionView<List<HopRow>>> infoCollectionViews = new ArrayList<PCollectionView<List<HopRow>>>();
        for (TransformMeta infoTransformMeta : infoTransformMetas) {
            if (previousTransforms.contains(infoTransformMeta)) continue;
            infoTransforms.add(infoTransformMeta.getName());
            infoRowMetaJsons.add(JsonRowMeta.toJson(pipelineMeta.getTransformFields(variables, infoTransformMeta)));
            PCollection<HopRow> infoCollection = transformCollectionMap.get(infoTransformMeta.getName());
            if (infoCollection == null) {
                throw new HopException("Unable to find collection for transform '" + infoTransformMeta.getName() + " providing info for '" + transformMeta.getName() + "'");
            }
            infoCollectionViews.add((PCollectionView<List<HopRow>>)infoCollection.apply((PTransform)View.asList()));
        }
        List<VariableValue> variableValues = this.getVariableValues(variables);
        ITransformIOMeta ioMeta = transformMeta.getTransform().getTransformIOMeta();
        ArrayList<String> targetTransforms = new ArrayList<String>();
        for (IStream targetStream : ioMeta.getTargetStreams()) {
            if (targetStream.getTransformMeta() == null) continue;
            targetTransforms.add(targetStream.getTransformMeta().getName());
        }
        int flushIntervalMs = Const.toInt((String)runConfiguration.getStreamingHopTransformsFlushInterval(), (int)-1);
        int sizeRowsSet = Const.toInt((String)runConfiguration.getStreamingHopTransformsBufferSize(), (int)500);
        int sizeRowSet = 5000;
        String metaStoreJson = new SerializableMetadataProvider(metadataProvider).toJson();
        TransformTransform transformTransform = BeamGenericTransformHandler.needsBatching(variables, transformMeta) ? new TransformBatchTransform(variableValues, metaStoreJson, transformPluginClasses, xpPluginClasses, sizeRowSet, flushIntervalMs, transformMeta.getName(), transformMeta.getTransformPluginId(), transformMetaInterfaceXml, JsonRowMeta.toJson(rowMeta), inputTransform, targetTransforms, infoTransforms, infoRowMetaJsons, infoCollectionViews) : new TransformTransform(variableValues, metaStoreJson, transformPluginClasses, xpPluginClasses, sizeRowSet, flushIntervalMs, transformMeta.getName(), transformMeta.getTransformPluginId(), transformMetaInterfaceXml, JsonRowMeta.toJson(rowMeta), inputTransform, targetTransforms, infoTransforms, infoRowMetaJsons, infoCollectionViews);
        if (input == null) {
            input = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)pipeline.apply((PTransform)Create.of(Arrays.asList("hop-single-value")))).setCoder((Coder)StringUtf8Coder.of()).apply((PTransform)WithKeys.of((Object)null))).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply((PTransform)Flatten.iterables())).apply((PTransform)ParDo.of((DoFn)new StringToHopRowFn(transformMeta.getName(), JsonRowMeta.toJson(rowMeta), transformPluginClasses, xpPluginClasses)));
            String tupleId = HopBeamUtil.createMainInputTupleId(transformMeta.getName());
            transformCollectionMap.put(tupleId, (PCollection<HopRow>)input);
        } else if (reduceParallelism) {
            PCollection.IsBounded isBounded = input.isBounded();
            if (isBounded == PCollection.IsBounded.BOUNDED) {
                input = (PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)input.getCoder())).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply((PTransform)Flatten.iterables());
            } else {
                throw new HopException("Unable to reduce parallel in an unbounded (streaming) pipeline in transform : " + transformMeta.getName());
            }
        }
        PCollectionTuple tuple = (PCollectionTuple)input.apply(transformMeta.getName(), (PTransform)transformTransform);
        PCollection mainPCollection = tuple.get(new TupleTag(HopBeamUtil.createMainOutputTupleId(transformMeta.getName())));
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)mainPCollection);
        for (String targetTransform : targetTransforms) {
            String tupleId = HopBeamUtil.createTargetTupleId(transformMeta.getName(), targetTransform);
            PCollection targetPCollection = tuple.get(new TupleTag(tupleId));
            transformCollectionMap.put(tupleId, (PCollection<HopRow>)targetPCollection);
        }
        log.logBasic("Handled generic transform (TRANSFORM) : " + transformMeta.getName() + ", gets data from " + previousTransforms.size() + " previous transform(s), targets=" + targetTransforms.size() + ", infos=" + infoTransforms.size());
    }

    public static boolean needsBatching(IVariables variables, TransformMeta transformMeta) {
        String value = transformMeta.getAttribute("Hop Beam", "Batch");
        String copiesString = variables.resolve(transformMeta.getCopiesString());
        return value != null && "true".equalsIgnoreCase(value) || copiesString != null && copiesString.toUpperCase().contains("BATCH");
    }

    public static boolean needsSingleThreading(TransformMeta transformMeta) {
        String value = transformMeta.getAttribute("Hop Beam", "SingleThreaded");
        return value != null && "true".equalsIgnoreCase(value);
    }

    private boolean checkTransformCopiesForReducedParallelism(TransformMeta transformMeta) {
        String[] keyWords;
        if (transformMeta.getCopiesString() == null) {
            return false;
        }
        String copiesString = transformMeta.getCopiesString();
        for (String keyWord : keyWords = new String[]{"BEAM_SINGLE", "SINGLE_BEAM", "BEAM_OUTPUT", "OUTPUT"}) {
            if (!copiesString.contains(keyWord)) continue;
            return true;
        }
        return false;
    }

    private List<VariableValue> getVariableValues(IVariables variables) {
        ArrayList<VariableValue> variableValues = new ArrayList<VariableValue>();
        for (String variable : variables.getVariableNames()) {
            String value = variables.getVariable(variable);
            variableValues.add(new VariableValue(variable, value));
        }
        return variableValues;
    }
}

