/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.pipeline.fatjar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.pipeline.HopPipelineMetaToBeamPipelineConverter;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.variables.IVariables;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;

public class FatJarBuilder {
    private IVariables variables;
    private String targetJarFile;
    private List<String> jarFiles = new ArrayList<String>();
    private String extraTransformPluginClasses = null;
    private String extraXpPluginClasses = null;
    private transient Map<String, String> fileContentMap;

    public FatJarBuilder() {
    }

    public FatJarBuilder(IVariables variables, String targetJarFile, List<String> jarFiles) {
        this();
        this.variables = variables;
        this.targetJarFile = targetJarFile;
        this.jarFiles = jarFiles;
    }

    public void buildTargetJar() throws HopException {
        this.fileContentMap = new HashMap<String, String>();
        String realTargetJarFile = this.variables.resolve(this.targetJarFile);
        JarCache cache = JarCache.getInstance();
        Indexer indexer = new Indexer();
        try {
            byte[] buffer = new byte[1024];
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(realTargetJarFile));
            for (String jarFile : this.jarFiles) {
                boolean jarIndexed = false;
                if (cache.getIndex(new File(jarFile)) != null) {
                    jarIndexed = true;
                }
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(jarFile));
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    boolean skip = false;
                    boolean merge = false;
                    boolean index = false;
                    String entryName = zipEntry.getName();
                    if (zipEntry.isDirectory()) {
                        skip = true;
                    }
                    if (entryName.contains("META-INF/INDEX.LIST")) {
                        skip = true;
                    } else if (entryName.contains("META-INF/MANIFEST.MF")) {
                        skip = true;
                    } else if (entryName.startsWith("META-INF") && entryName.endsWith(".SF")) {
                        skip = true;
                    } else if (entryName.startsWith("META-INF") && entryName.endsWith(".DSA")) {
                        skip = true;
                    } else if (entryName.startsWith("META-INF") && entryName.endsWith(".RSA")) {
                        skip = true;
                    } else if (entryName.startsWith("META-INF/services/")) {
                        merge = true;
                        skip = true;
                    } else if (entryName.endsWith("META-INF/jandex.idx")) {
                        skip = true;
                    } else if (jarIndexed && entryName.endsWith(".class")) {
                        index = true;
                    }
                    if (!skip) {
                        try {
                            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                        }
                        catch (ZipException ze) {
                            skip = true;
                        }
                    }
                    if (merge) {
                        String fileContent = IOUtils.toString((InputStream)zipInputStream, (String)"UTF-8");
                        String previousContent = this.fileContentMap.get(entryName);
                        if (previousContent == null) {
                            this.fileContentMap.put(entryName, fileContent);
                        } else {
                            this.fileContentMap.put(entryName, previousContent + Const.CR + fileContent);
                        }
                    } else if (!skip) {
                        int len;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while ((len = zipInputStream.read(buffer)) > 0) {
                            zipOutputStream.write(buffer, 0, len);
                            if (!index) continue;
                            baos.write(buffer, 0, len);
                        }
                        if (index) {
                            indexer.index((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                        }
                    }
                    zipInputStream.closeEntry();
                    if (!skip) {
                        zipOutputStream.closeEntry();
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
                zipInputStream.close();
            }
            for (String entryName : this.fileContentMap.keySet()) {
                String fileContent = this.fileContentMap.get(entryName);
                zipOutputStream.putNextEntry(new ZipEntry(entryName));
                zipOutputStream.write(fileContent.getBytes("UTF-8"));
                zipOutputStream.closeEntry();
            }
            zipOutputStream.putNextEntry(new ZipEntry("META-INF/jandex.idx"));
            IndexWriter indexWriter = new IndexWriter((OutputStream)zipOutputStream);
            indexWriter.write(indexer.complete());
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (Exception e) {
            throw new HopException("Unable to build far jar file '" + realTargetJarFile + "'", (Throwable)e);
        }
        finally {
            this.fileContentMap.clear();
        }
    }

    public static String findPluginClasses(String pluginClassName, String pluginsToInclude) throws HopException {
        String[] pluginFolders;
        String plugins = pluginsToInclude;
        plugins = StringUtils.isEmpty((String)plugins) ? "hop-beam" : plugins + ",hop-beam";
        HashSet<String> classes = new HashSet<String>();
        for (String pluginFolder : pluginFolders = plugins.split(",")) {
            try {
                List<String> transformClasses = HopPipelineMetaToBeamPipelineConverter.findAnnotatedClasses(pluginFolder, pluginClassName);
                for (String transformClass : transformClasses) {
                    classes.add(transformClass);
                }
            }
            catch (Exception e) {
                throw new HopException("Error find plugin classes of annotation type '" + pluginClassName + "' in folder '" + pluginFolder, (Throwable)e);
            }
        }
        ArrayList<String> classesList = new ArrayList<String>();
        classesList.addAll(classes);
        Collections.sort(classesList);
        StringBuffer all = new StringBuffer();
        for (String pluginClass : classesList) {
            if (all.length() > 0) {
                all.append(",");
            }
            all.append(pluginClass);
        }
        return all.toString();
    }

    public String getTargetJarFile() {
        return this.targetJarFile;
    }

    public void setTargetJarFile(String targetJarFile) {
        this.targetJarFile = targetJarFile;
    }

    public List<String> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(List<String> jarFiles) {
        this.jarFiles = jarFiles;
    }

    public String getExtraTransformPluginClasses() {
        return this.extraTransformPluginClasses;
    }

    public void setExtraTransformPluginClasses(String extraTransformPluginClasses) {
        this.extraTransformPluginClasses = extraTransformPluginClasses;
    }

    public String getExtraXpPluginClasses() {
        return this.extraXpPluginClasses;
    }

    public void setExtraXpPluginClasses(String extraXpPluginClasses) {
        this.extraXpPluginClasses = extraXpPluginClasses;
    }

    public Map<String, String> getFileContentMap() {
        return this.fileContentMap;
    }

    public void setFileContentMap(Map<String, String> fileContentMap) {
        this.fileContentMap = fileContentMap;
    }
}

