/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.pipeline;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.coder.HopRowCoder;
import org.apache.hop.beam.core.util.HopBeamUtil;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamGenericTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamGroupByTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamMergeJoinTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamRowGeneratorTransformHandler;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.groupby.GroupByMeta;
import org.apache.hop.pipeline.transforms.sort.SortRowsMeta;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueRowsMeta;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class HopPipelineMetaToBeamPipelineConverter<T extends IBeamPipelineEngineRunConfiguration> {
    protected IVariables variables;
    protected PipelineMeta pipelineMeta;
    protected SerializableMetadataProvider metadataProvider;
    protected String metaStoreJson;
    protected List<String> transformPluginClasses;
    protected List<String> xpPluginClasses;
    protected Map<String, IBeamPipelineTransformHandler> transformHandlers = new HashMap<String, IBeamPipelineTransformHandler>();
    protected IBeamPipelineTransformHandler genericTransformHandler;
    protected T pipelineRunConfiguration;

    public HopPipelineMetaToBeamPipelineConverter() {
        this.transformPluginClasses = new ArrayList<String>();
        this.xpPluginClasses = new ArrayList<String>();
    }

    public HopPipelineMetaToBeamPipelineConverter(IVariables variables, PipelineMeta pipelineMeta, IHopMetadataProvider metadataProvider, T pipelineRunConfiguration) throws HopException, HopException {
        this();
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.metadataProvider = new SerializableMetadataProvider(metadataProvider);
        this.metaStoreJson = this.metadataProvider.toJson();
        this.pipelineRunConfiguration = pipelineRunConfiguration;
        this.addClassesFromPluginsToStage(pipelineRunConfiguration.getPluginsToStage());
        this.transformPluginClasses.addAll(this.splitPluginClasses(pipelineRunConfiguration.getTransformPluginClasses()));
        this.xpPluginClasses.addAll(this.splitPluginClasses(pipelineRunConfiguration.getXpPluginClasses()));
        this.addDefaultTransformHandlers();
    }

    protected List<String> splitPluginClasses(String transformPluginClasses) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)transformPluginClasses)) {
            list.addAll(Arrays.asList(transformPluginClasses.split(",")));
        }
        return list;
    }

    public void addClassesFromPluginsToStage(String pluginsToStage) throws HopException {
        if (StringUtils.isNotEmpty((String)pluginsToStage)) {
            String[] pluginFolders;
            for (String pluginFolder : pluginFolders = pluginsToStage.split(",")) {
                List<String> transformClasses = HopPipelineMetaToBeamPipelineConverter.findAnnotatedClasses(pluginFolder, Transform.class.getName());
                this.transformPluginClasses.addAll(transformClasses);
                List<String> xpClasses = HopPipelineMetaToBeamPipelineConverter.findAnnotatedClasses(pluginFolder, ExtensionPoint.class.getName());
                this.xpPluginClasses.addAll(xpClasses);
            }
        }
    }

    public void addDefaultTransformHandlers() throws HopException {
        this.transformHandlers.put("MergeJoin", new BeamMergeJoinTransformHandler());
        this.transformHandlers.put("MemoryGroupBy", new BeamGroupByTransformHandler());
        this.transformHandlers.put("RowGenerator", new BeamRowGeneratorTransformHandler());
        this.genericTransformHandler = new BeamGenericTransformHandler();
    }

    public static List<String> findAnnotatedClasses(String folder, String annotationClassName) throws HopException {
        JarCache jarCache = JarCache.getInstance();
        ArrayList<String> classNames = new ArrayList<String>();
        File pluginFolder = new File("plugins/" + folder);
        try {
            Set files = jarCache.findJarFiles(pluginFolder);
            if (!files.isEmpty()) {
                for (File file : files) {
                    Index index = jarCache.getIndex(file);
                    for (AnnotationInstance instance : index.getAnnotations(DotName.createSimple((String)annotationClassName))) {
                        if (!(instance.target() instanceof ClassInfo)) continue;
                        ClassInfo classInfo = (ClassInfo)instance.target();
                        classNames.add(classInfo.name().toString());
                    }
                }
            } else {
                System.out.println("No jar files found in plugin folder " + pluginFolder);
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to find annotated classes of class " + annotationClassName, (Throwable)e);
        }
        return classNames;
    }

    public Pipeline createPipeline() throws Exception {
        ILogChannel log = LogChannel.GENERAL;
        RunnerType runnerType = this.pipelineRunConfiguration.getRunnerType();
        Class<PipelineRunner<?>> runnerClass = HopPipelineMetaToBeamPipelineConverter.getPipelineRunnerClass(runnerType);
        PipelineOptions pipelineOptions = this.pipelineRunConfiguration.getPipelineOptions();
        pipelineOptions.setUserAgent(this.variables.resolve(this.pipelineRunConfiguration.getUserAgent()));
        pipelineOptions.setTempLocation(this.variables.resolve(this.pipelineRunConfiguration.getTempLocation()));
        pipelineOptions.setJobName(this.sanitizeJobName(this.pipelineMeta.getName()));
        pipelineOptions.setRunner(runnerClass);
        Pipeline pipeline = Pipeline.create((PipelineOptions)pipelineOptions);
        pipeline.getCoderRegistry().registerCoderForClass(HopRow.class, (Coder)new HopRowCoder());
        log.logBasic("Created Apache Beam pipeline with name '" + pipelineOptions.getJobName() + "'");
        HashMap<String, PCollection<HopRow>> transformCollectionMap = new HashMap<String, PCollection<HopRow>>();
        this.handleBeamInputTransforms(log, transformCollectionMap, pipeline);
        this.handleGenericTransform(transformCollectionMap, pipeline);
        this.handleBeamOutputTransforms(log, transformCollectionMap, pipeline);
        return pipeline;
    }

    private String sanitizeJobName(String name) {
        String newName = name.toLowerCase();
        if (name.matches("^[0-9].*")) {
            newName = "hop-" + newName;
        }
        StringBuilder builder = new StringBuilder(newName);
        for (int i = 0; i < builder.length(); ++i) {
            String c = "" + builder.charAt(i);
            if (c.matches("[-0-9a-z]")) continue;
            builder.setCharAt(i, '-');
        }
        return builder.toString();
    }

    public static Class<? extends PipelineRunner<?>> getPipelineRunnerClass(RunnerType runnerType) throws HopException {
        if (runnerType == null) {
            throw new HopException("Please specify a valid runner type");
        }
        switch (runnerType) {
            case Direct: {
                return DirectRunner.class;
            }
            case Flink: {
                return FlinkRunner.class;
            }
            case Spark: {
                return SparkRunner.class;
            }
            case DataFlow: {
                return DataflowRunner.class;
            }
        }
        throw new HopException("Unsupported runner type: " + runnerType.name());
    }

    private void handleBeamInputTransforms(ILogChannel log, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline) throws HopException {
        List<TransformMeta> beamInputTransformMetas = this.findBeamInputs();
        for (TransformMeta transformMeta : beamInputTransformMetas) {
            IBeamPipelineTransformHandler transformHandler = this.transformHandlers.get(transformMeta.getTransformPluginId());
            if (transformHandler == null && transformMeta.getTransform() instanceof IBeamPipelineTransformHandler) {
                transformHandler = (IBeamPipelineTransformHandler)transformMeta.getTransform();
            }
            if (transformHandler == null) {
                throw new HopException("Unable to find Beam pipeline transform handler for transform: " + transformMeta.getName());
            }
            transformHandler.handleTransform(log, this.variables, (IBeamPipelineEngineRunConfiguration)this.pipelineRunConfiguration, (IHopMetadataProvider)this.metadataProvider, this.pipelineMeta, this.transformPluginClasses, this.xpPluginClasses, transformMeta, transformCollectionMap, pipeline, this.pipelineMeta.getTransformFields(this.variables, transformMeta), null, null);
        }
    }

    private void handleBeamOutputTransforms(ILogChannel log, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline) throws HopException {
        List<TransformMeta> beamOutputTransformMetas = this.findBeamOutputs();
        for (TransformMeta transformMeta : beamOutputTransformMetas) {
            IBeamPipelineTransformHandler transformHandler = this.transformHandlers.get(transformMeta.getTransformPluginId());
            if (transformHandler == null && transformMeta.getTransform() instanceof IBeamPipelineTransformHandler) {
                transformHandler = (IBeamPipelineTransformHandler)transformMeta.getTransform();
            }
            if (transformHandler == null) {
                throw new HopException("Unable to find Beam pipeline transform handler for transform: " + transformMeta.getName());
            }
            List previousTransforms = this.pipelineMeta.findPreviousTransforms(transformMeta, false);
            if (previousTransforms.size() > 1) {
                throw new HopException("Combining data from multiple transforms is not supported yet!");
            }
            TransformMeta previousTransform = (TransformMeta)previousTransforms.get(0);
            PCollection<HopRow> input = transformCollectionMap.get(previousTransform.getName());
            if (input == null) {
                throw new HopException("Previous PCollection for transform " + previousTransform.getName() + " could not be found");
            }
            IRowMeta rowMeta = this.pipelineMeta.getTransformFields(this.variables, previousTransform);
            transformHandler.handleTransform(log, this.variables, (IBeamPipelineEngineRunConfiguration)this.pipelineRunConfiguration, (IHopMetadataProvider)this.metadataProvider, this.pipelineMeta, this.transformPluginClasses, this.xpPluginClasses, transformMeta, transformCollectionMap, pipeline, rowMeta, previousTransforms, input);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleGenericTransform(Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline) throws HopException, IOException {
        ILogChannel log = LogChannel.GENERAL;
        List<TransformMeta> transforms = this.getSortedTransformsList();
        for (TransformMeta transformMeta : transforms) {
            RowMeta rowMeta;
            TransformMeta firstPreviousTransform;
            IBeamPipelineTransformHandler transformHandler = this.transformHandlers.get(transformMeta.getTransformPluginId());
            if (transformHandler == null && transformMeta.getTransform() instanceof IBeamPipelineTransformHandler) {
                transformHandler = (IBeamPipelineTransformHandler)transformMeta.getTransform();
            }
            if (transformHandler != null && (transformHandler.isInput() || transformHandler.isOutput())) continue;
            this.validateTransformBeamUsage(transformMeta.getTransform());
            List previousTransforms = this.pipelineMeta.findPreviousTransforms(transformMeta, false);
            PCollection input = null;
            if (previousTransforms.isEmpty()) {
                firstPreviousTransform = null;
                rowMeta = new RowMeta();
            } else {
                firstPreviousTransform = (TransformMeta)previousTransforms.get(0);
                rowMeta = this.pipelineMeta.getTransformFields(this.variables, firstPreviousTransform);
                String targetName = HopBeamUtil.createTargetTupleId(firstPreviousTransform.getName(), transformMeta.getName());
                input = transformCollectionMap.get(targetName);
                if (input == null) {
                    input = transformCollectionMap.get(firstPreviousTransform.getName());
                } else {
                    log.logBasic("Transform " + transformMeta.getName() + " reading from previous transform targeting this one using : " + targetName);
                }
                if (previousTransforms.size() > 1) {
                    ArrayList<void> extraInputs = new ArrayList<void>();
                    for (int i = 1; i < previousTransforms.size(); ++i) {
                        void var16_20;
                        TransformMeta previousTransform = (TransformMeta)previousTransforms.get(i);
                        targetName = HopBeamUtil.createTargetTupleId(previousTransform.getName(), transformMeta.getName());
                        PCollection<HopRow> pCollection = transformCollectionMap.get(targetName);
                        if (pCollection == null) {
                            PCollection<HopRow> pCollection2 = transformCollectionMap.get(previousTransform.getName());
                        } else {
                            log.logBasic("Transform " + transformMeta.getName() + " reading from previous transform targetting this one using : " + targetName);
                        }
                        if (var16_20 == null) {
                            throw new HopException("Previous collection was not found for transform " + previousTransform.getName() + ", a previous transform to " + transformMeta.getName());
                        }
                        extraInputs.add(var16_20);
                    }
                    PCollectionList inputList = PCollectionList.of(input);
                    for (PCollection pCollection : extraInputs) {
                        inputList = inputList.and(pCollection);
                    }
                    input = (PCollection)inputList.apply(transformMeta.getName() + " Flatten", (PTransform)Flatten.pCollections());
                }
            }
            if (transformHandler == null) {
                transformHandler = this.genericTransformHandler;
            }
            transformHandler.handleTransform(log, this.variables, (IBeamPipelineEngineRunConfiguration)this.pipelineRunConfiguration, (IHopMetadataProvider)this.metadataProvider, this.pipelineMeta, this.transformPluginClasses, this.xpPluginClasses, transformMeta, transformCollectionMap, pipeline, (IRowMeta)rowMeta, previousTransforms, (PCollection<HopRow>)input);
        }
    }

    private void validateTransformBeamUsage(ITransformMeta meta) throws HopException {
        if (meta instanceof GroupByMeta) {
            throw new HopException("Group By is not supported.  Use the Memory Group By transform instead.  It comes closest to Beam functionality.");
        }
        if (meta instanceof SortRowsMeta) {
            throw new HopException("Sort rows is not yet supported on Beam.");
        }
        if (meta instanceof UniqueRowsMeta) {
            throw new HopException("The unique rows transform is not yet supported on Beam, for now use a Memory Group By to get distrinct rows");
        }
    }

    private List<TransformMeta> findBeamInputs() throws HopException {
        ArrayList<TransformMeta> transforms = new ArrayList<TransformMeta>();
        for (TransformMeta transformMeta : this.pipelineMeta.getPipelineHopTransforms(false)) {
            IBeamPipelineTransformHandler transformHandler = this.transformHandlers.get(transformMeta.getTransformPluginId());
            if (transformHandler != null && transformHandler.isInput()) {
                transforms.add(transformMeta);
                continue;
            }
            if (!(transformMeta.getTransform() instanceof IBeamPipelineTransformHandler) || !((IBeamPipelineTransformHandler)transformMeta.getTransform()).isInput()) continue;
            transforms.add(transformMeta);
        }
        return transforms;
    }

    private List<TransformMeta> findBeamOutputs() throws HopException {
        ArrayList<TransformMeta> transforms = new ArrayList<TransformMeta>();
        for (TransformMeta transformMeta : this.pipelineMeta.getPipelineHopTransforms(false)) {
            IBeamPipelineTransformHandler transformHandler = this.transformHandlers.get(transformMeta.getTransformPluginId());
            if (transformHandler != null && transformHandler.isOutput()) {
                transforms.add(transformMeta);
                continue;
            }
            if (!(transformMeta.getTransform() instanceof IBeamPipelineTransformHandler) || !((IBeamPipelineTransformHandler)transformMeta.getTransform()).isOutput()) continue;
            transforms.add(transformMeta);
        }
        return transforms;
    }

    private List<TransformMeta> getSortedTransformsList() {
        ArrayList<TransformMeta> transforms = new ArrayList<TransformMeta>(this.pipelineMeta.getPipelineHopTransforms(false));
        this.pipelineMeta.clearCaches();
        int transformsMinSize = 0;
        int transformsSize = transforms.size();
        int windowShrinkThreshold = (int)Math.round((double)transformsSize * 0.75);
        int totalIterations = transformsSize * 2;
        boolean isBefore = false;
        boolean forwardChange = false;
        boolean backwardChange = false;
        boolean lastForwardChange = true;
        boolean keepSortingForward = true;
        TransformMeta one = null;
        TransformMeta two = null;
        long startTime = System.currentTimeMillis();
        for (int x = 0; x < totalIterations; ++x) {
            if (keepSortingForward) {
                for (int y = transformsMinSize; y < transformsSize - 1; ++y) {
                    one = (TransformMeta)transforms.get(y);
                    isBefore = this.pipelineMeta.findPrevious(one, two = (TransformMeta)transforms.get(y + 1));
                    if (!isBefore) continue;
                    transforms.set(y, two);
                    transforms.set(y + 1, one);
                    forwardChange = true;
                }
            }
            for (int z = transformsSize - 1; z > transformsMinSize; --z) {
                one = (TransformMeta)transforms.get(z);
                isBefore = this.pipelineMeta.findPrevious(one, two = (TransformMeta)transforms.get(z - 1));
                if (isBefore) continue;
                transforms.set(z, two);
                transforms.set(z - 1, one);
                backwardChange = true;
            }
            if (x > windowShrinkThreshold && !forwardChange && --transformsSize <= transformsMinSize || x > windowShrinkThreshold && !backwardChange && ++transformsMinSize >= transformsSize || !forwardChange && !backwardChange) break;
            if (keepSortingForward && x > 0 && !lastForwardChange && !forwardChange) {
                keepSortingForward = false;
            }
            lastForwardChange = forwardChange;
            forwardChange = false;
            backwardChange = false;
        }
        return transforms;
    }

    public Map<String, IBeamPipelineTransformHandler> getTransformHandlers() {
        return this.transformHandlers;
    }

    public void setTransformHandlers(Map<String, IBeamPipelineTransformHandler> transformHandlers) {
        this.transformHandlers = transformHandlers;
    }

    public IBeamPipelineTransformHandler getGenericTransformHandler() {
        return this.genericTransformHandler;
    }

    public void setGenericTransformHandler(IBeamPipelineTransformHandler genericTransformHandler) {
        this.genericTransformHandler = genericTransformHandler;
    }
}

