/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines.spark;

import java.util.Arrays;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.engines.BeamPipelineRunConfiguration;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
public class BeamSparkPipelineRunConfiguration
extends BeamPipelineRunConfiguration
implements IBeamPipelineEngineRunConfiguration,
IVariables,
Cloneable {
    @GuiWidgetElement(order="20000-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="The Spark master", toolTip="The url of the spark master to connect to, (e.g. spark://host:port, local[4]).")
    @HopMetadataProperty
    private String sparkMaster;
    @GuiWidgetElement(order="20010-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Streaming: batch interval (ms)", toolTip="Batch interval for Spark streaming in milliseconds.")
    @HopMetadataProperty
    private String sparkBatchIntervalMillis;
    @GuiWidgetElement(order="20020-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Streaming: checkpoint directory", toolTip="A checkpoint directory for streaming resilience, ignored in batch. For durability, a reliable filesystem such as HDFS/S3/GS is necessary.")
    @HopMetadataProperty
    private String sparkCheckpointDir;
    @GuiWidgetElement(order="20030-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Streaming: checkpoint duration (ms)", toolTip="The period to checkpoint (in Millis). If not set, Spark will default to Max(slideDuration, Seconds(10)). This PipelineOptions default (-1) will end-up with the described Spark default.")
    @HopMetadataProperty
    private String sparkCheckpointDurationMillis;
    @GuiWidgetElement(order="20040-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="Enable Metrics sink", toolTip="Enable/disable sending aggregator values to Spark's metric sinks")
    @HopMetadataProperty
    private boolean sparkEnableSparkMetricSinks;
    @GuiWidgetElement(order="20050-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Streaming: maximum records per batch", toolTip="Max records per micro-batch. For streaming sources only.")
    @HopMetadataProperty
    private String sparkMaxRecordsPerBatch;
    @GuiWidgetElement(order="20060-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Streaming: Minimum read time (ms)", toolTip="Minimum time to spend on read, for each micro-batch.")
    @HopMetadataProperty
    private String sparkMinReadTimeMillis;
    @GuiWidgetElement(order="20070-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Streaming: read time percentage", toolTip="A value between 0-1 to describe the percentage of a micro-batch dedicated to reading from UnboundedSource.")
    @HopMetadataProperty
    private String sparkReadTimePercentage;
    @GuiWidgetElement(order="20080-flink-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Bundle size", toolTip="If set bundleSize will be used for splitting BoundedSources, otherwise default to splitting BoundedSources on Spark defaultParallelism. Most effective when used with Spark dynamicAllocation.")
    @HopMetadataProperty
    private String sparkBundleSize;
    @HopMetadataProperty
    private String sparkStorageLevel;

    public BeamSparkPipelineRunConfiguration() {
        this.tempLocation = System.getProperty("java.io.tmpdir");
    }

    public BeamSparkPipelineRunConfiguration(BeamSparkPipelineRunConfiguration config) {
        super(config);
        this.sparkMaster = config.sparkMaster;
        this.sparkBatchIntervalMillis = config.sparkBatchIntervalMillis;
        this.sparkCheckpointDir = config.sparkCheckpointDir;
        this.sparkCheckpointDurationMillis = config.sparkCheckpointDurationMillis;
        this.sparkEnableSparkMetricSinks = config.sparkEnableSparkMetricSinks;
        this.sparkMaxRecordsPerBatch = config.sparkMaxRecordsPerBatch;
        this.sparkMinReadTimeMillis = config.sparkMinReadTimeMillis;
        this.sparkReadTimePercentage = config.sparkReadTimePercentage;
        this.sparkBundleSize = config.sparkBundleSize;
        this.sparkStorageLevel = config.sparkStorageLevel;
    }

    public BeamSparkPipelineRunConfiguration clone() {
        return new BeamSparkPipelineRunConfiguration(this);
    }

    @Override
    public RunnerType getRunnerType() {
        return RunnerType.Spark;
    }

    @Override
    public PipelineOptions getPipelineOptions() throws HopException {
        long bundleSize;
        double percentage;
        long readTime;
        long records;
        long duration;
        long interval;
        SparkPipelineOptions options = (SparkPipelineOptions)PipelineOptionsFactory.as(SparkPipelineOptions.class);
        if (StringUtils.isNotEmpty((String)this.getSparkMaster())) {
            options.setSparkMaster(this.resolve(this.getSparkMaster()));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkBatchIntervalMillis()) && (interval = Const.toLong((String)this.resolve(this.getSparkBatchIntervalMillis()), (long)-1L)) >= 0L) {
            options.setBatchIntervalMillis(Long.valueOf(interval));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkCheckpointDir())) {
            options.setCheckpointDir(this.resolve(this.getSparkCheckpointDir()));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkCheckpointDurationMillis()) && (duration = Const.toLong((String)this.resolve(this.getSparkCheckpointDurationMillis()), (long)-1L)) >= 0L) {
            options.setCheckpointDurationMillis(Long.valueOf(duration));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkMaxRecordsPerBatch()) && (records = Const.toLong((String)this.resolve(this.getSparkMaxRecordsPerBatch()), (long)-1L)) >= 0L) {
            options.setMaxRecordsPerBatch(Long.valueOf(records));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkMinReadTimeMillis()) && (readTime = Const.toLong((String)this.resolve(this.getSparkMinReadTimeMillis()), (long)-1L)) >= 0L) {
            options.setMinReadTimeMillis(Long.valueOf(readTime));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkReadTimePercentage()) && (percentage = Const.toDouble((String)this.resolve(this.getSparkReadTimePercentage()), (double)-1.0)) >= 0.0) {
            options.setReadTimePercentage(Double.valueOf(percentage / 100.0));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkBundleSize()) && (bundleSize = Const.toLong((String)this.resolve(this.getSparkBundleSize()), (long)-1L)) >= 0L) {
            options.setBundleSize(Long.valueOf(bundleSize));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkStorageLevel())) {
            options.setStorageLevel(this.resolve(this.getSparkStorageLevel()));
        }
        if (StringUtils.isNotEmpty((String)this.getFatJar())) {
            options.setFilesToStage(Arrays.asList(this.resolve(this.fatJar)));
        }
        return options;
    }

    @Override
    public boolean isRunningAsynchronous() {
        return true;
    }

    public String getSparkMaster() {
        return this.sparkMaster;
    }

    public void setSparkMaster(String sparkMaster) {
        this.sparkMaster = sparkMaster;
    }

    public String getSparkBatchIntervalMillis() {
        return this.sparkBatchIntervalMillis;
    }

    public void setSparkBatchIntervalMillis(String sparkBatchIntervalMillis) {
        this.sparkBatchIntervalMillis = sparkBatchIntervalMillis;
    }

    public String getSparkCheckpointDir() {
        return this.sparkCheckpointDir;
    }

    public void setSparkCheckpointDir(String sparkCheckpointDir) {
        this.sparkCheckpointDir = sparkCheckpointDir;
    }

    public String getSparkCheckpointDurationMillis() {
        return this.sparkCheckpointDurationMillis;
    }

    public void setSparkCheckpointDurationMillis(String sparkCheckpointDurationMillis) {
        this.sparkCheckpointDurationMillis = sparkCheckpointDurationMillis;
    }

    public boolean isSparkEnableSparkMetricSinks() {
        return this.sparkEnableSparkMetricSinks;
    }

    public void setSparkEnableSparkMetricSinks(boolean sparkEnableSparkMetricSinks) {
        this.sparkEnableSparkMetricSinks = sparkEnableSparkMetricSinks;
    }

    public String getSparkMaxRecordsPerBatch() {
        return this.sparkMaxRecordsPerBatch;
    }

    public void setSparkMaxRecordsPerBatch(String sparkMaxRecordsPerBatch) {
        this.sparkMaxRecordsPerBatch = sparkMaxRecordsPerBatch;
    }

    public String getSparkMinReadTimeMillis() {
        return this.sparkMinReadTimeMillis;
    }

    public void setSparkMinReadTimeMillis(String sparkMinReadTimeMillis) {
        this.sparkMinReadTimeMillis = sparkMinReadTimeMillis;
    }

    public String getSparkReadTimePercentage() {
        return this.sparkReadTimePercentage;
    }

    public void setSparkReadTimePercentage(String sparkReadTimePercentage) {
        this.sparkReadTimePercentage = sparkReadTimePercentage;
    }

    public String getSparkBundleSize() {
        return this.sparkBundleSize;
    }

    public void setSparkBundleSize(String sparkBundleSize) {
        this.sparkBundleSize = sparkBundleSize;
    }

    public String getSparkStorageLevel() {
        return this.sparkStorageLevel;
    }

    public void setSparkStorageLevel(String sparkStorageLevel) {
        this.sparkStorageLevel = sparkStorageLevel;
    }
}

