/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.util;

import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonRowMeta {
    public static String toJson(IRowMeta rowMeta) {
        JSONObject jRowMeta = new JSONObject();
        JSONArray jValues = new JSONArray();
        jRowMeta.put((Object)"values", (Object)jValues);
        for (int v = 0; v < rowMeta.size(); ++v) {
            IValueMeta valueMeta = rowMeta.getValueMeta(v);
            JSONObject jValue = new JSONObject();
            jValues.add((Object)jValue);
            jValue.put((Object)"name", (Object)valueMeta.getName());
            jValue.put((Object)"type", (Object)valueMeta.getType());
            jValue.put((Object)"length", (Object)valueMeta.getLength());
            jValue.put((Object)"precision", (Object)valueMeta.getPrecision());
            jValue.put((Object)"conversionMask", (Object)valueMeta.getConversionMask());
        }
        return jRowMeta.toJSONString();
    }

    public static IRowMeta fromJson(String rowMetaJson) throws ParseException, HopPluginException {
        JSONParser parser = new JSONParser();
        JSONObject jRowMeta = (JSONObject)parser.parse(rowMetaJson);
        RowMeta rowMeta = new RowMeta();
        JSONArray jValues = (JSONArray)jRowMeta.get((Object)"values");
        for (int v = 0; v < jValues.size(); ++v) {
            JSONObject jValue = (JSONObject)jValues.get(v);
            String name = (String)jValue.get((Object)"name");
            long type = (Long)jValue.get((Object)"type");
            long length = (Long)jValue.get((Object)"length");
            long precision = (Long)jValue.get((Object)"precision");
            String conversionMask = (String)jValue.get((Object)"conversionMask");
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)name, (int)((int)type), (int)((int)length), (int)((int)precision));
            valueMeta.setConversionMask(conversionMask);
            rowMeta.addValueMeta(valueMeta);
        }
        return rowMeta;
    }
}

