/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.shared.VariableValue;
import org.apache.hop.beam.core.transform.TransformTransform;
import org.apache.hop.beam.core.util.HopBeamUtil;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;
import org.apache.hop.pipeline.transforms.injector.InjectorField;
import org.apache.hop.pipeline.transforms.injector.InjectorMeta;
import org.joda.time.Instant;

public class TransformBatchTransform
extends TransformTransform {
    public TransformBatchTransform() {
    }

    public TransformBatchTransform(List<VariableValue> variableValues, String metastoreJson, List<String> transformPluginClasses, List<String> xpPluginClasses, int batchSize, int flushIntervalMs, String transformName, String transformPluginId, String transformMetaInterfaceXml, String inputRowMetaJson, boolean inputTransform, List<String> targetTransforms, List<String> infoTransforms, List<String> infoRowMetaJsons, List<PCollectionView<List<HopRow>>> infoCollectionViews) {
        super(variableValues, metastoreJson, transformPluginClasses, xpPluginClasses, batchSize, flushIntervalMs, transformName, transformPluginId, transformMetaInterfaceXml, inputRowMetaJson, inputTransform, targetTransforms, infoTransforms, infoRowMetaJsons, infoCollectionViews);
    }

    @Override
    public PCollectionTuple expand(PCollection<HopRow> input) {
        try {
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            TupleTag<HopRow> mainOutputTupleTag = new TupleTag<HopRow>(HopBeamUtil.createMainOutputTupleId(this.transformName)){};
            ArrayList<2> targetTupleTags = new ArrayList<2>();
            TupleTagList targetTupleTagList = null;
            for (String targetTransform : this.targetTransforms) {
                String tupleId = HopBeamUtil.createTargetTupleId(this.transformName, targetTransform);
                TupleTag<HopRow> tupleTag = new TupleTag<HopRow>(tupleId){};
                targetTupleTags.add(tupleTag);
                if (targetTupleTagList == null) {
                    targetTupleTagList = TupleTagList.of((TupleTag)tupleTag);
                    continue;
                }
                targetTupleTagList = targetTupleTagList.and((TupleTag)tupleTag);
            }
            if (targetTupleTagList == null) {
                targetTupleTagList = TupleTagList.empty();
            }
            TransformBatchFn transformBatchFn = new TransformBatchFn(this.variableValues, this.metastoreJson, this.transformPluginClasses, this.xpPluginClasses, this.transformName, this.transformPluginId, this.transformMetaInterfaceXml, this.inputRowMetaJson, this.inputTransform, this.targetTransforms, this.infoTransforms, this.infoRowMetaJsons);
            ParDo.SingleOutput parDoTransformFn = ParDo.of((DoFn)transformBatchFn);
            if (this.infoCollectionViews.size() > 0) {
                parDoTransformFn = parDoTransformFn.withSideInputs((Iterable)this.infoCollectionViews);
            }
            ParDo.MultiOutput multiOutput = parDoTransformFn.withOutputTags((TupleTag)mainOutputTupleTag, targetTupleTagList);
            PCollectionTuple collectionTuple = (PCollectionTuple)input.apply((PTransform)multiOutput);
            return collectionTuple;
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error transforming data in transform '" + this.transformName + "'", (Throwable)e);
            throw new RuntimeException("Error transforming data in transform", e);
        }
    }

    private class TransformFinishBundleContext
    implements TupleOutputContext<HopRow> {
        private DoFn.FinishBundleContext context;
        private BoundedWindow batchWindow;

        public TransformFinishBundleContext(DoFn.FinishBundleContext context, BoundedWindow batchWindow) {
            this.context = context;
            this.batchWindow = batchWindow;
        }

        @Override
        public void output(TupleTag<HopRow> tupleTag, HopRow output) {
            this.context.output(tupleTag, (Object)output, Instant.now(), this.batchWindow);
        }
    }

    private class TransformProcessContext
    implements TupleOutputContext<HopRow> {
        private DoFn.ProcessContext context;

        public TransformProcessContext(DoFn.ProcessContext processContext) {
            this.context = processContext;
        }

        @Override
        public void output(TupleTag<HopRow> tupleTag, HopRow output) {
            this.context.output(tupleTag, (Object)output);
        }
    }

    private static interface TupleOutputContext<T> {
        public void output(TupleTag<T> var1, T var2);
    }

    private class TransformBatchFn
    extends DoFn<HopRow, HopRow> {
        private static final long serialVersionUID = 95700000000000002L;
        public static final String INJECTOR_TRANSFORM_NAME = "_INJECTOR_";
        protected List<VariableValue> variableValues;
        protected String metastoreJson;
        protected List<String> transformPluginClasses;
        protected List<String> xpPluginClasses;
        protected String transformName;
        protected String transformPluginId;
        protected String transformMetaInterfaceXml;
        protected String inputRowMetaJson;
        protected List<String> targetTransforms;
        protected List<String> infoTransforms;
        protected List<String> infoRowMetaJsons;
        protected boolean inputTransform;
        protected boolean initialize;
        protected List<PCollection<HopRow>> infoCollections;
        private final Counter numErrors = Metrics.counter((String)"main", (String)"TransformProcessErrors");
        private transient PipelineMeta pipelineMeta;
        private transient TransformMeta transformMeta;
        private transient IRowMeta inputRowMeta;
        private transient IRowMeta outputRowMeta;
        private transient List<TransformMetaDataCombi> transformCombis;
        private transient LocalPipelineEngine pipeline;
        private transient RowProducer rowProducer;
        private transient IRowListener rowListener;
        private transient List<Object[]> resultRows;
        private transient List<List<Object[]>> targetResultRowsList;
        private transient List<IRowMeta> targetRowMetas;
        private transient List<IRowMeta> infoRowMetas;
        private transient List<RowProducer> infoRowProducers;
        private transient TupleTag<HopRow> mainTupleTag;
        private transient List<TupleTag<HopRow>> tupleTagList;
        private transient Counter initCounter;
        private transient Counter readCounter;
        private transient Counter writtenCounter;
        private transient Counter flushBufferCounter;
        private transient SingleThreadedPipelineExecutor executor;
        private transient Queue<HopRow> rowBuffer;
        private transient BoundedWindow batchWindow;
        private transient AtomicLong lastTimerCheck;
        private transient Timer timer;
        private transient int maxInputBufferSize = 0;
        private transient int minInputBufferSize = Integer.MAX_VALUE;

        public TransformBatchFn() {
        }

        public TransformBatchFn(List<VariableValue> variableValues, String metastoreJson, List<String> transformPluginClasses, List<String> xpPluginClasses, String transformName, String transformPluginId, String transformMetaInterfaceXml, String inputRowMetaJson, boolean inputTransform, List<String> targetTransforms, List<String> infoTransforms, List<String> infoRowMetaJsons) {
            this();
            this.variableValues = variableValues;
            this.metastoreJson = metastoreJson;
            this.transformPluginClasses = transformPluginClasses;
            this.xpPluginClasses = xpPluginClasses;
            this.transformName = transformName;
            this.transformPluginId = transformPluginId;
            this.transformMetaInterfaceXml = transformMetaInterfaceXml;
            this.inputRowMetaJson = inputRowMetaJson;
            this.inputTransform = inputTransform;
            this.targetTransforms = targetTransforms;
            this.infoTransforms = infoTransforms;
            this.infoRowMetaJsons = infoRowMetaJsons;
            this.initialize = true;
        }

        @DoFn.StartBundle
        public void startBundle(DoFn.StartBundleContext startBundleContext) {
            Metrics.counter((String)"startBundle", (String)this.transformName).inc();
            if ("ScriptValueMod".equals(this.transformPluginId) && this.pipeline != null) {
                this.initialize = true;
            }
        }

        @DoFn.Setup
        public void setup() {
            try {
                this.rowBuffer = new ConcurrentLinkedQueue<HopRow>();
            }
            catch (Exception e) {
                this.numErrors.inc();
                TransformTransform.LOG.info("Transform '" + this.transformName + "' : setup error :" + e.getMessage());
                throw new RuntimeException("Unable to set up transform " + this.transformName, e);
            }
        }

        @DoFn.Teardown
        public void tearDown() {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @DoFn.ProcessElement
        public void processElement(final DoFn.ProcessContext context, BoundedWindow window) {
            try {
                if (this.initialize) {
                    void var12_28;
                    RowProducer infoRowProducer;
                    this.initialize = false;
                    BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
                    SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(this.metastoreJson);
                    this.pipelineMeta = new PipelineMeta();
                    this.pipelineMeta.setPipelineType(PipelineMeta.PipelineType.SingleThreaded);
                    this.pipelineMeta.setMetadataProvider((IHopMetadataProvider)metadataProvider);
                    this.lastTimerCheck = new AtomicLong(-1L);
                    this.inputRowMeta = JsonRowMeta.fromJson(this.inputRowMetaJson);
                    this.infoRowMetas = new ArrayList<IRowMeta>();
                    for (String infoRowMetaJson : this.infoRowMetaJsons) {
                        IRowMeta infoRowMeta = JsonRowMeta.fromJson(infoRowMetaJson);
                        this.infoRowMetas.add(infoRowMeta);
                    }
                    TransformMeta mainInjectorTransformMeta = null;
                    if (!this.inputTransform) {
                        mainInjectorTransformMeta = this.createInjectorTransform(this.pipelineMeta, INJECTOR_TRANSFORM_NAME, this.inputRowMeta, 200, 200);
                    }
                    int targetLocationY = 200;
                    ArrayList<TransformMeta> targetTransformMetas = new ArrayList<TransformMeta>();
                    for (String targetTransform : this.targetTransforms) {
                        DummyMeta dummyMeta = new DummyMeta();
                        TransformMeta targetTransformMeta = new TransformMeta(targetTransform, (ITransformMeta)dummyMeta);
                        targetTransformMeta.setLocation(600, targetLocationY);
                        targetLocationY += 150;
                        targetTransformMetas.add(targetTransformMeta);
                        this.pipelineMeta.addTransform(targetTransformMeta);
                    }
                    ArrayList<List> infoDataSets = new ArrayList<List>();
                    ArrayList<TransformMeta> infoTransformMetas = new ArrayList<TransformMeta>();
                    for (int i = 0; i < this.infoTransforms.size(); ++i) {
                        String infoTransform = this.infoTransforms.get(i);
                        PCollectionView cv = (PCollectionView)TransformBatchTransform.this.infoCollectionViews.get(i);
                        List list = (List)context.sideInput(cv);
                        infoDataSets.add(list);
                        IRowMeta infoRowMeta = this.infoRowMetas.get(i);
                        TransformMeta infoTransformMeta = this.createInjectorTransform(this.pipelineMeta, infoTransform, infoRowMeta, 200, 350 + 150 * i);
                        infoTransformMetas.add(infoTransformMeta);
                    }
                    this.transformCombis = new ArrayList<TransformMetaDataCombi>();
                    PluginRegistry registry = PluginRegistry.getInstance();
                    ITransformMeta iTransformMeta = (ITransformMeta)registry.loadClass(TransformPluginType.class, this.transformPluginId, ITransformMeta.class);
                    if (iTransformMeta == null) {
                        throw new HopException("Unable to load transform plugin with ID " + this.transformPluginId + ", this plugin isn't in the plugin registry or classpath");
                    }
                    HopBeamUtil.loadTransformMetadataFromXml(this.transformName, iTransformMeta, this.transformMetaInterfaceXml, this.pipelineMeta.getMetadataProvider());
                    this.transformMeta = new TransformMeta(this.transformName, iTransformMeta);
                    this.transformMeta.setTransformPluginId(this.transformPluginId);
                    this.transformMeta.setLocation(400, 200);
                    this.pipelineMeta.addTransform(this.transformMeta);
                    if (!this.inputTransform) {
                        this.pipelineMeta.addPipelineHop(new PipelineHopMeta(mainInjectorTransformMeta, this.transformMeta));
                    }
                    for (TransformMeta transformMeta : targetTransformMetas) {
                        this.pipelineMeta.addPipelineHop(new PipelineHopMeta(this.transformMeta, transformMeta));
                    }
                    for (TransformMeta transformMeta : infoTransformMetas) {
                        this.pipelineMeta.addPipelineHop(new PipelineHopMeta(transformMeta, this.transformMeta));
                    }
                    iTransformMeta.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
                    this.pipeline = new LocalPipelineEngine(this.pipelineMeta, Variables.getADefaultVariableSpace(), (ILoggingObject)new LoggingObject((Object)"apache-beam-transform"));
                    this.pipeline.setLogLevel(LogLevel.ERROR);
                    this.pipeline.setMetadataProvider(this.pipelineMeta.getMetadataProvider());
                    for (VariableValue variableValue : this.variableValues) {
                        if (!StringUtils.isNotEmpty((String)variableValue.getVariable())) continue;
                        this.pipeline.setVariable(variableValue.getVariable(), variableValue.getValue());
                    }
                    this.pipeline.prepareExecution();
                    this.rowProducer = null;
                    if (!this.inputTransform) {
                        this.rowProducer = this.pipeline.addRowProducer(INJECTOR_TRANSFORM_NAME, 0);
                    }
                    this.infoRowProducers = new ArrayList<RowProducer>();
                    for (String string : this.infoTransforms) {
                        infoRowProducer = this.pipeline.addRowProducer(string, 0);
                        this.infoRowProducers.add(infoRowProducer);
                    }
                    if (!this.inputTransform) {
                        TransformMetaDataCombi injectorCombi = this.findCombi((Pipeline)this.pipeline, INJECTOR_TRANSFORM_NAME);
                        this.transformCombis.add(injectorCombi);
                    }
                    TransformMetaDataCombi transformCombi = this.findCombi((Pipeline)this.pipeline, this.transformName);
                    this.transformCombis.add(transformCombi);
                    this.outputRowMeta = this.pipelineMeta.getTransformFields((IVariables)this.pipeline, this.transformName);
                    if (this.targetTransforms.isEmpty()) {
                        this.rowListener = new RowAdapter(){

                            public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) {
                                TransformBatchFn.this.resultRows.add(row);
                            }
                        };
                        transformCombi.transform.addRowListener(this.rowListener);
                    }
                    this.mainTupleTag = new TupleTag<HopRow>(HopBeamUtil.createMainOutputTupleId(this.transformName)){};
                    this.tupleTagList = new ArrayList<TupleTag<HopRow>>();
                    this.targetRowMetas = new ArrayList<IRowMeta>();
                    this.targetResultRowsList = new ArrayList<List<Object[]>>();
                    for (String targetTransform : this.targetTransforms) {
                        TransformMetaDataCombi targetCombi = this.findCombi((Pipeline)this.pipeline, targetTransform);
                        this.transformCombis.add(targetCombi);
                        this.targetRowMetas.add(this.pipelineMeta.getTransformFields((IVariables)this.pipeline, transformCombi.transformName));
                        String tupleId = HopBeamUtil.createTargetTupleId(this.transformName, targetTransform);
                        TupleTag<HopRow> tupleTag = new TupleTag<HopRow>(tupleId){};
                        this.tupleTagList.add(tupleTag);
                        final ArrayList targetResultRows = new ArrayList();
                        this.targetResultRowsList.add(targetResultRows);
                        targetCombi.transform.addRowListener((IRowListener)new RowAdapter(){

                            public void rowReadEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                                targetResultRows.add(row);
                            }
                        });
                    }
                    this.executor = new SingleThreadedPipelineExecutor((Pipeline)this.pipeline);
                    this.executor.init();
                    this.initCounter = Metrics.counter((String)"init", (String)this.transformName);
                    this.readCounter = Metrics.counter((String)"read", (String)this.transformName);
                    this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                    this.flushBufferCounter = Metrics.counter((String)"flush_buffer", (String)this.transformName);
                    this.initCounter.inc();
                    this.pipeline.startThreads();
                    this.resultRows = new ArrayList<Object[]>();
                    boolean bl = false;
                    while (var12_28 < this.infoTransforms.size()) {
                        infoRowProducer = this.infoRowProducers.get((int)var12_28);
                        List infoDataSet = (List)infoDataSets.get((int)var12_28);
                        TransformMetaDataCombi combi = this.findCombi((Pipeline)this.pipeline, this.infoTransforms.get((int)var12_28));
                        IRowMeta infoRowMeta = this.infoRowMetas.get((int)var12_28);
                        for (HopRow infoRowData : infoDataSet) {
                            infoRowProducer.putRow(infoRowMeta, infoRowData.getRow());
                            combi.transform.processRow();
                        }
                        infoRowProducer.finished();
                        combi.transform.processRow();
                        ++var12_28;
                    }
                    if (TransformBatchTransform.this.flushIntervalMs > 0) {
                        TimerTask timerTask = new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Queue queue = TransformBatchFn.this.rowBuffer;
                                synchronized (queue) {
                                    long difference = System.currentTimeMillis() - TransformBatchFn.this.lastTimerCheck.get();
                                    if (TransformBatchFn.this.lastTimerCheck.get() <= 0L || difference > (long)TransformBatchTransform.this.flushIntervalMs) {
                                        try {
                                            TransformBatchFn.this.emptyRowBuffer(new TransformProcessContext(context));
                                        }
                                        catch (Exception e) {
                                            throw new RuntimeException("Unable to flush row buffer when it got stale after " + difference + " ms", e);
                                        }
                                        TransformBatchFn.this.lastTimerCheck.set(System.currentTimeMillis());
                                    }
                                }
                            }
                        };
                        this.timer = new Timer("Flush timer of transform " + this.transformName);
                        this.timer.schedule(timerTask, 100L, 100L);
                    }
                }
                HopRow originalInputRow = (HopRow)context.element();
                HopRow inputRow = HopBeamUtil.copyHopRow(originalInputRow, this.inputRowMeta);
                this.readCounter.inc();
                if (TransformBatchTransform.this.flushIntervalMs > 0 && this.rowBuffer.isEmpty()) {
                    this.lastTimerCheck.set(System.currentTimeMillis());
                }
                Queue<HopRow> queue = this.rowBuffer;
                synchronized (queue) {
                    this.rowBuffer.add(inputRow);
                    this.batchWindow = window;
                    Queue<HopRow> queue2 = this.rowBuffer;
                    synchronized (queue2) {
                        if (this.rowBuffer.size() >= TransformBatchTransform.this.batchSize) {
                            this.emptyRowBuffer(new TransformProcessContext(context));
                        }
                    }
                }
            }
            catch (Exception e) {
                this.numErrors.inc();
                TransformTransform.LOG.info("Transform execution error :" + e.getMessage());
                throw new RuntimeException("Error executing TransformBatchFn", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext context) {
            try {
                Queue<HopRow> queue = this.rowBuffer;
                synchronized (queue) {
                    if (!this.rowBuffer.isEmpty()) {
                        this.emptyRowBuffer(new TransformFinishBundleContext(context, this.batchWindow));
                    }
                }
            }
            catch (Exception e) {
                this.numErrors.inc();
                TransformTransform.LOG.info("Transform finishing bundle error :" + e.getMessage());
                throw new RuntimeException("Error finalizing bundle of transform '" + this.transformName + "'", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void emptyRowBuffer(TupleOutputContext<HopRow> context) throws HopException {
            Queue<HopRow> queue = this.rowBuffer;
            synchronized (queue) {
                ArrayList<HopRow> buffer = new ArrayList<HopRow>();
                int size = this.rowBuffer.size();
                for (int i = 0; i < size; ++i) {
                    HopRow hopRow = this.rowBuffer.poll();
                    buffer.add(hopRow);
                }
                if (buffer.isEmpty()) {
                    return;
                }
                if (!this.rowBuffer.isEmpty()) {
                    System.err.println("Async action detected on rowBuffer");
                }
                this.resultRows.clear();
                for (int t = 0; t < this.targetTransforms.size(); ++t) {
                    this.targetResultRowsList.get(t).clear();
                }
                if (!this.inputTransform) {
                    int bufferSize = buffer.size();
                    if (this.maxInputBufferSize < bufferSize) {
                        Metrics.counter((String)"maxInputSize", (String)this.transformName).inc((long)(bufferSize - this.maxInputBufferSize));
                        this.maxInputBufferSize = bufferSize;
                    }
                    if (this.minInputBufferSize > bufferSize) {
                        if (this.minInputBufferSize == Integer.MAX_VALUE) {
                            Metrics.counter((String)"minInputSize", (String)this.transformName).inc((long)bufferSize);
                        } else {
                            Metrics.counter((String)"minInputSize", (String)this.transformName).dec((long)(bufferSize - this.minInputBufferSize));
                        }
                        this.minInputBufferSize = bufferSize;
                    }
                    for (HopRow inputRow : buffer) {
                        this.rowProducer.putRow(this.inputRowMeta, inputRow.getRow());
                    }
                }
                this.executor.oneIteration();
                for (Object[] resultRow : this.resultRows) {
                    context.output(this.mainTupleTag, new HopRow(resultRow));
                    this.writtenCounter.inc();
                }
                for (int t = 0; t < this.targetResultRowsList.size(); ++t) {
                    List<Object[]> targetRowsList = this.targetResultRowsList.get(t);
                    TupleTag<HopRow> tupleTag = this.tupleTagList.get(t);
                    for (Object[] targetRow : targetRowsList) {
                        context.output(tupleTag, new HopRow(targetRow));
                    }
                }
                this.flushBufferCounter.inc();
                buffer.clear();
                this.lastTimerCheck.set(System.currentTimeMillis());
            }
        }

        private TransformMeta createInjectorTransform(PipelineMeta pipelineMeta, String injectorTransformName, IRowMeta injectorRowMeta, int x, int y) {
            InjectorMeta injectorMeta = new InjectorMeta();
            for (IValueMeta valueMeta : injectorRowMeta.getValueMetaList()) {
                injectorMeta.getInjectorFields().add(new InjectorField(valueMeta.getName(), valueMeta.getTypeDesc(), Integer.toString(valueMeta.getLength()), Integer.toString(valueMeta.getPrecision())));
            }
            TransformMeta injectorTransformMeta = new TransformMeta(injectorTransformName, (ITransformMeta)injectorMeta);
            injectorTransformMeta.setLocation(x, y);
            pipelineMeta.addTransform(injectorTransformMeta);
            return injectorTransformMeta;
        }

        private TransformMetaDataCombi findCombi(Pipeline pipeline, String transformName) {
            for (TransformMetaDataCombi combi : pipeline.getTransforms()) {
                if (!combi.transformName.equals(transformName)) continue;
                return combi;
            }
            throw new RuntimeException("Configuration error, transform '" + transformName + "' not found in transformation");
        }
    }
}

