/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.io.File;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.HopToStringFn;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.row.IRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamOutputTransform
extends PTransform<PCollection<HopRow>, PDone> {
    private String transformName;
    private String outputLocation;
    private String filePrefix;
    private String fileSuffix;
    private String separator;
    private String enclosure;
    private String rowMetaJson;
    private boolean windowed;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(BeamOutputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamOutputError");

    public BeamOutputTransform() {
    }

    public BeamOutputTransform(String transformName, String outputLocation, String filePrefix, String fileSuffix, String separator, String enclosure, boolean windowed, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.transformName = transformName;
        this.outputLocation = outputLocation;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this.separator = separator;
        this.enclosure = enclosure;
        this.windowed = windowed;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    public PDone expand(PCollection<HopRow> input) {
        try {
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            IRowMeta rowMeta = JsonRowMeta.fromJson(this.rowMetaJson);
            PCollection stringCollection = (PCollection)input.apply(this.transformName, (PTransform)ParDo.of((DoFn)new HopToStringFn(this.transformName, this.outputLocation, this.separator, this.enclosure, this.rowMetaJson, this.transformPluginClasses, this.xpPluginClasses)));
            TextIO.Write write = TextIO.write();
            if (StringUtils.isNotEmpty((String)this.outputLocation)) {
                String outputPrefix = this.outputLocation;
                if (!outputPrefix.endsWith(File.separator)) {
                    outputPrefix = outputPrefix + File.separator;
                }
                if (StringUtils.isNotEmpty((String)this.filePrefix)) {
                    outputPrefix = outputPrefix + this.filePrefix;
                }
                write = write.to(outputPrefix);
            }
            if (StringUtils.isNotEmpty((String)this.fileSuffix)) {
                write = write.withSuffix(this.fileSuffix);
            }
            if (this.windowed) {
                write = write.withWindowedWrites().withNumShards(4);
            }
            stringCollection.apply((PTransform)write);
            return PDone.in((Pipeline)input.getPipeline());
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in beam output transform", (Throwable)e);
            throw new RuntimeException("Error in beam output transform", e);
        }
    }

    public String getTransformName() {
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getRowMetaJson() {
        return this.rowMetaJson;
    }

    public void setRowMetaJson(String rowMetaJson) {
        this.rowMetaJson = rowMetaJson;
    }
}

