/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.List;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.HopRowToKVStringStringFn;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamKafkaOutputTransform
extends PTransform<PCollection<HopRow>, PDone> {
    private String transformName;
    private String bootstrapServers;
    private String topic;
    private String keyField;
    private String messageField;
    private String rowMetaJson;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(BeamKafkaOutputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKafkaOutputError");

    public BeamKafkaOutputTransform() {
    }

    public BeamKafkaOutputTransform(String transformName, String bootstrapServers, String topic, String keyField, String messageField, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.transformName = transformName;
        this.bootstrapServers = bootstrapServers;
        this.topic = topic;
        this.keyField = keyField;
        this.messageField = messageField;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    public PDone expand(PCollection<HopRow> input) {
        try {
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            IRowMeta rowMeta = JsonRowMeta.fromJson(this.rowMetaJson);
            int keyIndex = rowMeta.indexOfValue(this.keyField);
            if (keyIndex < 0) {
                throw new HopException("Unable to find key field " + this.keyField + " in input row: " + rowMeta.toString());
            }
            int messageIndex = rowMeta.indexOfValue(this.messageField);
            if (messageIndex < 0) {
                throw new HopException("Unable to find message field " + this.messageField + " in input row: " + rowMeta.toString());
            }
            HopRowToKVStringStringFn hopRowToKVStringStringFn = new HopRowToKVStringStringFn(this.transformName, keyIndex, messageIndex, this.rowMetaJson, this.transformPluginClasses, this.xpPluginClasses);
            KafkaIO.Write stringsToKafka = KafkaIO.write().withBootstrapServers(this.bootstrapServers).withTopic(this.topic).withKeySerializer(StringSerializer.class).withValueSerializer(StringSerializer.class);
            PCollection kvpCollection = (PCollection)input.apply((PTransform)ParDo.of((DoFn)hopRowToKVStringStringFn));
            return (PDone)kvpCollection.apply((PTransform)stringsToKafka);
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in Beam Kafka output transform", (Throwable)e);
            throw new RuntimeException("Error in Beam Kafka output transform", e);
        }
    }
}

