/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.KVStringStringToHopRowFn;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamKafkaInputTransform
extends PTransform<PBegin, PCollection<HopRow>> {
    private String transformName;
    private String bootstrapServers;
    private String topics;
    private String groupId;
    private boolean usingProcessingTime;
    private boolean usingLogAppendTime;
    private boolean usingCreateTime;
    private boolean restrictedToCommitted;
    private boolean allowingCommitOnConsumedOffset;
    private List<ConfigOption> configOptions;
    private String rowMetaJson;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(BeamKafkaInputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKafkaInputError");
    private transient IRowMeta rowMeta;

    public BeamKafkaInputTransform() {
    }

    public BeamKafkaInputTransform(@Nullable String name, String transformName, String bootstrapServers, String topics, String groupId, boolean usingProcessingTime, boolean usingLogAppendTime, boolean usingCreateTime, boolean restrictedToCommitted, boolean allowingCommitOnConsumedOffset, String[] configOptionParameters, String[] configOptionValues, String[] configOptionTypes, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        super(name);
        this.transformName = transformName;
        this.bootstrapServers = bootstrapServers;
        this.topics = topics;
        this.groupId = groupId;
        this.usingProcessingTime = usingProcessingTime;
        this.usingLogAppendTime = usingLogAppendTime;
        this.usingCreateTime = usingCreateTime;
        this.restrictedToCommitted = restrictedToCommitted;
        this.allowingCommitOnConsumedOffset = allowingCommitOnConsumedOffset;
        this.configOptions = new ArrayList<ConfigOption>();
        for (int i = 0; i < configOptionParameters.length; ++i) {
            this.configOptions.add(new ConfigOption(configOptionParameters[i], configOptionValues[i], ConfigOption.Type.getTypeFromName(configOptionTypes[i])));
        }
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    public PCollection<HopRow> expand(PBegin input) {
        try {
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            ArrayList<String> topicList = new ArrayList<String>();
            for (String topic : this.topics.split(",")) {
                topicList.add(Const.trim((String)topic));
            }
            HashMap<String, Object> consumerConfigUpdates = new HashMap<String, Object>();
            consumerConfigUpdates.put("group.id", this.groupId);
            for (ConfigOption configOption : this.configOptions) {
                Object value;
                String optionValue = configOption.getValue();
                switch (configOption.getType()) {
                    case String: {
                        value = optionValue;
                        break;
                    }
                    case Short: {
                        value = Short.valueOf(optionValue);
                        break;
                    }
                    case Int: {
                        value = Integer.valueOf(optionValue);
                        break;
                    }
                    case Long: {
                        value = Long.valueOf(optionValue);
                        break;
                    }
                    case Double: {
                        value = Double.valueOf(optionValue);
                        break;
                    }
                    case Boolean: {
                        value = Boolean.valueOf(optionValue);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Config option parameter " + configOption.getParameter() + " uses unsupported type " + configOption.getType().name());
                    }
                }
                consumerConfigUpdates.put(configOption.getParameter(), value);
            }
            KafkaIO.Read io = KafkaIO.read().withBootstrapServers(this.bootstrapServers).withConsumerConfigUpdates(consumerConfigUpdates).withTopics(topicList).withKeyDeserializer(StringDeserializer.class).withValueDeserializer(StringDeserializer.class);
            if (this.usingProcessingTime) {
                io = io.withProcessingTime();
            }
            if (this.usingLogAppendTime) {
                io = io.withLogAppendTime();
            }
            if (this.usingCreateTime) {
                io = io.withCreateTime(Duration.ZERO);
            }
            if (this.restrictedToCommitted) {
                io = io.withReadCommitted();
            }
            if (this.allowingCommitOnConsumedOffset) {
                io = io.commitOffsetsInFinalize();
            }
            PCollection kafkaConsumerOutput = (PCollection)input.apply(io.withoutMetadata());
            PCollection output = (PCollection)kafkaConsumerOutput.apply((PTransform)ParDo.of((DoFn)new KVStringStringToHopRowFn(this.transformName, this.rowMetaJson, this.transformPluginClasses, this.xpPluginClasses)));
            return output;
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in Kafka input transform", (Throwable)e);
            throw new RuntimeException("Error in Kafka input transform", e);
        }
    }
}

