/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVStringStringToHopRowFn
extends DoFn<KV<String, String>, HopRow> {
    private String rowMetaJson;
    private String transformName;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(KVStringStringToHopRowFn.class);
    private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamSubscribeTransformErrors");
    private IRowMeta rowMeta;
    private transient Counter initCounter;
    private transient Counter inputCounter;
    private transient Counter writtenCounter;

    public KVStringStringToHopRowFn(String transformName, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
            this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.rowMeta = JsonRowMeta.fromJson(this.rowMetaJson);
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in setup of KV<Long,String> to Hop Row conversion function", (Throwable)e);
            throw new RuntimeException("Error in setup of KV<Long,String> to Hop Row conversion function", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            KV kv = (KV)processContext.element();
            this.inputCounter.inc();
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.rowMeta.size());
            outputRow[0] = kv.getKey();
            outputRow[1] = kv.getValue();
            processContext.output((Object)new HopRow(outputRow));
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in KV<Long,String> to Hop Row conversion function", (Throwable)e);
            throw new RuntimeException("Error in KV<Long,String> to Hop Row conversion function", e);
        }
    }
}

