/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.row.IRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopRowToKVStringStringFn
extends DoFn<HopRow, KV<String, String>> {
    private String rowMetaJson;
    private String transformName;
    private int keyIndex;
    private int valueIndex;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(HopRowToKVStringStringFn.class);
    private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamSubscribeTransformErrors");
    private IRowMeta rowMeta;
    private transient Counter initCounter;
    private transient Counter inputCounter;
    private transient Counter writtenCounter;

    public HopRowToKVStringStringFn(String transformName, int keyIndex, int valueIndex, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.transformName = transformName;
        this.keyIndex = keyIndex;
        this.valueIndex = valueIndex;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
            this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.rowMeta = JsonRowMeta.fromJson(this.rowMetaJson);
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in setup of HopRow to KV<String,String> function", (Throwable)e);
            throw new RuntimeException("Error in setup of HopRow to KV<String,String> function", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            HopRow hopRow = (HopRow)processContext.element();
            this.inputCounter.inc();
            String key = this.rowMeta.getString(hopRow.getRow(), this.keyIndex);
            String value = this.rowMeta.getString(hopRow.getRow(), this.valueIndex);
            processContext.output((Object)KV.of((Object)key, (Object)value));
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in HopRow to KV<String,String> function", (Throwable)e);
            throw new RuntimeException("Error in HopRow to KV<String,String> function", e);
        }
    }
}

