/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.coder;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.hop.beam.core.HopRow;

public class HopRowCoder
extends AtomicCoder<HopRow> {
    public void encode(HopRow value, OutputStream outStream) throws CoderException, IOException {
        Object[] row = value.getRow();
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        if (row == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(row.length);
        for (int i = 0; i < row.length; ++i) {
            Object object = row[i];
            out.writeBoolean(object == null);
            if (object == null) continue;
            int objectType = this.getObjectType(object);
            out.writeInt(objectType);
            this.write(out, objectType, object);
        }
        out.flush();
    }

    public HopRow decode(InputStream inStream) throws CoderException, IOException {
        ObjectInputStream in = new ObjectInputStream(inStream);
        Object[] row = null;
        int length = in.readInt();
        if (length < 0) {
            return new HopRow(row);
        }
        row = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object object;
            boolean isNull = in.readBoolean();
            if (isNull) continue;
            int objectType = in.readInt();
            row[i] = object = this.read(in, objectType);
        }
        return new HopRow(row);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
    }

    private void write(ObjectOutputStream out, int objectType, Object object) throws IOException {
        switch (objectType) {
            case 2: {
                String string = (String)object;
                byte[] data = string.getBytes(StandardCharsets.UTF_8);
                out.writeInt(data.length);
                out.write(data);
                break;
            }
            case 5: {
                Long lng = (Long)object;
                out.writeLong(lng);
                break;
            }
            case 3: {
                Long lng = ((Date)object).getTime();
                out.writeLong(lng);
                break;
            }
            case 4: {
                boolean b = (Boolean)object;
                out.writeBoolean(b);
                break;
            }
            case 1: {
                Double dbl = (Double)object;
                out.writeDouble(dbl);
                break;
            }
            case 6: {
                BigDecimal bd = (BigDecimal)object;
                out.writeUTF(bd.toString());
                break;
            }
            default: {
                throw new IOException("Data type not supported yet: " + objectType + " - " + object.toString());
            }
        }
    }

    private Object read(ObjectInputStream in, int objectType) throws IOException {
        switch (objectType) {
            case 2: {
                int length = in.readInt();
                byte[] data = new byte[length];
                in.readFully(data);
                String string = new String(data, StandardCharsets.UTF_8);
                return string;
            }
            case 5: {
                Long lng = in.readLong();
                return lng;
            }
            case 3: {
                Long lng = in.readLong();
                return new Date(lng);
            }
            case 4: {
                boolean b = in.readBoolean();
                return b;
            }
            case 1: {
                Double dbl = in.readDouble();
                return dbl;
            }
            case 6: {
                String bd = in.readUTF();
                return new BigDecimal(bd);
            }
        }
        throw new IOException("Data type not supported yet: " + objectType);
    }

    private int getObjectType(Object object) throws CoderException {
        if (object instanceof String) {
            return 2;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof Date) {
            return 3;
        }
        if (object instanceof Timestamp) {
            return 9;
        }
        if (object instanceof Boolean) {
            return 4;
        }
        if (object instanceof Double) {
            return 1;
        }
        if (object instanceof BigDecimal) {
            return 6;
        }
        throw new CoderException("Data type for object class " + object.getClass().getName() + " isn't supported yet");
    }
}

