/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.gui.HopBeamGuiPlugin;
import org.apache.hop.beam.pipeline.fatjar.FatJarBuilder;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import picocli.CommandLine;

@ConfigPlugin(id="GenerateFatJarConfigPlugin", description="Allows you to create a fat jar using the current Hop software installation")
public class GenerateFatJarConfigPlugin
implements IConfigOptions {
    @CommandLine.Option(names={"-fj", "--generate-fat-jar"}, description={"Specify the filename of the fat jar to generate from your current software installation"})
    private String fatJarFilename;

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        try {
            boolean changed = false;
            if (StringUtils.isNotEmpty((String)this.fatJarFilename)) {
                this.createFatJar(log, variables);
                changed = true;
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling environment configuration options", (Throwable)e);
        }
    }

    private void createFatJar(ILogChannel log, IVariables variables) throws HopException {
        String realFatJarFilename = variables.resolve(this.fatJarFilename);
        log.logBasic("Generating a Hop fat jar file in : " + realFatJarFilename);
        List<String> installedJarFilenames = HopBeamGuiPlugin.findInstalledJarFilenames();
        log.logBasic("Found " + installedJarFilenames.size() + " jar files to combine into one fat jar file.");
        FatJarBuilder fatJarBuilder = new FatJarBuilder(variables, realFatJarFilename, installedJarFilenames);
        fatJarBuilder.setExtraTransformPluginClasses(null);
        fatJarBuilder.setExtraXpPluginClasses(null);
        fatJarBuilder.buildTargetJar();
        log.logBasic("Created fat jar.");
    }

    public String getFatJarFilename() {
        return this.fatJarFilename;
    }

    public void setFatJarFilename(String fatJarFilename) {
        this.fatJarFilename = fatJarFilename;
    }
}

