/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pipelineexecutor;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorMeta;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorParameters;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PipelineExecutorDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = PipelineExecutorDialog.class;
    private static int FIELD_DESCRIPTION = 1;
    private static int FIELD_NAME = 2;
    private PipelineExecutorMeta pipelineExecutorMeta;
    private Label wlPath;
    private TextVar wPath;
    protected Label wlRunConfiguration;
    protected ComboVar wRunConfiguration;
    private Button wbBrowse;
    private CTabFolder wTabFolder;
    private PipelineMeta executorPipelineMeta = null;
    protected boolean jobModified;
    private ModifyListener lsMod;
    private Button wInheritAll;
    private TableView wPipelineExecutorParameters;
    private Label wlGroupSize;
    private TextVar wGroupSize;
    private Label wlGroupField;
    private CCombo wGroupField;
    private Label wlGroupTime;
    private TextVar wGroupTime;
    private Label wlExecutionResultTarget;
    private CCombo wExecutionResultTarget;
    private TableItem tiExecutionTimeField;
    private TableItem tiExecutionResultField;
    private TableItem tiExecutionNrErrorsField;
    private TableItem tiExecutionLinesReadField;
    private TableItem tiExecutionLinesWrittenField;
    private TableItem tiExecutionLinesInputField;
    private TableItem tiExecutionLinesOutputField;
    private TableItem tiExecutionLinesRejectedField;
    private TableItem tiExecutionLinesUpdatedField;
    private TableItem tiExecutionLinesDeletedField;
    private TableItem tiExecutionFilesRetrievedField;
    private TableItem tiExecutionExitStatusField;
    private TableItem tiExecutionLogTextField;
    private TableItem tiExecutionLogChannelIdField;
    private String executorOutputTransform;
    private ColumnInfo[] parameterColumns;
    private Label wlResultFilesTarget;
    private CCombo wResultFilesTarget;
    private Label wlResultFileNameField;
    private TextVar wResultFileNameField;
    private Label wlResultRowsTarget;
    private CCombo wOutputRowsSource;
    private Label wlOutputFields;
    private TableView wOutputFields;
    private Button wGetParameters;

    public PipelineExecutorDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.pipelineExecutorMeta = (PipelineExecutorMeta)((Object)in);
        this.jobModified = false;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.pipelineExecutorMeta);
        this.lsMod = e -> {
            this.pipelineExecutorMeta.setChanged();
            this.setFlags();
        };
        this.changed = this.pipelineExecutorMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        PipelineExecutorDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.props.getMargin(), null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, 0);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.right = new FormAttachment((Control)wicon, -5);
        this.fdTransformName.left = new FormAttachment(0, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 5);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wTransformName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Pipeline.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlTransformation);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, 0);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addListener(13, e -> this.selectPipelineFile());
        this.wPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(0, 0);
        fdTransformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdTransformation.right = new FormAttachment((Control)this.wbBrowse, -this.props.getMargin());
        this.wPath.setLayoutData((Object)fdTransformation);
        this.wlRunConfiguration = new Label((Composite)this.shell, 16384);
        this.wlRunConfiguration.setText("Run configuration");
        this.props.setLook((Control)this.wlRunConfiguration);
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.left = new FormAttachment(0, 0);
        fdlRunConfiguration.top = new FormAttachment((Control)this.wPath, PropsUi.getInstance().getMargin());
        fdlRunConfiguration.right = new FormAttachment(50, 0);
        this.wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar(this.variables, (Composite)this.shell, 18432);
        this.props.setLook((Control)this.wlRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.left = new FormAttachment(0, 0);
        fdRunConfiguration.top = new FormAttachment((Control)this.wlRunConfiguration, this.props.getMargin());
        fdRunConfiguration.right = new FormAttachment(100, 0);
        this.wRunConfiguration.setLayoutData((Object)fdRunConfiguration);
        this.props.setLook((Control)this.wRunConfiguration);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setUnselectedCloseVisible(true);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wRunConfiguration, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addParametersTab();
        this.addExecutionResultTab();
        this.addRowGroupTab();
        this.addResultRowsTab();
        this.addResultFilesTab();
        this.getData();
        this.pipelineExecutorMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ui/images/pipelineexecutor.svg", (int)48, (int)48);
    }

    private void selectPipelineFile() {
        String curFile = this.variables.resolve(this.wPath.getText());
        String parentFolder = null;
        try {
            parentFolder = HopVfs.getFileObject((String)this.variables.resolve(this.pipelineMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            HopPipelineFileType fileType = HopGui.getDataOrchestrationPerspective().getPipelineFileType();
            String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])fileType.getFilterExtensions(), (String[])fileType.getFilterNames(), (boolean)true);
            if (filename != null) {
                this.loadPipelineFile(filename);
                if (parentFolder != null && filename.startsWith(parentFolder)) {
                    filename = filename.replace(parentFolder, "${Internal.Entry.Current.Folder}");
                }
                this.wPath.setText(filename);
            }
            if (filename != null) {
                this.replaceNameWithBaseFilename(filename);
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingPipeline.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingPipeline.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadPipelineFile(String fname) throws HopException {
        String filename = this.variables.resolve(fname);
        this.executorPipelineMeta = new PipelineMeta(filename, this.metadataProvider, true, this.variables);
        this.executorPipelineMeta.clearChanged();
    }

    void loadPipeline() throws HopException {
        String filename = this.wPath.getText();
        if (Utils.isEmpty((CharSequence)filename)) {
            return;
        }
        if (!filename.endsWith(".hpl")) {
            filename = filename + ".hpl";
            this.wPath.setText(filename);
        }
        this.loadPipelineFile(filename);
    }

    public void getData() {
        this.wPath.setText(Const.NVL((String)this.pipelineExecutorMeta.getFilename(), (String)""));
        try {
            List runConfigurations = this.metadataProvider.getSerializer(PipelineRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "pipeline"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            this.wRunConfiguration.setText(Const.NVL((String)this.pipelineExecutorMeta.getRunConfigurationName(), (String)""));
            if (Utils.isEmpty((CharSequence)this.pipelineExecutorMeta.getRunConfigurationName())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.pipelineExecutorMeta.getRunConfigurationName());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting pipeline run configurations", (Throwable)e);
        }
        try {
            Object[] prevTransforms = this.pipelineMeta.getTransformNames();
            Arrays.sort(prevTransforms);
            this.wExecutionResultTarget.setItems((String[])prevTransforms);
            this.wResultFilesTarget.setItems((String[])prevTransforms);
            this.wOutputRowsSource.setItems((String[])prevTransforms);
            String[] inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames();
            this.parameterColumns[1].setComboValues(inputFields);
            this.wGroupField.setItems(inputFields);
        }
        catch (Exception e) {
            this.log.logError("couldn't get previous transform list", (Throwable)e);
        }
        this.wGroupSize.setText(Const.NVL((String)this.pipelineExecutorMeta.getGroupSize(), (String)""));
        this.wGroupTime.setText(Const.NVL((String)this.pipelineExecutorMeta.getGroupTime(), (String)""));
        this.wGroupField.setText(Const.NVL((String)this.pipelineExecutorMeta.getGroupField(), (String)""));
        this.wExecutionResultTarget.setText(this.pipelineExecutorMeta.getExecutionResultTargetTransformMeta() == null ? "" : this.pipelineExecutorMeta.getExecutionResultTargetTransformMeta().getName());
        this.tiExecutionTimeField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionTimeField(), (String)""));
        this.tiExecutionResultField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionResultField(), (String)""));
        this.tiExecutionNrErrorsField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionNrErrorsField(), (String)""));
        this.tiExecutionLinesReadField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesReadField(), (String)""));
        this.tiExecutionLinesWrittenField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesWrittenField(), (String)""));
        this.tiExecutionLinesInputField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesInputField(), (String)""));
        this.tiExecutionLinesOutputField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesOutputField(), (String)""));
        this.tiExecutionLinesRejectedField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesRejectedField(), (String)""));
        this.tiExecutionLinesUpdatedField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesUpdatedField(), (String)""));
        this.tiExecutionLinesDeletedField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLinesDeletedField(), (String)""));
        this.tiExecutionFilesRetrievedField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionFilesRetrievedField(), (String)""));
        this.tiExecutionExitStatusField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionExitStatusField(), (String)""));
        this.tiExecutionLogTextField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLogTextField(), (String)""));
        this.tiExecutionLogChannelIdField.setText(FIELD_NAME, Const.NVL((String)this.pipelineExecutorMeta.getExecutionLogChannelIdField(), (String)""));
        if (this.pipelineExecutorMeta.getExecutorsOutputTransformMeta() != null) {
            this.executorOutputTransform = this.pipelineExecutorMeta.getExecutorsOutputTransformMeta().getName();
        }
        this.wResultFilesTarget.setText(this.pipelineExecutorMeta.getResultFilesTargetTransformMeta() == null ? "" : this.pipelineExecutorMeta.getResultFilesTargetTransformMeta().getName());
        this.wResultFileNameField.setText(Const.NVL((String)this.pipelineExecutorMeta.getResultFilesFileNameField(), (String)""));
        this.wOutputRowsSource.setText(this.pipelineExecutorMeta.getOutputRowsSourceTransformMeta() == null ? "" : this.pipelineExecutorMeta.getOutputRowsSourceTransformMeta().getName());
        for (int i = 0; i < this.pipelineExecutorMeta.getOutputRowsField().length; ++i) {
            TableItem item = new TableItem(this.wOutputFields.table, 0);
            item.setText(1, Const.NVL((String)this.pipelineExecutorMeta.getOutputRowsField()[i], (String)""));
            item.setText(2, ValueMetaFactory.getValueMetaName((int)this.pipelineExecutorMeta.getOutputRowsType()[i]));
            int length = this.pipelineExecutorMeta.getOutputRowsLength()[i];
            item.setText(3, length < 0 ? "" : Integer.toString(length));
            int precision = this.pipelineExecutorMeta.getOutputRowsPrecision()[i];
            item.setText(4, precision < 0 ? "" : Integer.toString(precision));
        }
        this.wOutputFields.removeEmptyRows();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        this.wTabFolder.setSelection(0);
        try {
            this.loadPipeline();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void addParametersTab() {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        this.wGetParameters = new Button(wParametersComposite, 8);
        this.wGetParameters.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.GetParameters", (String[])new String[0]));
        this.props.setLook((Control)this.wGetParameters);
        FormData fdGetParameters = new FormData();
        fdGetParameters.bottom = new FormAttachment(100, 0);
        fdGetParameters.right = new FormAttachment(100, 0);
        this.wGetParameters.setLayoutData((Object)fdGetParameters);
        this.wGetParameters.setSelection(this.pipelineExecutorMeta.getParameters().isInheritingAllVariables());
        this.wGetParameters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineExecutorDialog.this.getParametersFromPipeline(null);
            }
        });
        this.parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.column.Field", (String[])new String[0]), 2, new String[0], false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.column.Input", (String[])new String[0]), 1, false, false)};
        this.parameterColumns[1].setUsingVariables(true);
        PipelineExecutorParameters parameters = this.pipelineExecutorMeta.getParameters();
        this.wPipelineExecutorParameters = new TableView(this.variables, wParametersComposite, 67588, this.parameterColumns, parameters.getVariable().length, false, this.lsMod, this.props, false);
        this.props.setLook((Control)this.wPipelineExecutorParameters);
        FormData fdPipelineExecutors = new FormData();
        fdPipelineExecutors.left = new FormAttachment(0, 0);
        fdPipelineExecutors.right = new FormAttachment(100, 0);
        fdPipelineExecutors.top = new FormAttachment(0, 0);
        fdPipelineExecutors.bottom = new FormAttachment((Control)this.wGetParameters, -10);
        this.wPipelineExecutorParameters.setLayoutData((Object)fdPipelineExecutors);
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = this.wPipelineExecutorParameters.table.getItem(i);
            tableItem.setText(1, Const.NVL((String)parameters.getVariable()[i], (String)""));
            tableItem.setText(2, Const.NVL((String)parameters.getField()[i], (String)""));
            tableItem.setText(3, Const.NVL((String)parameters.getInput()[i], (String)""));
        }
        this.wPipelineExecutorParameters.setRowNums();
        this.wPipelineExecutorParameters.optWidth(true);
        this.wInheritAll = new Button(wParametersComposite, 32);
        this.wInheritAll.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)this.wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.top = new FormAttachment((Control)this.wPipelineExecutorParameters, 15);
        fdInheritAll.left = new FormAttachment(0, 0);
        this.wInheritAll.setLayoutData((Object)fdInheritAll);
        this.wInheritAll.setSelection(this.pipelineExecutorMeta.getParameters().isInheritingAllVariables());
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
    }

    protected void getParametersFromPipeline(PipelineMeta inputPipelineMeta) {
        try {
            if (inputPipelineMeta == null) {
                this.loadPipeline();
                inputPipelineMeta = this.executorPipelineMeta;
            }
            String[] parameters = inputPipelineMeta.listParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String name = parameters[i];
                String desc = inputPipelineMeta.getParameterDescription(name);
                TableItem item = new TableItem(this.wPipelineExecutorParameters.table, 0);
                item.setText(1, Const.NVL((String)name, (String)""));
                String str = inputPipelineMeta.getParameterDefault(name);
                str = str != null ? str : (desc != null ? desc : "");
                item.setText(3, Const.NVL((String)str, (String)""));
            }
            this.wPipelineExecutorParameters.removeEmptyRows();
            this.wPipelineExecutorParameters.setRowNums();
            this.wPipelineExecutorParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Message", (String[])new String[0]), e);
        }
    }

    private void addRowGroupTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.RowGroup.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.RowGroup.Tooltip", (String[])new String[0]));
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlGroupSize = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupSize);
        this.wlGroupSize.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.GroupSize.Label", (String[])new String[0]));
        FormData fdlGroupSize = new FormData();
        fdlGroupSize.top = new FormAttachment(0, 0);
        fdlGroupSize.left = new FormAttachment(0, 0);
        this.wlGroupSize.setLayoutData((Object)fdlGroupSize);
        this.wGroupSize = new TextVar(this.variables, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupSize);
        this.wGroupSize.addModifyListener(this.lsMod);
        FormData fdGroupSize = new FormData();
        fdGroupSize.width = 250;
        fdGroupSize.top = new FormAttachment((Control)this.wlGroupSize, 5);
        fdGroupSize.left = new FormAttachment(0, 0);
        this.wGroupSize.setLayoutData((Object)fdGroupSize);
        this.wlGroupField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupField);
        this.wlGroupField.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.GroupField.Label", (String[])new String[0]));
        FormData fdlGroupField = new FormData();
        fdlGroupField.top = new FormAttachment((Control)this.wGroupSize, 10);
        fdlGroupField.left = new FormAttachment(0, 0);
        this.wlGroupField.setLayoutData((Object)fdlGroupField);
        this.wGroupField = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupField);
        this.wGroupField.addModifyListener(this.lsMod);
        FormData fdGroupField = new FormData();
        fdGroupField.width = 250;
        fdGroupField.top = new FormAttachment((Control)this.wlGroupField, 5);
        fdGroupField.left = new FormAttachment(0, 0);
        this.wGroupField.setLayoutData((Object)fdGroupField);
        this.wlGroupTime = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlGroupTime);
        this.wlGroupTime.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.GroupTime.Label", (String[])new String[0]));
        FormData fdlGroupTime = new FormData();
        fdlGroupTime.top = new FormAttachment((Control)this.wGroupField, 10);
        fdlGroupTime.left = new FormAttachment(0, 0);
        this.wlGroupTime.setLayoutData((Object)fdlGroupTime);
        this.wGroupTime = new TextVar(this.variables, wInputComposite, 18436);
        this.props.setLook((Control)this.wGroupTime);
        this.wGroupTime.addModifyListener(this.lsMod);
        FormData fdGroupTime = new FormData();
        fdGroupTime.width = 250;
        fdGroupTime.top = new FormAttachment((Control)this.wlGroupTime, 5);
        fdGroupTime.left = new FormAttachment(0, 0);
        this.wGroupTime.setLayoutData((Object)fdGroupTime);
        wTab.setControl((Control)wInputComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addExecutionResultTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResults.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResults.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlExecutionResultTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlExecutionResultTarget);
        this.wlExecutionResultTarget.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResultTarget.Label", (String[])new String[0]));
        FormData fdlExecutionResultTarget = new FormData();
        fdlExecutionResultTarget.top = new FormAttachment(0, 0);
        fdlExecutionResultTarget.left = new FormAttachment(0, 0);
        this.wlExecutionResultTarget.setLayoutData((Object)fdlExecutionResultTarget);
        this.wExecutionResultTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wExecutionResultTarget);
        this.wExecutionResultTarget.addModifyListener(this.lsMod);
        FormData fdExecutionResultTarget = new FormData();
        fdExecutionResultTarget.width = 250;
        fdExecutionResultTarget.top = new FormAttachment((Control)this.wlExecutionResultTarget, 5);
        fdExecutionResultTarget.left = new FormAttachment(0, 0);
        this.wExecutionResultTarget.setLayoutData((Object)fdExecutionResultTarget);
        ColumnInfo[] executionResultColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ExecutionResults.FieldDescription.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ExecutionResults.FieldName.Label", (String[])new String[0]), 1, false, false)};
        executionResultColumns[1].setUsingVariables(true);
        TableView wExectionResults = new TableView(this.variables, wInputComposite, 67588, executionResultColumns, 14, false, this.lsMod, this.props, false);
        this.props.setLook((Control)wExectionResults);
        FormData fdExecutionResults = new FormData();
        fdExecutionResults.left = new FormAttachment(0);
        fdExecutionResults.right = new FormAttachment(100);
        fdExecutionResults.top = new FormAttachment((Control)this.wExecutionResultTarget, 10);
        fdExecutionResults.bottom = new FormAttachment(100);
        wExectionResults.setLayoutData((Object)fdExecutionResults);
        wExectionResults.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        int index = 0;
        this.tiExecutionTimeField = wExectionResults.table.getItem(index++);
        this.tiExecutionResultField = wExectionResults.table.getItem(index++);
        this.tiExecutionNrErrorsField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesReadField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesWrittenField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesInputField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesOutputField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesRejectedField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesUpdatedField = wExectionResults.table.getItem(index++);
        this.tiExecutionLinesDeletedField = wExectionResults.table.getItem(index++);
        this.tiExecutionFilesRetrievedField = wExectionResults.table.getItem(index++);
        this.tiExecutionExitStatusField = wExectionResults.table.getItem(index++);
        this.tiExecutionLogTextField = wExectionResults.table.getItem(index++);
        this.tiExecutionLogChannelIdField = wExectionResults.table.getItem(index++);
        this.tiExecutionTimeField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionTimeField.Label", (String[])new String[0]));
        this.tiExecutionResultField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionResultField.Label", (String[])new String[0]));
        this.tiExecutionNrErrorsField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionNrErrorsField.Label", (String[])new String[0]));
        this.tiExecutionLinesReadField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesReadField.Label", (String[])new String[0]));
        this.tiExecutionLinesWrittenField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesWrittenField.Label", (String[])new String[0]));
        this.tiExecutionLinesInputField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesInputField.Label", (String[])new String[0]));
        this.tiExecutionLinesOutputField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesOutputField.Label", (String[])new String[0]));
        this.tiExecutionLinesRejectedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesRejectedField.Label", (String[])new String[0]));
        this.tiExecutionLinesUpdatedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesUpdatedField.Label", (String[])new String[0]));
        this.tiExecutionLinesDeletedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLinesDeletedField.Label", (String[])new String[0]));
        this.tiExecutionFilesRetrievedField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionFilesRetrievedField.Label", (String[])new String[0]));
        this.tiExecutionExitStatusField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionExitStatusField.Label", (String[])new String[0]));
        this.tiExecutionLogTextField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLogTextField.Label", (String[])new String[0]));
        this.tiExecutionLogChannelIdField.setText(FIELD_DESCRIPTION, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ExecutionLogChannelIdField.Label", (String[])new String[0]));
        this.wPipelineExecutorParameters.setRowNums();
        this.wPipelineExecutorParameters.optWidth(true);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultFilesTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFiles.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFiles.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultFilesTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFilesTarget);
        this.wlResultFilesTarget.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFilesTarget.Label", (String[])new String[0]));
        FormData fdlResultFilesTarget = new FormData();
        fdlResultFilesTarget.top = new FormAttachment(0, 0);
        fdlResultFilesTarget.left = new FormAttachment(0, 0);
        this.wlResultFilesTarget.setLayoutData((Object)fdlResultFilesTarget);
        this.wResultFilesTarget = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFilesTarget);
        this.wResultFilesTarget.addModifyListener(this.lsMod);
        FormData fdResultFilesTarget = new FormData();
        fdResultFilesTarget.width = 250;
        fdResultFilesTarget.top = new FormAttachment((Control)this.wlResultFilesTarget, 5);
        fdResultFilesTarget.left = new FormAttachment(0, 0);
        this.wResultFilesTarget.setLayoutData((Object)fdResultFilesTarget);
        this.wlResultFileNameField = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultFileNameField);
        this.wlResultFileNameField.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFileNameField.Label", (String[])new String[0]));
        FormData fdlResultFileNameField = new FormData();
        fdlResultFileNameField.top = new FormAttachment((Control)this.wResultFilesTarget, 10);
        fdlResultFileNameField.left = new FormAttachment(0, 0);
        this.wlResultFileNameField.setLayoutData((Object)fdlResultFileNameField);
        this.wResultFileNameField = new TextVar(this.variables, wInputComposite, 18436);
        this.props.setLook((Control)this.wResultFileNameField);
        this.wResultFileNameField.addModifyListener(this.lsMod);
        FormData fdResultFileNameField = new FormData();
        fdResultFileNameField.width = 250;
        fdResultFileNameField.top = new FormAttachment((Control)this.wlResultFileNameField, 5);
        fdResultFileNameField.left = new FormAttachment(0, 0);
        this.wResultFileNameField.setLayoutData((Object)fdResultFileNameField);
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void addResultRowsTab() {
        CTabItem wTab = new CTabItem(this.wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultRows.Title", (String[])new String[0]));
        wTab.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultRows.Tooltip", (String[])new String[0]));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.wTabFolder, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        Composite wInputComposite = new Composite((Composite)scrolledComposite, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        this.wlResultRowsTarget = new Label(wInputComposite, 131072);
        this.props.setLook((Control)this.wlResultRowsTarget);
        this.wlResultRowsTarget.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.OutputRowsSource.Label", (String[])new String[0]));
        FormData fdlResultRowsTarget = new FormData();
        fdlResultRowsTarget.top = new FormAttachment(0, 0);
        fdlResultRowsTarget.left = new FormAttachment(0, 0);
        this.wlResultRowsTarget.setLayoutData((Object)fdlResultRowsTarget);
        this.wOutputRowsSource = new CCombo(wInputComposite, 18436);
        this.props.setLook((Control)this.wOutputRowsSource);
        this.wOutputRowsSource.addModifyListener(this.lsMod);
        FormData fdResultRowsTarget = new FormData();
        fdResultRowsTarget.width = 250;
        fdResultRowsTarget.top = new FormAttachment((Control)this.wlResultRowsTarget, 5);
        fdResultRowsTarget.left = new FormAttachment(0, 0);
        this.wOutputRowsSource.setLayoutData((Object)fdResultRowsTarget);
        this.wlOutputFields = new Label(wInputComposite, 0);
        this.wlOutputFields.setText(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ResultFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutputFields);
        FormData fdlResultFields = new FormData();
        fdlResultFields.left = new FormAttachment(0, 0);
        fdlResultFields.top = new FormAttachment((Control)this.wOutputRowsSource, 10);
        this.wlOutputFields.setLayoutData((Object)fdlResultFields);
        int nrRows = this.pipelineExecutorMeta.getOutputRowsField() != null ? this.pipelineExecutorMeta.getOutputRowsField().length : 1;
        ColumnInfo[] ciResultFields = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Field", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wOutputFields = new TableView(this.variables, wInputComposite, 68354, ciResultFields, nrRows, false, this.lsMod, this.props, false);
        FormData fdResultFields = new FormData();
        fdResultFields.left = new FormAttachment(0, 0);
        fdResultFields.top = new FormAttachment((Control)this.wlOutputFields, 5);
        fdResultFields.right = new FormAttachment(100, 0);
        fdResultFields.bottom = new FormAttachment(100, 0);
        this.wOutputFields.setLayoutData((Object)fdResultFields);
        this.wOutputFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 25, 25, 25, 25}));
        wInputComposite.pack();
        Rectangle bounds = wInputComposite.getBounds();
        scrolledComposite.setContent((Control)wInputComposite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinWidth(bounds.width);
        scrolledComposite.setMinHeight(bounds.height);
        wTab.setControl((Control)scrolledComposite);
        this.wTabFolder.setSelection(wTab);
    }

    private void setFlags() {
        if (this.wlGroupSize == null || this.wlGroupSize == null || this.wlGroupField == null || this.wGroupField == null || this.wlGroupTime == null || this.wGroupTime == null) {
            return;
        }
        boolean enableSize = Const.toInt((String)this.variables.resolve(this.wGroupSize.getText()), (int)-1) >= 0;
        boolean enableField = !Utils.isEmpty((CharSequence)this.wGroupField.getText());
        this.wlGroupSize.setEnabled(true);
        this.wGroupSize.setEnabled(true);
        this.wlGroupField.setEnabled(!enableSize);
        this.wGroupField.setEnabled(!enableSize);
        this.wlGroupTime.setEnabled(!enableSize && !enableField);
        this.wGroupTime.setEnabled(!enableSize && !enableField);
    }

    private void cancel() {
        this.transformName = null;
        this.pipelineExecutorMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        try {
            this.loadPipeline();
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineExecutorDialog.ErrorLoadingSpecifiedPipeline.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.pipelineExecutorMeta.setFilename(this.wPath.getText());
        this.pipelineExecutorMeta.setRunConfigurationName(this.wRunConfiguration.getText());
        this.collectInformation();
        this.pipelineExecutorMeta.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
        this.pipelineExecutorMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        PipelineExecutorParameters parameters = this.pipelineExecutorMeta.getParameters();
        int nrLines = this.wPipelineExecutorParameters.nrNonEmpty();
        String[] variables = new String[nrLines];
        String[] fields = new String[nrLines];
        String[] input = new String[nrLines];
        parameters.setVariable(variables);
        parameters.setField(fields);
        parameters.setInput(input);
        for (int i = 0; i < nrLines; ++i) {
            TableItem item = this.wPipelineExecutorParameters.getNonEmpty(i);
            variables[i] = item.getText(1);
            fields[i] = item.getText(2);
            input[i] = item.getText(3);
        }
        parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        this.pipelineExecutorMeta.setGroupSize(this.wGroupSize.getText());
        this.pipelineExecutorMeta.setGroupField(this.wGroupField.getText());
        this.pipelineExecutorMeta.setGroupTime(this.wGroupTime.getText());
        this.pipelineExecutorMeta.setExecutionResultTargetTransform(this.wExecutionResultTarget.getText());
        this.pipelineExecutorMeta.setExecutionResultTargetTransformMeta(this.pipelineMeta.findTransform(this.wExecutionResultTarget.getText()));
        this.pipelineExecutorMeta.setExecutionTimeField(this.tiExecutionTimeField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionResultField(this.tiExecutionResultField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionNrErrorsField(this.tiExecutionNrErrorsField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLinesReadField(this.tiExecutionLinesReadField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLinesWrittenField(this.tiExecutionLinesWrittenField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLinesInputField(this.tiExecutionLinesInputField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLinesOutputField(this.tiExecutionLinesOutputField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLinesRejectedField(this.tiExecutionLinesRejectedField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLinesUpdatedField(this.tiExecutionLinesUpdatedField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLinesDeletedField(this.tiExecutionLinesDeletedField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionFilesRetrievedField(this.tiExecutionFilesRetrievedField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionExitStatusField(this.tiExecutionExitStatusField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLogTextField(this.tiExecutionLogTextField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setExecutionLogChannelIdField(this.tiExecutionLogChannelIdField.getText(FIELD_NAME));
        this.pipelineExecutorMeta.setResultFilesTargetTransform(this.wResultFilesTarget.getText());
        this.pipelineExecutorMeta.setResultFilesTargetTransformMeta(this.pipelineMeta.findTransform(this.wResultFilesTarget.getText()));
        this.pipelineExecutorMeta.setResultFilesFileNameField(this.wResultFileNameField.getText());
        if (!Utils.isEmpty((CharSequence)this.executorOutputTransform)) {
            this.pipelineExecutorMeta.setExecutorsOutputTransform(this.executorOutputTransform);
            this.pipelineExecutorMeta.setExecutorsOutputTransformMeta(this.pipelineMeta.findTransform(this.executorOutputTransform));
        }
        this.pipelineExecutorMeta.setOutputRowsSourceTransform(this.wOutputRowsSource.getText());
        this.pipelineExecutorMeta.setOutputRowsSourceTransformMeta(this.pipelineMeta.findTransform(this.wOutputRowsSource.getText()));
        int nrFields = this.wOutputFields.nrNonEmpty();
        this.pipelineExecutorMeta.setOutputRowsField(new String[nrFields]);
        this.pipelineExecutorMeta.setOutputRowsType(new int[nrFields]);
        this.pipelineExecutorMeta.setOutputRowsLength(new int[nrFields]);
        this.pipelineExecutorMeta.setOutputRowsPrecision(new int[nrFields]);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wOutputFields.getNonEmpty(i);
            this.pipelineExecutorMeta.getOutputRowsField()[i] = item.getText(1);
            this.pipelineExecutorMeta.getOutputRowsType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            this.pipelineExecutorMeta.getOutputRowsLength()[i] = Const.toInt((String)item.getText(3), (int)-1);
            this.pipelineExecutorMeta.getOutputRowsPrecision()[i] = Const.toInt((String)item.getText(4), (int)-1);
        }
    }
}

