/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cache;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="CACHE", typeDescription="Intersystems Cache")
@GuiPlugin(id="GUI-CacheDatabaseMeta")
public class CacheDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1972;
        }
        return -1;
    }

    public boolean supportsSetCharacterStream() {
        return false;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public String getDriverClass() {
        return "com.intersys.jdbc.CacheDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:Cache://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD COLUMN ( " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk)) {
                    retval = retval + "DECIMAL";
                    break;
                }
                if (length < 0 || precision < 0) {
                    retval = retval + "DOUBLE";
                    break;
                }
                if (precision > 0 || length > 9) {
                    retval = retval + "DECIMAL(" + length;
                    if (precision > 0) {
                        retval = retval + ", " + precision;
                    }
                    retval = retval + ")";
                    break;
                }
                retval = retval + "INT";
                break;
            }
            case 2: {
                retval = retval + "VARCHAR";
                if (length <= 0) break;
                retval = retval + "(" + length + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public boolean requiresCreateTablePrimaryKeyAppend() {
        return true;
    }

    public boolean supportsNewLinesInSql() {
        return false;
    }
}

