/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package hivemall.tools.array;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF.DeferredObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class ToStringArrayUDFTest {

    @Test
    public void testTextArrayInput() throws HiveException, IOException {
        List<String> input = new ArrayList<String>(2);
        input.add("1");
        input.add("2");

        ToStringArrayUDF udf = new ToStringArrayUDF();
        udf.initialize(new ObjectInspector[] {ObjectInspectorFactory.getStandardListObjectInspector(
            PrimitiveObjectInspectorFactory.javaStringObjectInspector)});

        DeferredObject[] args = new DeferredObject[] {new GenericUDF.DeferredJavaObject(input)};
        List<String> output = udf.evaluate(args);

        Assert.assertEquals(input, output);

        udf.close();
    }

    @Test
    public void testTextArrayInputWithNullValue() throws HiveException, IOException {
        List<String> input = new ArrayList<String>(2);
        input.add("1");
        input.add(null);
        input.add("2");

        ToStringArrayUDF udf = new ToStringArrayUDF();
        udf.initialize(new ObjectInspector[] {ObjectInspectorFactory.getStandardListObjectInspector(
            PrimitiveObjectInspectorFactory.javaStringObjectInspector)});

        DeferredObject[] args = new DeferredObject[] {new GenericUDF.DeferredJavaObject(input)};
        List<String> output = udf.evaluate(args);

        Assert.assertEquals(input, output);

        udf.close();
    }

}
