/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.TrackedInputStream;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;

public abstract class AbstractResource
implements WebResource {
    protected static final StringManager sm = StringManager.getManager(AbstractResource.class);
    private final WebResourceRoot root;
    private final String webAppPath;
    private String mimeType = null;
    private volatile String weakETag;
    private volatile String strongETag;

    protected AbstractResource(WebResourceRoot root, String webAppPath) {
        this.root = root;
        this.webAppPath = webAppPath;
    }

    @Override
    public final WebResourceRoot getWebResourceRoot() {
        return this.root;
    }

    @Override
    public final String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public final String getLastModifiedHttp() {
        return FastHttpDateFormat.formatDate(this.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getETag() {
        if (this.weakETag == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.weakETag == null) {
                    long contentLength = this.getContentLength();
                    long lastModified = this.getLastModified();
                    if (contentLength >= 0L || lastModified >= 0L) {
                        this.weakETag = "W/\"" + contentLength + "-" + lastModified + "\"";
                    }
                }
            }
        }
        return this.weakETag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getStrongETag() {
        if (this.strongETag == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.strongETag == null) {
                    long contentLength = this.getContentLength();
                    long lastModified = this.getLastModified();
                    if (contentLength > 0L && lastModified > 0L) {
                        if (contentLength <= 16384L) {
                            byte[] buf = this.getContent();
                            if (buf != null) {
                                buf = ConcurrentMessageDigest.digest("SHA-1", new byte[][]{buf});
                                this.strongETag = "\"" + HexUtils.toHexString(buf) + "\"";
                            } else {
                                this.strongETag = this.getETag();
                            }
                        } else {
                            byte[] buf = new byte[4096];
                            try (InputStream is = this.getInputStream();){
                                int n;
                                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                                while ((n = is.read(buf)) > 0) {
                                    digest.update(buf, 0, n);
                                }
                                this.strongETag = "\"" + HexUtils.toHexString(digest.digest()) + "\"";
                            }
                            catch (Exception e) {
                                this.strongETag = this.getETag();
                            }
                        }
                    } else {
                        this.strongETag = this.getETag();
                    }
                }
            }
        }
        return this.strongETag;
    }

    @Override
    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public final String getMimeType() {
        return this.mimeType;
    }

    @Override
    public final InputStream getInputStream() {
        InputStream is = this.doGetInputStream();
        if (is == null || !this.root.getTrackLockedFiles()) {
            return is;
        }
        return new TrackedInputStream(this.root, this.getName(), is);
    }

    protected abstract InputStream doGetInputStream();

    protected abstract Log getLog();
}

