/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.convert.DB2J;
import dm.jdbc.desc.StructDescriptor;
import dm.jdbc.desc.TypeData;
import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.StringUtil;
import java.sql.Struct;
import java.util.Map;

public class DmdbStruct
extends TypeData
implements Struct {
    public StructDescriptor m_strctDesc;
    public TypeData[] m_attribs;
    public int m_objCount;
    public int m_strCount;

    public DmdbStruct(TypeData[] typeDataArray, TypeDescriptor typeDescriptor) {
        super(null, null);
        this.m_strctDesc = new StructDescriptor(typeDescriptor);
        this.m_attribs = typeDataArray;
    }

    public TypeData[] getAttribsTypeData() {
        return this.m_attribs;
    }

    public DmdbStruct(StructDescriptor structDescriptor, DmdbConnection dmdbConnection, Object[] objectArray) {
        super(null, null);
        if (structDescriptor == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        dmdbConnection.checkClosed();
        this.m_strctDesc = structDescriptor;
        if (objectArray == null) {
            this.m_attribs = new TypeData[structDescriptor.getSize()];
        } else {
            if (structDescriptor.getSize() != objectArray.length && structDescriptor.getObjId() != 4) {
                DBError.ECJDBC_STRUCT_MEM_NOT_MATCH.throwz(new Object[0]);
            }
            this.m_attribs = TypeData.toStruct(objectArray, this.m_strctDesc.m_typeDesc);
        }
    }

    @Override
    public String getSQLTypeName() {
        return this.m_strctDesc.m_typeDesc.getFulName();
    }

    @Override
    public Object[] getAttributes() {
        return this.toJavaArray(this);
    }

    public Object[] getAttributes(Map map) {
        Object[] objectArray = this.getAttributes();
        if (map == null || map.size() == 0) {
            return objectArray;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof Struct) {
                Struct struct = (Struct)objectArray[n2];
                objectArray[n2] = DB2J.toSQLData(struct, map);
            }
            ++n2;
        }
        return objectArray;
    }

    private void checkCol(int n2) {
        if (n2 < 1 || n2 > this.m_attribs.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
    }

    TypeData getAttrValue(int n2) {
        this.checkCol(n2);
        return this.m_attribs[n2 - 1];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.getSQLTypeName()).append("(");
            int n2 = 0;
            while (n2 < this.m_attribs.length) {
                Object object = this.m_attribs[n2].m_dumyData;
                if (object instanceof byte[]) {
                    object = "0x" + StringUtil.bytesToHexString((byte[])object);
                }
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
                ++n2;
            }
            stringBuilder.append(")");
        }
        catch (Exception exception) {}
        return stringBuilder.toString();
    }
}

