/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Configuration;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DmProperties
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map innerProps = new HashMap();

    public DmProperties() {
    }

    public DmProperties(DmProperties dmProperties) {
        this();
        this.setProperties(dmProperties.innerProps);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.innerProps != null) {
            for (Map.Entry entry : this.innerProps.entrySet()) {
                if (entry == null) continue;
                properties.put(entry.getKey().toString().toLowerCase(), entry.getValue());
            }
        }
        return properties;
    }

    public int size() {
        return this.innerProps.size();
    }

    public void setProperties(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry == null) continue;
                this.innerProps.put(entry.getKey().toString().toLowerCase(), entry.getValue());
            }
        }
    }

    public void setProperties(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (entry == null) continue;
                this.innerProps.put(entry.getKey().toString().toLowerCase(), entry.getValue());
            }
        }
    }

    public void setNonExistProperties(DmProperties dmProperties) {
        if (dmProperties != null) {
            this.setNonExistProperties(dmProperties.innerProps);
        }
    }

    public void setNonExistProperties(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = entry.getKey().toString().toLowerCase();
                if (this.innerProps.containsKey(string)) continue;
                this.innerProps.put(string, entry.getValue());
            }
        }
    }

    public void setNonExistProperties(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String string = entry.getKey().toString().toLowerCase();
                if (this.innerProps.containsKey(string)) continue;
                this.innerProps.put(string, entry.getValue());
            }
        }
    }

    public Object setNonExistProperty(String string, String string2) {
        if (!this.innerProps.containsKey(string.toLowerCase())) {
            return this.innerProps.put(string.toLowerCase(), string2);
        }
        return this.innerProps.get(string.toLowerCase());
    }

    public Object setProperty(String string, String string2) {
        return this.innerProps.put(string.toLowerCase(), string2);
    }

    public String getProperty(String string) {
        Object v2 = this.innerProps.get(string.toLowerCase());
        return v2 != null ? v2.toString() : null;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return StringUtil.isEmpty(string3) ? string2 : string3;
    }

    public Set entrySet() {
        return this.innerProps.entrySet();
    }

    public Object setObject(String string, Object object) {
        return this.innerProps.put(string.toLowerCase(), object);
    }

    public Object getObject(String string) {
        return this.innerProps.get(string.toLowerCase());
    }

    public boolean contains(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        return StringUtil.isNotEmpty(string);
    }

    public boolean getBoolean(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        return StringUtil.isEmpty(string) ? (Boolean)configuration.getDefault() : ConvertUtil.toBoolean(string);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string);
        return StringUtil.isEmpty(string2) ? bl : ConvertUtil.toBoolean(string2);
    }

    public int getInt(String string, int n2) {
        String string2 = this.getProperty(string);
        if (StringUtil.isEmpty(string2)) {
            return n2;
        }
        try {
            int n3 = StringUtil.isInteger(string2) ? Integer.valueOf(string2) : (Boolean.valueOf(string2) != false ? 1 : 0);
            return n3;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public int getInt(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        if (StringUtil.isEmpty(string)) {
            return (Integer)configuration.getDefault();
        }
        try {
            int n2 = StringUtil.isInteger(string) ? Integer.valueOf(string) : (Boolean.valueOf(string) != false ? 1 : 0);
            return this.getIntInner(configuration, n2);
        }
        catch (Exception exception) {
            return (Integer)configuration.getDefault();
        }
    }

    protected int getIntInner(Configuration configuration, int n2) {
        if (configuration.getMax() != null && n2 > (Integer)configuration.getMax()) {
            return (Integer)configuration.getDefault();
        }
        if (configuration.getMin() != null && n2 < (Integer)configuration.getMin()) {
            return (Integer)configuration.getDefault();
        }
        if (configuration.getValidValues() != null) {
            Integer[] integerArray = (Integer[])configuration.getValidValues();
            int n3 = integerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Integer n5 = integerArray[n4];
                if (n2 == n5) {
                    return n2;
                }
                ++n4;
            }
            return (Integer)configuration.getDefault();
        }
        return n2;
    }

    public long getLong(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        if (StringUtil.isEmpty(string)) {
            return (Long)configuration.getDefault();
        }
        try {
            long l2 = StringUtil.isLong(string) ? Long.valueOf(string) : (long)(Boolean.valueOf(string) != false ? 1 : 0);
            return this.getLongInner(configuration, l2);
        }
        catch (Exception exception) {
            return (Long)configuration.getDefault();
        }
    }

    protected long getLongInner(Configuration configuration, long l2) {
        if (configuration.getMax() != null && l2 > (Long)configuration.getMax()) {
            return (Long)configuration.getDefault();
        }
        if (configuration.getMin() != null && l2 < (Long)configuration.getMin()) {
            return (Long)configuration.getDefault();
        }
        if (configuration.getValidValues() != null) {
            Long[] longArray = (Long[])configuration.getValidValues();
            int n2 = longArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Long l3 = longArray[n3];
                if (l2 == l3) {
                    return l2;
                }
                ++n3;
            }
            return (Long)configuration.getDefault();
        }
        return l2;
    }

    public String getString(String string, String string2) {
        String string3 = this.getProperty(string);
        if (StringUtil.isEmpty(string3)) {
            return string2;
        }
        return string3;
    }

    public String getString(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        if (StringUtil.isEmpty(string)) {
            return (String)configuration.getDefault();
        }
        return string;
    }

    public String getTrimString(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        if (StringUtil.isEmpty(string)) {
            return (String)configuration.getDefault();
        }
        return StringUtil.trimToEmpty(string);
    }

    public String[] getStringArray(Configuration configuration) {
        String[] stringArray;
        String string = this.getProperty(configuration.getName());
        if (string != null && (stringArray = string.split(",")).length > 0) {
            return stringArray;
        }
        return (String[])configuration.getDefault();
    }

    public int getMilliSecond(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        if (StringUtil.isEmpty(string)) {
            return (Integer)configuration.getDefault();
        }
        string = string.toLowerCase();
        int n2 = 1;
        if (string.endsWith("h")) {
            string = string.substring(0, string.length() - 1);
            n2 = 3600000;
        } else if (string.endsWith("m")) {
            string = string.substring(0, string.length() - 1);
            n2 = 60000;
        } else if (string.endsWith("ms")) {
            string = string.substring(0, string.length() - 2);
            n2 = 1;
        } else if (string.endsWith("s")) {
            string = string.substring(0, string.length() - 1);
            n2 = 1000;
        } else {
            return this.getInt(configuration);
        }
        try {
            string = StringUtil.trimToEmpty(string);
            if (StringUtil.isEmpty(string)) {
                return (Integer)configuration.getDefault();
            }
            int n3 = StringUtil.isInteger(string) ? Integer.valueOf(string) : (Boolean.valueOf(string) != false ? 1 : 0);
            return this.getIntInner(configuration, n3 *= n2);
        }
        catch (Exception exception) {
            return (Integer)configuration.getDefault();
        }
    }

    public int getSecond(Configuration configuration) {
        String string = this.getProperty(configuration.getName());
        if (StringUtil.isEmpty(string)) {
            return (Integer)configuration.getDefault();
        }
        string = string.toLowerCase();
        double d2 = 1.0;
        if (string.endsWith("h")) {
            string = string.substring(0, string.length() - 1);
            d2 = 3600.0;
        } else if (string.endsWith("m")) {
            string = string.substring(0, string.length() - 1);
            d2 = 60.0;
        } else if (string.endsWith("ms")) {
            string = string.substring(0, string.length() - 2);
            d2 = 0.001;
        } else if (string.endsWith("s")) {
            string = string.substring(0, string.length() - 1);
            d2 = 1.0;
        } else {
            return this.getInt(configuration);
        }
        try {
            string = StringUtil.trimToEmpty(string);
            if (StringUtil.isEmpty(string)) {
                return (Integer)configuration.getDefault();
            }
            int n2 = StringUtil.isInteger(string) ? Integer.valueOf(string) : (Boolean.valueOf(string) != false ? 1 : 0);
            n2 = (int)((double)n2 * d2);
            return this.getIntInner(configuration, n2);
        }
        catch (Exception exception) {
            return (Integer)configuration.getDefault();
        }
    }

    public Object clone() {
        DmProperties dmProperties = new DmProperties();
        dmProperties.setProperties(this.innerProps);
        return dmProperties;
    }

    public String toString() {
        String string = this.innerProps.toString();
        int n2 = string.indexOf("password=");
        if (n2 != -1) {
            int n3 = string.indexOf(",", n2);
            string = String.valueOf(string.substring(0, n2)) + string.substring(n3);
        }
        return string;
    }
}

