/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.prometheus.parser;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.collector.collect.prometheus.parser.MetricFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineParser {
    private static final Logger log = LoggerFactory.getLogger(OnlineParser.class);

    private static CharChecker parseOneChar(InputStream inputStream) throws IOException {
        int i = inputStream.read();
        return new CharChecker(i);
    }

    private static CharChecker parseOneDouble(InputStream inputStream, StringBuilder stringBuilder) throws IOException {
        int i = inputStream.read();
        while (i >= 48 && i <= 57 || i >= 97 && i <= 122 || i >= 65 && i <= 90 || i == 45 || i == 43 || i == 101 || i == 46) {
            stringBuilder.append((char)i);
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static CharChecker skipOneLong(InputStream inputStream) throws IOException {
        int i = inputStream.read();
        while (i >= 48 && i <= 57) {
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static CharChecker parseMetricName(InputStream inputStream, StringBuilder stringBuilder) throws IOException {
        int i = inputStream.read();
        while (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 95 || i == 58) {
            stringBuilder.append((char)i);
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static CharChecker parseLabelName(InputStream inputStream, StringBuilder stringBuilder) throws IOException {
        int i = inputStream.read();
        while (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 95) {
            stringBuilder.append((char)i);
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static CharChecker parseLabelValue(InputStream inputStream, StringBuilder stringBuilder) throws IOException, FormatException {
        int i = inputStream.read();
        while (i != 34 && i != -1) {
            block7: {
                block6: {
                    if (i != 92) break block6;
                    i = inputStream.read();
                    switch (i) {
                        case 110: {
                            stringBuilder.append('\n');
                            break block7;
                        }
                        case 92: {
                            stringBuilder.append('\\');
                            break block7;
                        }
                        case 34: {
                            stringBuilder.append('\"');
                            break block7;
                        }
                        default: {
                            throw new FormatException();
                        }
                    }
                }
                stringBuilder.append((char)i);
            }
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static CharChecker skipSpaces(InputStream inputStream) throws IOException {
        int i = inputStream.read();
        while (i == 32) {
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static CharChecker skipToLineEnd(InputStream inputStream) throws IOException {
        int i = inputStream.read();
        while (i != 10 && i != -1) {
            i = inputStream.read();
        }
        return new CharChecker(i);
    }

    private static Double toDouble(String string) throws FormatException {
        switch (string) {
            case "+Inf": {
                return Double.POSITIVE_INFINITY;
            }
            case "-Inf": {
                return Double.NEGATIVE_INFINITY;
            }
            case "NaN": {
                return Double.NaN;
            }
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            return bigDecimal.doubleValue();
        }
        catch (NumberFormatException e) {
            throw new FormatException();
        }
    }

    private static CharChecker parseLabels(InputStream inputStream, StringBuilder stringBuilder, List<MetricFamily.Label> labelList) throws IOException, FormatException {
        int i;
        do {
            MetricFamily.Label label = new MetricFamily.Label();
            i = OnlineParser.skipSpaces(inputStream).getInt();
            stringBuilder.append((char)i);
            i = OnlineParser.parseLabelName(inputStream, stringBuilder).maybeSpace().maybeEqualsSign().noElse();
            label.setName(stringBuilder.toString());
            stringBuilder.delete(0, stringBuilder.length());
            if (i == 32) {
                OnlineParser.skipSpaces(inputStream).maybeEqualsSign().noElse();
            }
            OnlineParser.skipSpaces(inputStream).maybeQuotationMark().noElse();
            OnlineParser.parseLabelValue(inputStream, stringBuilder).maybeQuotationMark().noElse();
            String labelValue = stringBuilder.toString();
            if (!labelValue.equals(new String(labelValue.getBytes(StandardCharsets.UTF_8)))) {
                throw new FormatException();
            }
            label.setValue(labelValue);
            stringBuilder.delete(0, stringBuilder.length());
            i = OnlineParser.skipSpaces(inputStream).maybeSpace().maybeComma().maybeRightBracket().noElse();
            labelList.add(label);
        } while (i != 125);
        return new CharChecker(i);
    }

    private static CharChecker parseMetric(InputStream inputStream, Map<String, MetricFamily> metricFamilyMap, StringBuilder stringBuilder) throws IOException, FormatException {
        MetricFamily metricFamily = null;
        MetricFamily.Metric metric = new MetricFamily.Metric();
        int i = OnlineParser.parseMetricName(inputStream, stringBuilder).maybeSpace().maybeLeftBracket().noElse();
        String metricName = stringBuilder.toString();
        stringBuilder.delete(0, stringBuilder.length());
        if (!metricFamilyMap.containsKey(metricName)) {
            metricFamily = new MetricFamily();
            metricFamily.setMetricList(new ArrayList<MetricFamily.Metric>());
            metricFamily.setName(metricName);
            metricFamilyMap.put(metricName, metricFamily);
        } else {
            metricFamily = metricFamilyMap.get(metricName);
        }
        if (i == 32) {
            i = OnlineParser.skipSpaces(inputStream).getInt();
        }
        if (i == 123) {
            LinkedList<MetricFamily.Label> labelList = new LinkedList<MetricFamily.Label>();
            OnlineParser.parseLabels(inputStream, stringBuilder, labelList);
            metric.setLabels(labelList);
            i = OnlineParser.skipSpaces(inputStream).getInt();
        }
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append((char)i);
        i = OnlineParser.parseOneDouble(inputStream, stringBuilder).maybeSpace().maybeEol().maybeEof().noElse();
        metric.setValue(OnlineParser.toDouble(stringBuilder.toString()));
        if (i == 10 || i == -1) {
            metricFamily.getMetricList().add(metric);
            return new CharChecker(i);
        }
        i = OnlineParser.skipSpaces(inputStream).getInt();
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append((char)i);
        i = OnlineParser.skipOneLong(inputStream).maybeSpace().maybeEol().maybeEof().noElse();
        if (i == 10 || i == -1) {
            metricFamily.getMetricList().add(metric);
            return new CharChecker(i);
        }
        i = OnlineParser.skipSpaces(inputStream).maybeEol().maybeEof().noElse();
        metricFamily.getMetricList().add(metric);
        return new CharChecker(i);
    }

    public static Map<String, MetricFamily> parseMetrics(InputStream inputStream) throws IOException {
        ConcurrentHashMap<String, MetricFamily> metricFamilyMap = new ConcurrentHashMap<String, MetricFamily>(10);
        int i = inputStream.read();
        try {
            while (i != -1) {
                if (i == 35 || i == 10) {
                    OnlineParser.skipToLineEnd(inputStream).maybeEol().maybeEof().noElse();
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((char)i);
                    OnlineParser.parseMetric(inputStream, metricFamilyMap, stringBuilder);
                }
                i = inputStream.read();
            }
        }
        catch (FormatException e) {
            log.error("prometheus parser failed because of wrong input format. {}", (Object)e.getMessage());
            return null;
        }
        return metricFamilyMap;
    }

    private static class CharChecker {
        int i;
        boolean satisfied;

        CharChecker(int i) {
            this.i = i;
            this.satisfied = false;
        }

        private CharChecker maybeLeftBracket() {
            if (this.i == 123) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeRightBracket() {
            if (this.i == 125) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeEqualsSign() {
            if (this.i == 61) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeQuotationMark() {
            if (this.i == 34) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeSpace() {
            if (this.i == 32) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeComma() {
            if (this.i == 44) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeEof() {
            if (this.i == -1) {
                this.satisfied = true;
            }
            return this;
        }

        private CharChecker maybeEol() {
            if (this.i == 10) {
                this.satisfied = true;
            }
            return this;
        }

        private int noElse() throws FormatException {
            if (!this.satisfied) {
                throw new FormatException();
            }
            return this.i;
        }

        private int getInt() throws FormatException {
            return this.i;
        }
    }

    private static class FormatException
    extends Exception {
        public FormatException() {
        }

        public FormatException(String message) {
            super(message);
        }
    }
}

