/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.collect.http.promethus.AbstractPrometheusParse;
import org.apache.hertzbeat.collector.collect.http.promethus.PrometheusParseCreator;
import org.apache.hertzbeat.collector.collect.http.promethus.exporter.ExporterParser;
import org.apache.hertzbeat.collector.collect.http.promethus.exporter.MetricFamily;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.collector.util.JsonPathParser;
import org.apache.hertzbeat.collector.util.TimeExpressionUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.HttpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HttpCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(HttpCollectImpl.class);
    private static final Map<Long, ExporterParser> EXPORTER_PARSER_TABLE = new ConcurrentHashMap<Long, ExporterParser>();
    private final Set<Integer> defaultSuccessStatusCodes = Stream.of(200, 201, 202, 300, 301, 302).collect(Collectors.toSet());

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getHttp() == null) {
            throw new IllegalArgumentException("Http/Https collect must has http params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        HttpProtocol httpProtocol = metrics.getHttp();
        String url = httpProtocol.getUrl();
        if (!StringUtils.hasText((String)url) || !url.startsWith("/")) {
            httpProtocol.setUrl((String)(StringUtils.hasText((String)url) ? "/" + url.trim() : "/"));
        }
        if (CollectionUtils.isEmpty((Collection)httpProtocol.getSuccessCodes())) {
            httpProtocol.setSuccessCodes(List.of("200"));
        }
        HttpContext httpContext = this.createHttpContext(metrics.getHttp());
        HttpUriRequest request = this.createHttpRequest(metrics.getHttp());
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, httpContext);){
            int statusCode = response.getStatusLine().getStatusCode();
            boolean isSuccessInvoke = this.checkSuccessInvoke(metrics, statusCode);
            log.debug("http response status: {}", (Object)statusCode);
            if (!isSuccessInvoke) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("StatusCode " + statusCode);
                return;
            }
            String resp = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (!StringUtils.hasText((String)resp)) {
                log.info("http response entity is empty, status: {}.", (Object)statusCode);
            }
            Long responseTime = System.currentTimeMillis() - startTime;
            String parseType = metrics.getHttp().getParseType();
            try {
                switch (parseType) {
                    case "jsonPath": {
                        this.parseResponseByJsonPath(resp, metrics.getAliasFields(), metrics.getHttp(), builder, responseTime);
                        break;
                    }
                    case "PromQL": {
                        this.parseResponseByPromQl(resp, metrics.getAliasFields(), metrics.getHttp(), builder);
                        break;
                    }
                    case "prometheus": {
                        this.parseResponseByPrometheusExporter(resp, metrics.getAliasFields(), builder);
                        break;
                    }
                    case "xmlPath": {
                        this.parseResponseByXmlPath(resp, metrics.getAliasFields(), metrics.getHttp(), builder);
                        break;
                    }
                    case "website": {
                        this.parseResponseByWebsite(resp, metrics, metrics.getHttp(), builder, responseTime);
                        break;
                    }
                    case "sitemap": {
                        this.parseResponseBySiteMap(resp, metrics.getAliasFields(), builder);
                        break;
                    }
                    case "header": {
                        this.parseResponseByHeader(builder, metrics.getAliasFields(), response);
                        break;
                    }
                    default: {
                        this.parseResponseByDefault(resp, metrics.getAliasFields(), metrics.getHttp(), builder, responseTime);
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.info("parse error: {}.", (Object)e.getMessage(), (Object)e);
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("parse response data error:" + e.getMessage());
            }
        }
        catch (ClientProtocolException e1) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e1);
            log.error(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (UnknownHostException e2) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e2);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_REACHABLE);
            builder.setMsg("unknown host:" + errorMsg);
        }
        catch (InterruptedIOException | ConnectException | SSLException e3) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e3);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (IOException e4) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e4);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error(errorMsg, (Throwable)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (request != null) {
                request.abort();
            }
        }
    }

    private void parseResponseByHeader(CollectRep.MetricsData.Builder builder, List<String> aliases, CloseableHttpResponse response) {
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String alias : aliases) {
            if (!StringUtils.hasText((String)alias)) {
                valueRowBuilder.addColumn("&nbsp;");
                continue;
            }
            Header firstHeader = response.getFirstHeader(alias);
            if (Objects.isNull(firstHeader)) {
                valueRowBuilder.addColumn("&nbsp;");
                continue;
            }
            valueRowBuilder.addColumn(firstHeader.getValue());
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    public String supportProtocol() {
        return "http";
    }

    private void parseResponseByWebsite(String resp, Metrics metrics, HttpProtocol http, CollectRep.MetricsData.Builder builder, Long responseTime) {
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        int keywordNum = CollectUtil.countMatchKeyword((String)resp, (String)http.getKeyword());
        for (String alias : metrics.getAliasFields()) {
            this.addColumnForSummary(responseTime, valueRowBuilder, keywordNum, alias);
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    private void addColumnForSummary(Long responseTime, CollectRep.ValueRow.Builder valueRowBuilder, int keywordNum, String alias) {
        if ("responseTime".equalsIgnoreCase(alias)) {
            valueRowBuilder.addColumn(responseTime.toString());
        } else if ("keyword".equalsIgnoreCase(alias)) {
            valueRowBuilder.addColumn(Integer.toString(keywordNum));
        } else {
            valueRowBuilder.addColumn("&nbsp;");
        }
    }

    private void parseResponseBySiteMap(String resp, List<String> aliasFields, CollectRep.MetricsData.Builder builder) {
        LinkedList<String> siteUrls = new LinkedList<String>();
        boolean isXmlFormat = true;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setXIncludeAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new InputSource(new StringReader(resp)));
            NodeList urlList = document.getElementsByTagName("url");
            block15: for (int i = 0; i < urlList.getLength(); ++i) {
                Node urlNode = urlList.item(i);
                NodeList childNodes = urlNode.getChildNodes();
                for (int k = 0; k < childNodes.getLength(); ++k) {
                    Node currentNode = childNodes.item(k);
                    if (currentNode.getNodeType() != 1 || !"loc".equals(currentNode.getNodeName())) continue;
                    siteUrls.add(currentNode.getFirstChild().getNodeValue());
                    continue block15;
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            isXmlFormat = false;
        }
        if (!isXmlFormat) {
            try {
                String[] urls = resp.split("\n");
                if (IpDomainUtil.isHasSchema((String)urls[0])) {
                    siteUrls.addAll(Arrays.asList(urls));
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        for (String siteUrl : siteUrls) {
            Object errorMsg = "";
            Integer statusCode = null;
            long startTime = System.currentTimeMillis();
            try {
                HttpGet httpGet = new HttpGet(siteUrl);
                try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute((HttpUriRequest)httpGet);){
                    statusCode = response.getStatusLine().getStatusCode();
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (ClientProtocolException e1) {
                errorMsg = e1.getCause() != null ? e1.getCause().getMessage() : e1.getMessage();
            }
            catch (UnknownHostException e2) {
                errorMsg = "unknown host";
            }
            catch (InterruptedIOException | ConnectException | SSLException e3) {
                errorMsg = "connect error: " + e3.getMessage();
            }
            catch (IOException e4) {
                errorMsg = "io error: " + e4.getMessage();
            }
            catch (Exception e) {
                errorMsg = "error: " + e.getMessage();
            }
            long responseTime = System.currentTimeMillis() - startTime;
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                if ("url".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(siteUrl);
                    continue;
                }
                if ("StatusCode".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(statusCode == null ? "&nbsp;" : String.valueOf(statusCode));
                    continue;
                }
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(String.valueOf(responseTime));
                    continue;
                }
                if ("errorMsg".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn((String)errorMsg);
                    continue;
                }
                valueRowBuilder.addColumn("&nbsp;");
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }

    private void parseResponseByXmlPath(String resp, List<String> aliasFields, HttpProtocol http, CollectRep.MetricsData.Builder builder) {
    }

    private void parseResponseByJsonPath(String resp, List<String> aliasFields, HttpProtocol http, CollectRep.MetricsData.Builder builder, Long responseTime) {
        List results = JsonPathParser.parseContentWithJsonPath((String)resp, (String)http.getParseScript());
        int keywordNum = CollectUtil.countMatchKeyword((String)resp, (String)http.getKeyword());
        for (int i = 0; i < results.size(); ++i) {
            Object objectValue = results.get(i);
            if (objectValue == null) continue;
            if (objectValue instanceof Map) {
                Map stringMap = (Map)objectValue;
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String alias : aliasFields) {
                    Object value = stringMap.get(alias);
                    if (value != null) {
                        valueRowBuilder.addColumn(String.valueOf(value));
                        continue;
                    }
                    if (alias.startsWith("$.")) {
                        List subResults = JsonPathParser.parseContentWithJsonPath((String)resp, (String)(http.getParseScript() + alias.substring(1)));
                        if (subResults != null && subResults.size() > i) {
                            Object resultValue = subResults.get(i);
                            valueRowBuilder.addColumn(resultValue == null ? "&nbsp;" : String.valueOf(resultValue));
                            continue;
                        }
                        valueRowBuilder.addColumn("&nbsp;");
                        continue;
                    }
                    this.addColumnForSummary(responseTime, valueRowBuilder, keywordNum, alias);
                }
                builder.addValueRow(valueRowBuilder.build());
                continue;
            }
            if (!(objectValue instanceof String)) continue;
            String stringValue = (String)objectValue;
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(responseTime.toString());
                    continue;
                }
                if ("keyword".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(Integer.toString(keywordNum));
                    continue;
                }
                valueRowBuilder.addColumn(stringValue);
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }

    private void parseResponseByPromQl(String resp, List<String> aliasFields, HttpProtocol http, CollectRep.MetricsData.Builder builder) {
        AbstractPrometheusParse prometheusParser = PrometheusParseCreator.getPrometheusParse();
        prometheusParser.handle(resp, aliasFields, http, builder);
    }

    private void parseResponseByPrometheusExporter(String resp, List<String> aliasFields, CollectRep.MetricsData.Builder builder) {
        String metrics;
        ExporterParser parser;
        Map<String, MetricFamily> metricFamilyMap;
        if (!EXPORTER_PARSER_TABLE.containsKey(builder.getId())) {
            EXPORTER_PARSER_TABLE.put(builder.getId(), new ExporterParser());
        }
        if ((metricFamilyMap = (parser = EXPORTER_PARSER_TABLE.get(builder.getId())).textToMetric(resp)).containsKey(metrics = builder.getMetrics())) {
            MetricFamily metricFamily = metricFamilyMap.get(metrics);
            for (MetricFamily.Metric metric : metricFamily.getMetricList()) {
                Map<String, String> labelMap = metric.getLabelPair().stream().collect(Collectors.toMap(MetricFamily.Label::getName, MetricFamily.Label::getValue));
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String aliasField : aliasFields) {
                    if ("value".equals(aliasField)) {
                        if (metric.getCounter() != null) {
                            valueRowBuilder.addColumn(String.valueOf(metric.getCounter().getValue()));
                            continue;
                        }
                        if (metric.getGauge() != null) {
                            valueRowBuilder.addColumn(String.valueOf(metric.getGauge().getValue()));
                            continue;
                        }
                        if (metric.getUntyped() != null) {
                            valueRowBuilder.addColumn(String.valueOf(metric.getUntyped().getValue()));
                            continue;
                        }
                        if (metric.getInfo() != null) {
                            valueRowBuilder.addColumn(String.valueOf(metric.getInfo().getValue()));
                            continue;
                        }
                        if (metric.getSummary() != null) {
                            valueRowBuilder.addColumn(String.valueOf(metric.getSummary().getValue()));
                            continue;
                        }
                        if (metric.getHistogram() == null) continue;
                        valueRowBuilder.addColumn(String.valueOf(metric.getHistogram().getValue()));
                        continue;
                    }
                    String columnValue = labelMap.get(aliasField);
                    valueRowBuilder.addColumn(columnValue == null ? "&nbsp;" : columnValue);
                }
                builder.addValueRow(valueRowBuilder.build());
            }
        }
    }

    private void parseResponseByDefault(String resp, List<String> aliasFields, HttpProtocol http, CollectRep.MetricsData.Builder builder, Long responseTime) {
        JsonElement element = JsonParser.parseString((String)resp);
        int keywordNum = CollectUtil.countMatchKeyword((String)resp, (String)http.getKeyword());
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (JsonElement jsonElement : array) {
                this.getValueFromJson(aliasFields, builder, responseTime, jsonElement, keywordNum);
            }
        } else {
            this.getValueFromJson(aliasFields, builder, responseTime, element, keywordNum);
        }
    }

    private void getValueFromJson(List<String> aliasFields, CollectRep.MetricsData.Builder builder, Long responseTime, JsonElement element, int keywordNum) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : aliasFields) {
                JsonElement valueElement = object.get(alias);
                if (valueElement != null) {
                    String value = valueElement.getAsString();
                    valueRowBuilder.addColumn(value);
                    continue;
                }
                this.addColumnForSummary(responseTime, valueRowBuilder, keywordNum, alias);
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }

    public HttpContext createHttpContext(HttpProtocol httpProtocol) {
        HttpProtocol.Authorization auth = httpProtocol.getAuthorization();
        if (auth != null && "Digest Auth".equals(auth.getType())) {
            HttpClientContext clientContext = new HttpClientContext();
            if (StringUtils.hasText((String)auth.getDigestAuthUsername()) && StringUtils.hasText((String)auth.getDigestAuthPassword())) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(auth.getDigestAuthUsername(), auth.getDigestAuthPassword());
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(new HttpHost(httpProtocol.getHost(), Integer.parseInt(httpProtocol.getPort())), (AuthScheme)new DigestScheme());
                clientContext.setCredentialsProvider((CredentialsProvider)provider);
                clientContext.setAuthCache((AuthCache)authCache);
                return clientContext;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public HttpUriRequest createHttpRequest(HttpProtocol httpProtocol) {
        void var9_32;
        RequestBuilder requestBuilder;
        String httpMethod = httpProtocol.getMethod().toUpperCase();
        if (HttpMethod.GET.matches(httpMethod)) {
            requestBuilder = RequestBuilder.get();
        } else if (HttpMethod.POST.matches(httpMethod)) {
            requestBuilder = RequestBuilder.post();
        } else if (HttpMethod.PUT.matches(httpMethod)) {
            requestBuilder = RequestBuilder.put();
        } else if (HttpMethod.DELETE.matches(httpMethod)) {
            requestBuilder = RequestBuilder.delete();
        } else if (HttpMethod.PATCH.matches(httpMethod)) {
            requestBuilder = RequestBuilder.patch();
        } else {
            log.error("not support the http method: {}.", (Object)httpProtocol.getMethod());
            return null;
        }
        Map params = httpProtocol.getParams();
        boolean enableUrlEncoding = Boolean.parseBoolean(httpProtocol.getEnableUrlEncoding());
        StringBuilder queryParams = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry entry : params.entrySet()) {
                void var9_19;
                String string = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!StringUtils.hasText((String)string)) continue;
                if (queryParams.length() > 0) {
                    queryParams.append("&");
                }
                if (enableUrlEncoding) {
                    String string2 = UriUtils.encodeQueryParam((String)string, (String)"UTF-8");
                }
                queryParams.append((String)var9_19);
                if (!StringUtils.hasText((String)value)) continue;
                String calculatedValue = TimeExpressionUtil.calculate((String)value);
                if (enableUrlEncoding) {
                    calculatedValue = UriUtils.encodeQueryParam((String)calculatedValue, (String)"UTF-8");
                }
                queryParams.append("=").append(calculatedValue);
            }
        }
        requestBuilder.addHeader("Connection", "Keep-Alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        Map headers = httpProtocol.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                if (!StringUtils.hasText((String)((String)entry.getValue()))) continue;
                requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ("default".equals(httpProtocol.getParseType()) || "jsonPath".equals(httpProtocol.getParseType())) {
            requestBuilder.addHeader("Accept", "application/json");
        } else if ("xmlPath".equals(httpProtocol.getParseType())) {
            requestBuilder.addHeader("Accept", "text/html,application/xml");
        } else {
            requestBuilder.addHeader("Accept", "*/*");
        }
        if (httpProtocol.getAuthorization() != null) {
            HttpProtocol.Authorization authorization = httpProtocol.getAuthorization();
            if ("Bearer Token".equalsIgnoreCase(authorization.getType())) {
                String string = "Bearer " + authorization.getBearerTokenToken();
                requestBuilder.addHeader("Authorization", string);
            } else if ("Basic Auth".equals(authorization.getType()) && StringUtils.hasText((String)authorization.getBasicAuthUsername()) && StringUtils.hasText((String)authorization.getBasicAuthPassword())) {
                String string = authorization.getBasicAuthUsername() + ":" + authorization.getBasicAuthPassword();
                String encodedAuth = Base64Util.encode((String)string);
                requestBuilder.addHeader("Authorization", "Basic " + encodedAuth);
            }
        }
        if (StringUtils.hasLength((String)httpProtocol.getPayload()) && (HttpMethod.POST.matches(httpMethod) || HttpMethod.PUT.matches(httpMethod))) {
            requestBuilder.setEntity((HttpEntity)new StringEntity(httpProtocol.getPayload(), StandardCharsets.UTF_8));
        }
        if (enableUrlEncoding) {
            if (httpProtocol.getUrl().contains("?")) {
                String string = httpProtocol.getUrl().substring(0, httpProtocol.getUrl().indexOf("?"));
                String query = httpProtocol.getUrl().substring(httpProtocol.getUrl().indexOf("?") + 1);
                String string3 = UriUtils.encodePath((String)string, (String)"UTF-8") + "?" + UriUtils.encodeQuery((String)query, (String)"UTF-8");
            } else {
                String string = UriUtils.encodePath((String)httpProtocol.getUrl(), (String)"UTF-8");
            }
        } else {
            String string = httpProtocol.getUrl();
        }
        if (queryParams.length() > 0) {
            void var8_16;
            String string = (String)var8_16 + (var8_16.contains("?") ? "&" : "?") + queryParams.toString();
        }
        if (IpDomainUtil.isHasSchema((String)httpProtocol.getHost())) {
            String string = httpProtocol.getHost() + ":" + httpProtocol.getPort() + (String)var8_18;
        } else {
            String ipAddressType = IpDomainUtil.checkIpAddressType((String)httpProtocol.getHost());
            String baseUri = "ipv6".equals(ipAddressType) ? String.format("[%s]:%s%s", httpProtocol.getHost(), httpProtocol.getPort(), var8_18) : String.format("%s:%s%s", httpProtocol.getHost(), httpProtocol.getPort(), var8_18);
            boolean ssl = Boolean.parseBoolean(httpProtocol.getSsl());
            if (ssl) {
                String string = "https://" + baseUri;
            } else {
                String string = "http://" + baseUri;
            }
        }
        try {
            requestBuilder.setUri((String)var9_32);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid URI with illegal characters: {}. User has disabled URL encoding, not applying any encoding.", (Object)var9_32);
            throw e;
        }
        int timeout = CollectUtil.getTimeout((String)httpProtocol.getTimeout(), (int)0);
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }

    private boolean checkSuccessInvoke(Metrics metrics, int statusCode) {
        Set<Integer> successCodeSet;
        List successCodes = metrics.getHttp().getSuccessCodes();
        Set<Integer> set = successCodeSet = successCodes != null ? successCodes.stream().map(code -> {
            try {
                return Integer.valueOf(code);
            }
            catch (Exception ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet()) : this.defaultSuccessStatusCodes;
        if (successCodeSet.isEmpty()) {
            successCodeSet = this.defaultSuccessStatusCodes;
        }
        return successCodeSet.contains(statusCode);
    }
}

