/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.manager.MonitorBind;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.SdMonitorParam;
import org.apache.hertzbeat.common.entity.manager.Tag;
import org.apache.hertzbeat.common.entity.sd.ServiceDiscoveryProtocol;
import org.apache.hertzbeat.common.util.SnowFlakeIdGenerator;

public class SdMonitorOperator {
    public static Optional<Param> getSdParam(List<Param> params) {
        return params.stream().filter(param -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{param.getField(), param.getParamValue()})).filter(param -> Objects.nonNull((Object)ServiceDiscoveryProtocol.Type.getType(param.getField()))).findFirst();
    }

    public static List<Param> removeSdParam(List<Param> params) {
        return params.stream().filter(param -> Objects.isNull((Object)ServiceDiscoveryProtocol.Type.getType(param.getField()))).collect(Collectors.toList());
    }

    public static List<Param> cloneParamList(List<Param> params) {
        return params.stream().map(Param::clone).peek(param -> param.setId(null)).collect(Collectors.toList());
    }

    public static MonitorBind buildSdSubMonitorBind(SdMonitorParam sdMonitorParam, long monitorId, Map<String, String> labels) {
        if (Objects.isNull(sdMonitorParam.getBizId())) {
            return null;
        }
        labels.put("autoCreated", String.valueOf(sdMonitorParam.getBizId()));
        return MonitorBind.builder().id(SnowFlakeIdGenerator.generateId()).bizId(sdMonitorParam.getBizId()).monitorId(monitorId).type((byte)0).build();
    }

    public static MonitorBind buildSdMainMonitorBind(SdMonitorParam sdMonitorParam, long monitorId) {
        if (Objects.isNull(sdMonitorParam.getSdParam())) {
            return null;
        }
        return MonitorBind.builder().id(SnowFlakeIdGenerator.generateId()).bizId(sdMonitorParam.getBizId()).monitorId(monitorId).type((byte)1).build();
    }

    public static Job constructSdJobAndTag(SdMonitorParam sdMonitorParam, Map<String, String> labels, Job appDefine) {
        if (Objects.isNull(sdMonitorParam.getSdParam())) {
            return appDefine;
        }
        labels.put("sdMainMonitor", ServiceDiscoveryProtocol.Type.getType(sdMonitorParam.getSdParam().getField()).name());
        return SdMonitorOperator.constructSdJob(appDefine, sdMonitorParam.getSdParam());
    }

    public static Job constructSdJob(Job appDefine, Param sdParam) {
        Job sdJob = appDefine.clone();
        ServiceDiscoveryProtocol.Type sdType = ServiceDiscoveryProtocol.Type.getType(sdParam.getField());
        ArrayList metricsList = Lists.newArrayList();
        HashMap i18n = Maps.newHashMap();
        i18n.put("zh-CN", "\u76d1\u63a7\u76ee\u6807");
        i18n.put("en-US", "Monitor Target");
        ArrayList fields = Lists.newArrayList();
        fields.add(Metrics.Field.builder().field("host").type((byte)1).i18n(SdMonitorOperator.constructSdFieldI18n("\u4e3b\u673a", "host")).build());
        fields.add(Metrics.Field.builder().field("port").type((byte)1).i18n(SdMonitorOperator.constructSdFieldI18n("\u7aef\u53e3", "port")).build());
        metricsList.add(Metrics.builder().name("target").fields(fields).i18n(i18n).protocol(sdType.getProtocolName()).sdProtocol(ServiceDiscoveryProtocol.builder().sdSource(sdParam.getParamValue()).type(sdType).build()).build());
        sdJob.setSd(Boolean.TRUE);
        sdJob.setMetrics(metricsList);
        sdJob.setConfigmap(Lists.newArrayList((Object[])new Configmap[]{new Configmap(sdParam.getField(), sdParam.getParamValue(), sdParam.getType())}));
        return sdJob;
    }

    public static List<Tag> addMainMonitorTag(List<Tag> tagList, Param sdParam) {
        tagList = tagList.stream().filter(tag -> !StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"sdMainMonitor")).filter(tag -> !StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"autoCreated")).collect(Collectors.toList());
        tagList.add(Tag.builder().name("sdMainMonitor").tagValue(ServiceDiscoveryProtocol.Type.getType(sdParam.getField()).name()).type((byte)0).build());
        return tagList;
    }

    private static Map<String, String> constructSdFieldI18n(String zh, String en) {
        HashMap i18n = Maps.newHashMap();
        i18n.put("zh-CN", zh);
        i18n.put("en-US", en);
        return i18n;
    }
}

