/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.table.ArrowTable;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectRep {
    private static final Logger log = LoggerFactory.getLogger(CollectRep.class);

    private CollectRep() {
    }

    public static class ValueRow {
        private List<String> columns = new LinkedList<String>();

        public ValueRow() {
        }

        public ValueRow(List<String> columns) {
            this.columns.addAll(columns);
        }

        public List<String> getColumnsList() {
            return this.columns;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        public void addColumns(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.columns.add(value);
        }

        public void clearColumns() {
            this.columns = new LinkedList<String>();
        }

        public String getColumns(int index) {
            return this.columns.get(index);
        }

        public int getColumnsCount() {
            return this.columns.size();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private List<String> columns = new LinkedList<String>();

            private Builder() {
            }

            public Builder setColumns(List<String> columns) {
                this.columns = columns;
                return this;
            }

            public Builder addColumn(String column) {
                this.columns.add(column);
                return this;
            }

            public Builder addAllColumns(Iterable<String> columns) {
                for (String column : columns) {
                    this.columns.add(column);
                }
                return this;
            }

            public ValueRow build() {
                return new ValueRow(this.columns);
            }

            public void clear() {
                this.columns.clear();
            }
        }
    }

    public static class Field {
        private String name = "";
        private int type;
        private String unit = "";
        private boolean label;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean getLabel() {
            return this.label;
        }

        public void setLabel(boolean label) {
            this.label = label;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return other.name.equals(this.name);
        }

        public static class Builder {
            private final Field instance = new Field();

            private Builder() {
            }

            public Builder setName(String name) {
                this.instance.setName(name);
                return this;
            }

            public Builder setType(int type) {
                this.instance.setType(type);
                return this;
            }

            public Builder setUnit(String unit) {
                this.instance.setUnit(unit);
                return this;
            }

            public Builder setLabel(boolean label) {
                this.instance.setLabel(label);
                return this;
            }

            public Field build() {
                return this.instance;
            }
        }
    }

    public static class MetricsData
    implements AutoCloseable {
        private ArrowTable table;

        public MetricsData(ArrowTable table) {
            this.table = table;
        }

        public MetricsData(VectorSchemaRoot vectorSchemaRoot) {
            this.table = new ArrowTable(vectorSchemaRoot);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(MetricsData metricsData) {
            Builder builder = new Builder();
            builder.addMetadataAll(metricsData.getMetadata());
            metricsData.getFields().forEach(builder::addField);
            metricsData.getValues().forEach(builder::addValueRow);
            return builder;
        }

        public long rowCount() {
            return this.table != null ? this.table.getRowCount() : 0L;
        }

        public ArrowTable getTable() {
            return this.table;
        }

        public VectorSchemaRoot toVectorSchemaRootAndRelease() {
            return this.table != null ? this.table.toVectorSchemaRoot() : null;
        }

        /*
         * Exception decompiling
         */
        public byte[] toByteArrayAndRelease() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public long getId() {
            Map<String, String> metadata = this.getMetadata();
            return Long.parseLong(metadata.getOrDefault("id", "0"));
        }

        public long getTenantId() {
            Map<String, String> metadata = this.getMetadata();
            return Long.parseLong(metadata.getOrDefault("tenantId", "0"));
        }

        public String getApp() {
            Map<String, String> metadata = this.getMetadata();
            return metadata.getOrDefault("app", "");
        }

        public String getMetrics() {
            Map<String, String> metadata = this.getMetadata();
            return metadata.getOrDefault("metrics", "");
        }

        public int getPriority() {
            Map<String, String> metadata = this.getMetadata();
            return Integer.parseInt(metadata.getOrDefault("priority", "0"));
        }

        public long getTime() {
            Map<String, String> metadata = this.getMetadata();
            return Long.parseLong(metadata.getOrDefault("time", "0"));
        }

        public Code getCode() {
            Map<String, String> metadata = this.getMetadata();
            return Code.forNumber(Integer.parseInt(metadata.getOrDefault("code", "0")));
        }

        public String getMsg() {
            Map<String, String> metadata = this.getMetadata();
            return metadata.getOrDefault("msg", "");
        }

        public String getInstanceName() {
            Map<String, String> metadata = this.getMetadata();
            return metadata.getOrDefault("instancename", null);
        }

        public String getInstanceHost() {
            Map<String, String> metadata = this.getMetadata();
            return metadata.getOrDefault("instancehost", null);
        }

        public Map<String, String> getLabels() {
            Map<String, String> metadata = this.getMetadata();
            String labelStr = metadata.getOrDefault("labels", "");
            if (labelStr == null || "".equals(labelStr)) {
                return null;
            }
            return JsonUtil.fromJson(labelStr, Map.class);
        }

        public Map<String, String> getAnnotations() {
            Map<String, String> metadata = this.getMetadata();
            String annotationStr = metadata.getOrDefault("annotations", "");
            if (annotationStr == null || "".equals(annotationStr)) {
                return null;
            }
            return JsonUtil.fromJson(annotationStr, Map.class);
        }

        private Map<String, String> getMetadata() {
            return this.table != null ? this.table.getSchema().getCustomMetadata() : new HashMap();
        }

        public List<Field> getFields() {
            if (this.table == null) {
                return new ArrayList<Field>();
            }
            return this.table.getSchema().getFields().stream().map(field -> {
                Map metadata = field.getMetadata();
                return Field.newBuilder().setName(field.getName()).setType(Integer.parseInt(metadata.getOrDefault("type", "0"))).setUnit(metadata.getOrDefault("unit", "")).setLabel(Boolean.parseBoolean(metadata.getOrDefault("label", "false"))).build();
            }).collect(Collectors.toList());
        }

        public List<ValueRow> getValues() {
            if (this.table == null) {
                return new ArrayList<ValueRow>();
            }
            List fieldNames = this.table.getSchema().getFields().stream().map(org.apache.arrow.vector.types.pojo.Field::getName).collect(Collectors.toList());
            ArrayList<ValueRow> values = new ArrayList<ValueRow>();
            Iterator<Row> iterator = this.table.iterator();
            while (iterator.hasNext()) {
                Row row = iterator.next();
                ValueRow valueRow = ValueRow.newBuilder().setColumns(fieldNames.stream().map(fieldName -> new String(((VarCharVector)this.table.getVector((String)fieldName)).get(row.getRowNumber()))).collect(Collectors.toList())).build();
                values.add(valueRow);
            }
            return values;
        }

        public RowWrapper readRow() {
            Iterator<Row> rowIterator = this.table.iterator();
            List fields = this.table.getSchema().getFields();
            return new RowWrapper(null, rowIterator, fields, -1);
        }

        public int getValuesCount() {
            return this.table != null ? (int)this.table.getRowCount() : 0;
        }

        public int getFieldsCount() {
            return this.table != null ? this.table.getSchema().getFields().size() : 0;
        }

        @Override
        public void close() {
            if (this.table != null) {
                this.table.close();
            }
        }

        public static class Builder {
            private Map<String, String> metadata = new HashMap<String, String>();
            private List<Field> fields = new ArrayList<Field>();
            private List<ValueRow> values = new ArrayList<ValueRow>();

            public Builder setId(long id) {
                this.metadata.put("id", String.valueOf(id));
                return this;
            }

            public Builder setTenantId(long tenantId) {
                this.metadata.put("tenantId", String.valueOf(tenantId));
                return this;
            }

            public Builder setApp(String app) {
                this.metadata.put("app", app != null ? app : "");
                return this;
            }

            public Builder setMetrics(String metrics) {
                this.metadata.put("metrics", metrics != null ? metrics : "");
                return this;
            }

            public Builder setLabels(Map<String, String> labels) {
                if (labels == null || labels.isEmpty()) {
                    return this;
                }
                String labelStr = JsonUtil.toJson(labels);
                this.metadata.put("labels", labelStr);
                return this;
            }

            public Builder setAnnotations(Map<String, String> annotations) {
                if (annotations == null || annotations.isEmpty()) {
                    return this;
                }
                String annotationStr = JsonUtil.toJson(annotations);
                this.metadata.put("annotations", annotationStr);
                return this;
            }

            public Builder setPriority(int priority) {
                this.metadata.put("priority", String.valueOf(priority));
                return this;
            }

            public Builder setTime(long time) {
                this.metadata.put("time", String.valueOf(time));
                return this;
            }

            public Builder setCode(Code code) {
                this.metadata.put("code", String.valueOf(code != null ? code.value : 0));
                return this;
            }

            public Builder setMsg(String msg) {
                this.metadata.put("msg", msg != null ? msg : "");
                return this;
            }

            public Builder addMetadata(String key, String value) {
                if (key == null || "".equals(key)) {
                    return this;
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder addMetadataAll(Map<String, String> meta) {
                if (meta == null || meta.isEmpty()) {
                    return this;
                }
                this.metadata.putAll(meta);
                return this;
            }

            public Builder addField(Field field) {
                this.fields.add(field);
                return this;
            }

            public Builder addValueRow(ValueRow valueRow) {
                this.values.add(valueRow);
                return this;
            }

            public MetricsData build() {
                RootAllocator allocator = new RootAllocator();
                try {
                    List arrowFields = this.fields.stream().map(field -> {
                        HashMap<String, String> fieldMetadata = new HashMap<String, String>();
                        fieldMetadata.put("type", String.valueOf(field.getType()));
                        fieldMetadata.put("unit", field.getUnit());
                        fieldMetadata.put("label", String.valueOf(field.getLabel()));
                        return new org.apache.arrow.vector.types.pojo.Field(field.getName(), new FieldType(true, (ArrowType)new ArrowType.Utf8(), null, fieldMetadata), null);
                    }).collect(Collectors.toList());
                    Schema schema = new Schema(arrowFields, this.metadata);
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
                    try {
                        root.allocateNew();
                        int rowCount = this.values.size();
                        root.setRowCount(rowCount);
                        for (int fieldIndex = 0; fieldIndex < this.fields.size(); ++fieldIndex) {
                            VarCharVector vector = (VarCharVector)root.getVector(fieldIndex);
                            vector.allocateNew();
                            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                                String value;
                                ValueRow row = this.values.get(rowIndex);
                                if (row == null || row.getColumnsList() == null || fieldIndex >= row.getColumnsList().size() || (value = row.getColumns(fieldIndex)) == null) continue;
                                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                                if (bytes.length > 32700) {
                                    log.warn("Value too large for Arrow buffer ({}), truncating to 32700 bytes. Meta: {}", (Object)bytes.length, (Object)JsonUtil.toJson(this.metadata));
                                    byte[] truncatedBytes = new byte[32700];
                                    System.arraycopy(bytes, 0, truncatedBytes, 0, 32700);
                                    vector.set(rowIndex, truncatedBytes);
                                    continue;
                                }
                                vector.set(rowIndex, bytes);
                            }
                            vector.setValueCount(rowCount);
                        }
                        return new MetricsData(new ArrowTable(root));
                    }
                    catch (Exception e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                        root.close();
                        throw e1;
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    allocator.close();
                    throw e;
                }
            }

            public long getId() {
                return Long.parseLong(this.metadata.getOrDefault("id", "0"));
            }

            public long getTenantId() {
                return Long.parseLong(this.metadata.getOrDefault("tenantId", "0"));
            }

            public String getApp() {
                return this.metadata.getOrDefault("app", "");
            }

            public String getMetrics() {
                return this.metadata.getOrDefault("metrics", "");
            }

            public int getPriority() {
                return Integer.parseInt(this.metadata.getOrDefault("priority", "0"));
            }

            public long getTime() {
                return Integer.parseInt(this.metadata.getOrDefault("time", "0"));
            }

            public Code getCode() {
                return Code.forNumber(Integer.parseInt(this.metadata.getOrDefault("code", "0")));
            }

            public String getMsg() {
                return this.metadata.getOrDefault("msg", "");
            }

            public String getInstanceName() {
                return this.metadata.getOrDefault("instancename", null);
            }

            public String getInstanceHost() {
                return this.metadata.getOrDefault("instancehost", null);
            }

            public Map<String, String> getLabels() {
                String labelStr = this.metadata.getOrDefault("labels", "");
                if (labelStr == null || "".equals(labelStr)) {
                    return null;
                }
                return JsonUtil.fromJson(labelStr, Map.class);
            }

            public Map<String, String> getAnnotations() {
                String annotationStr = this.metadata.getOrDefault("annotations", "");
                if (annotationStr == null || "".equals(annotationStr)) {
                    return null;
                }
                return JsonUtil.fromJson(annotationStr, Map.class);
            }

            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            public List<Field> getFieldsList() {
                return this.fields;
            }

            public Field getFields(int index) {
                return this.fields.get(index);
            }

            public int getFieldsCount() {
                return this.fields.size();
            }

            public List<ValueRow> getValuesList() {
                return this.values;
            }

            public ValueRow getValues(int index) {
                return this.values.get(index);
            }

            public int getValuesCount() {
                return this.values.size();
            }

            public void addAllFields(List<Field> fieldList) {
                this.fields.addAll(fieldList);
            }

            public void clearValues() {
                this.values = new LinkedList<ValueRow>();
            }

            public void clearFields() {
                this.fields = new LinkedList<Field>();
            }
        }
    }

    public static enum Code {
        SUCCESS(0),
        UN_AVAILABLE(1),
        UN_REACHABLE(2),
        UN_CONNECTABLE(3),
        FAIL(4),
        TIMEOUT(5),
        UNRECOGNIZED(-1);

        private final int value;

        private Code(int value) {
            this.value = value;
        }

        public int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        public static Code forNumber(int value) {
            switch (value) {
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return UN_AVAILABLE;
                }
                case 2: {
                    return UN_REACHABLE;
                }
                case 3: {
                    return UN_CONNECTABLE;
                }
                case 4: {
                    return FAIL;
                }
                case 5: {
                    return TIMEOUT;
                }
            }
            return null;
        }
    }
}

