/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.entity.manager.JsonStringListAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_group", indexes={@Index(name="unique_group_key", columnList="group_key", unique=true)})
@Schema(description="Group Alarm Content Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class GroupAlert {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Threshold Id", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Group Key", example="HighCPUUsage{alertname=\"HighCPUUsage\", instance=\"server1\"}")
    @Column(length=2048)
    private String groupKey;
    @Schema(title="Status", example="resolved")
    private String status;
    @Schema(title="Group Labels", example="{\"alertname\": \"HighCPUUsage\"}")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> groupLabels;
    @Schema(title="Common Labels", example="{\"alertname\": \"HighCPUUsage\", \"instance\": \"server1\", \"severity\": \"critical\"}")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> commonLabels;
    @Schema(title="Common Annotations", example="{\"summary\": \"High CPU usage detected\", \"description\": \"CPU usage is back to normal for server1\"}")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=4096)
    private Map<String, String> commonAnnotations;
    @Schema(title="Alert Fingerprints", example="[\"dxsdfdsf\"]")
    @Convert(converter=JsonStringListAttributeConverter.class)
    @Column(length=2048)
    private List<String> alertFingerprints;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)")
    @CreatedDate
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)")
    @LastModifiedDate
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime gmtUpdate;
    @Transient
    private List<SingleAlert> alerts;

    public static GroupAlertBuilder builder() {
        return new GroupAlertBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, String> getGroupLabels() {
        return this.groupLabels;
    }

    public Map<String, String> getCommonLabels() {
        return this.commonLabels;
    }

    public Map<String, String> getCommonAnnotations() {
        return this.commonAnnotations;
    }

    public List<String> getAlertFingerprints() {
        return this.alertFingerprints;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public List<SingleAlert> getAlerts() {
        return this.alerts;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setGroupLabels(Map<String, String> groupLabels) {
        this.groupLabels = groupLabels;
    }

    public void setCommonLabels(Map<String, String> commonLabels) {
        this.commonLabels = commonLabels;
    }

    public void setCommonAnnotations(Map<String, String> commonAnnotations) {
        this.commonAnnotations = commonAnnotations;
    }

    public void setAlertFingerprints(List<String> alertFingerprints) {
        this.alertFingerprints = alertFingerprints;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public void setAlerts(List<SingleAlert> alerts) {
        this.alerts = alerts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupAlert)) {
            return false;
        }
        GroupAlert other = (GroupAlert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$groupKey = this.getGroupKey();
        String other$groupKey = other.getGroupKey();
        if (this$groupKey == null ? other$groupKey != null : !this$groupKey.equals(other$groupKey)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, String> this$groupLabels = this.getGroupLabels();
        Map<String, String> other$groupLabels = other.getGroupLabels();
        if (this$groupLabels == null ? other$groupLabels != null : !((Object)this$groupLabels).equals(other$groupLabels)) {
            return false;
        }
        Map<String, String> this$commonLabels = this.getCommonLabels();
        Map<String, String> other$commonLabels = other.getCommonLabels();
        if (this$commonLabels == null ? other$commonLabels != null : !((Object)this$commonLabels).equals(other$commonLabels)) {
            return false;
        }
        Map<String, String> this$commonAnnotations = this.getCommonAnnotations();
        Map<String, String> other$commonAnnotations = other.getCommonAnnotations();
        if (this$commonAnnotations == null ? other$commonAnnotations != null : !((Object)this$commonAnnotations).equals(other$commonAnnotations)) {
            return false;
        }
        List<String> this$alertFingerprints = this.getAlertFingerprints();
        List<String> other$alertFingerprints = other.getAlertFingerprints();
        if (this$alertFingerprints == null ? other$alertFingerprints != null : !((Object)this$alertFingerprints).equals(other$alertFingerprints)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        if (this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate)) {
            return false;
        }
        List<SingleAlert> this$alerts = this.getAlerts();
        List<SingleAlert> other$alerts = other.getAlerts();
        return !(this$alerts == null ? other$alerts != null : !((Object)this$alerts).equals(other$alerts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupAlert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $groupKey = this.getGroupKey();
        result = result * 59 + ($groupKey == null ? 43 : $groupKey.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, String> $groupLabels = this.getGroupLabels();
        result = result * 59 + ($groupLabels == null ? 43 : ((Object)$groupLabels).hashCode());
        Map<String, String> $commonLabels = this.getCommonLabels();
        result = result * 59 + ($commonLabels == null ? 43 : ((Object)$commonLabels).hashCode());
        Map<String, String> $commonAnnotations = this.getCommonAnnotations();
        result = result * 59 + ($commonAnnotations == null ? 43 : ((Object)$commonAnnotations).hashCode());
        List<String> $alertFingerprints = this.getAlertFingerprints();
        result = result * 59 + ($alertFingerprints == null ? 43 : ((Object)$alertFingerprints).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        List<SingleAlert> $alerts = this.getAlerts();
        result = result * 59 + ($alerts == null ? 43 : ((Object)$alerts).hashCode());
        return result;
    }

    public String toString() {
        return "GroupAlert(id=" + this.getId() + ", groupKey=" + this.getGroupKey() + ", status=" + this.getStatus() + ", groupLabels=" + this.getGroupLabels() + ", commonLabels=" + this.getCommonLabels() + ", commonAnnotations=" + this.getCommonAnnotations() + ", alertFingerprints=" + this.getAlertFingerprints() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ", alerts=" + this.getAlerts() + ")";
    }

    public GroupAlert(Long id, String groupKey, String status, Map<String, String> groupLabels, Map<String, String> commonLabels, Map<String, String> commonAnnotations, List<String> alertFingerprints, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate, List<SingleAlert> alerts) {
        this.id = id;
        this.groupKey = groupKey;
        this.status = status;
        this.groupLabels = groupLabels;
        this.commonLabels = commonLabels;
        this.commonAnnotations = commonAnnotations;
        this.alertFingerprints = alertFingerprints;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
        this.alerts = alerts;
    }

    public GroupAlert() {
    }

    public static class GroupAlertBuilder {
        private Long id;
        private String groupKey;
        private String status;
        private Map<String, String> groupLabels;
        private Map<String, String> commonLabels;
        private Map<String, String> commonAnnotations;
        private List<String> alertFingerprints;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;
        private List<SingleAlert> alerts;

        GroupAlertBuilder() {
        }

        public GroupAlertBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public GroupAlertBuilder groupKey(String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        public GroupAlertBuilder status(String status) {
            this.status = status;
            return this;
        }

        public GroupAlertBuilder groupLabels(Map<String, String> groupLabels) {
            this.groupLabels = groupLabels;
            return this;
        }

        public GroupAlertBuilder commonLabels(Map<String, String> commonLabels) {
            this.commonLabels = commonLabels;
            return this;
        }

        public GroupAlertBuilder commonAnnotations(Map<String, String> commonAnnotations) {
            this.commonAnnotations = commonAnnotations;
            return this;
        }

        public GroupAlertBuilder alertFingerprints(List<String> alertFingerprints) {
            this.alertFingerprints = alertFingerprints;
            return this;
        }

        public GroupAlertBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public GroupAlertBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public GroupAlertBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public GroupAlertBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public GroupAlertBuilder alerts(List<SingleAlert> alerts) {
            this.alerts = alerts;
            return this;
        }

        public GroupAlert build() {
            return new GroupAlert(this.id, this.groupKey, this.status, this.groupLabels, this.commonLabels, this.commonAnnotations, this.alertFingerprints, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate, this.alerts);
        }

        public String toString() {
            return "GroupAlert.GroupAlertBuilder(id=" + this.id + ", groupKey=" + this.groupKey + ", status=" + this.status + ", groupLabels=" + this.groupLabels + ", commonLabels=" + this.commonLabels + ", commonAnnotations=" + this.commonAnnotations + ", alertFingerprints=" + this.alertFingerprints + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ", alerts=" + this.alerts + ")";
        }
    }
}

