/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_monitor_bind", indexes={@Index(name="index_monitor_bind", columnList="bizId"), @Index(name="index_monitor_bin", columnList="monitor_id")})
@Schema(description="relation between monitor")
@EntityListeners(value={AuditingEntityListener.class})
public class MonitorBind {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="primary id", example="23")
    private Long id;
    @Schema(title="collector name", example="87432674384")
    private Long bizId;
    @Schema(title="monitor ID", example="87432674336")
    @Column(name="monitor_id")
    private Long monitorId;
    @Schema(title="Bind type 0: sd", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @Max(value=3L)
    private @Min(value=0L) @Max(value=3L) byte type;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by")
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static MonitorBindBuilder builder() {
        return new MonitorBindBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public Long getMonitorId() {
        return this.monitorId;
    }

    public byte getType() {
        return this.type;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorBind)) {
            return false;
        }
        MonitorBind other = (MonitorBind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Long this$monitorId = this.getMonitorId();
        Long other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !((Object)this$monitorId).equals(other$monitorId)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitorBind;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Long $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : ((Object)$monitorId).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "MonitorBind(id=" + this.getId() + ", bizId=" + this.getBizId() + ", monitorId=" + this.getMonitorId() + ", type=" + this.getType() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public MonitorBind(Long id, Long bizId, Long monitorId, byte type, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.bizId = bizId;
        this.monitorId = monitorId;
        this.type = type;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public MonitorBind() {
    }

    public static class MonitorBindBuilder {
        private Long id;
        private Long bizId;
        private Long monitorId;
        private byte type;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        MonitorBindBuilder() {
        }

        public MonitorBindBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public MonitorBindBuilder bizId(Long bizId) {
            this.bizId = bizId;
            return this;
        }

        public MonitorBindBuilder monitorId(Long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public MonitorBindBuilder type(byte type) {
            this.type = type;
            return this;
        }

        public MonitorBindBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public MonitorBindBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public MonitorBindBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public MonitorBindBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public MonitorBind build() {
            return new MonitorBind(this.id, this.bizId, this.monitorId, this.type, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "MonitorBind.MonitorBindBuilder(id=" + this.id + ", bizId=" + this.bizId + ", monitorId=" + this.monitorId + ", type=" + this.type + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

