/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.manager.Tag;
import org.apache.hertzbeat.manager.dao.TagDao;
import org.apache.hertzbeat.manager.service.TagService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TagServiceImpl
implements TagService {
    private static final Logger log = LoggerFactory.getLogger(TagServiceImpl.class);
    @Autowired
    private TagDao tagDao;

    @Override
    public void addTags(List<Tag> tags) {
        tags = tags.stream().peek(tag -> {
            Optional<Tag> tagOptional = this.tagDao.findTagByNameAndTagValue(tag.getName(), tag.getTagValue());
            if (tagOptional.isPresent()) {
                throw new IllegalArgumentException("The tag already exists.");
            }
            tag.setType((byte)1);
            tag.setId(null);
        }).distinct().collect(Collectors.toList());
        this.tagDao.saveAll(tags);
    }

    @Override
    public void modifyTag(Tag tag) {
        Optional tagOptional = this.tagDao.findById(tag.getId());
        if (tagOptional.isPresent()) {
            Optional<Tag> tagExistOptional = this.tagDao.findTagByNameAndTagValue(tag.getName(), tag.getTagValue());
            if (tagExistOptional.isPresent() && !tagExistOptional.get().getId().equals(tag.getId())) {
                throw new IllegalArgumentException("The tag with same key and value already exists.");
            }
        } else {
            throw new IllegalArgumentException("The tag is not existed");
        }
        tag.setTagValue(StringUtils.isEmpty((CharSequence)tag.getTagValue()) ? null : tag.getTagValue());
        this.tagDao.save(tag);
    }

    @Override
    public Page<Tag> getTags(String search, Byte type, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (type != null) {
                Predicate predicateApp = criteriaBuilder.equal((Expression)root.get("type"), (Object)type);
                andList.add(predicateApp);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            ArrayList<Predicate> orList = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)search)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + search.toLowerCase() + "%");
                orList.add(predicateName);
                Predicate predicateValue = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("tagValue")), "%" + search.toLowerCase() + "%");
                orList.add(predicateValue);
            }
            Predicate[] orPredicates = new Predicate[orList.size()];
            Predicate orPredicate = criteriaBuilder.or(orList.toArray(orPredicates));
            if (andPredicates.length == 0 && orPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            if (andPredicates.length == 0) {
                return orPredicate;
            }
            if (orPredicates.length == 0) {
                return andPredicate;
            }
            return query.where(new Predicate[]{andPredicate, orPredicate}).getRestriction();
        };
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        return this.tagDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void deleteTags(HashSet<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.tagDao.deleteTagsByIdIn(ids);
    }
}

