/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.manager.Define;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.support.SpringContextHolder;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.manager.dao.DefineDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.pojo.dto.FileDTO;
import org.apache.hertzbeat.manager.pojo.dto.Hierarchy;
import org.apache.hertzbeat.manager.pojo.dto.ObjectStoreConfigChangeEvent;
import org.apache.hertzbeat.manager.pojo.dto.ObjectStoreDTO;
import org.apache.hertzbeat.manager.pojo.dto.TemplateConfig;
import org.apache.hertzbeat.manager.service.AppService;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.apache.hertzbeat.manager.service.ObjectStoreService;
import org.apache.hertzbeat.manager.service.impl.ObjectStoreConfigServiceImpl;
import org.apache.hertzbeat.manager.service.impl.ObsObjectStoreServiceImpl;
import org.apache.hertzbeat.warehouse.service.WarehouseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.yaml.snakeyaml.Yaml;

@Service
@Order(value=-2147483648)
public class AppServiceImpl
implements AppService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AppServiceImpl.class);
    private static final String PUSH_PROTOCOL_METRICS_NAME = "metrics";
    @Resource
    private MonitorDao monitorDao;
    @Resource
    private ObjectStoreConfigServiceImpl objectStoreConfigService;
    @Resource
    private ParamDao paramDao;
    @Resource
    private DefineDao defineDao;
    @Resource
    private WarehouseService warehouseService;
    private final Map<String, Job> appDefines = new ConcurrentHashMap<String, Job>();
    private AppDefineStore appDefineStore;
    private final AppDefineStore jarAppDefineStore = new JarAppDefineStoreImpl();

    @Override
    public List<ParamDefine> getAppParamDefines(String app) {
        Job appDefine;
        if (StringUtils.isNotBlank((CharSequence)app) && (appDefine = this.appDefines.get(app.toLowerCase())) != null && appDefine.getParams() != null) {
            return appDefine.getParams();
        }
        return Collections.emptyList();
    }

    @Override
    public Job getPushDefine(Long monitorId) throws IllegalArgumentException {
        Job appDefine = this.appDefines.get("push");
        if (appDefine == null) {
            throw new IllegalArgumentException("The push collector not support.");
        }
        List<Metrics> metrics = appDefine.getMetrics();
        ArrayList<Metrics> metricsTmp = new ArrayList<Metrics>();
        for (Metrics metric : metrics) {
            if (!PUSH_PROTOCOL_METRICS_NAME.equals(metric.getName())) continue;
            List<Param> params = this.paramDao.findParamsByMonitorId(monitorId);
            List<Configmap> configmaps = params.stream().map(param -> new Configmap(param.getField(), param.getParamValue(), param.getType())).toList();
            Map<String, Configmap> configmap = configmaps.stream().collect(Collectors.toMap(Configmap::getKey, item -> item, (key1, key2) -> key1));
            CollectUtil.replaceFieldsForPushStyleMonitor((Metrics)metric, configmap);
            metricsTmp.add(metric);
        }
        appDefine.setMetrics(metricsTmp);
        return appDefine;
    }

    @Override
    public Job getAutoGenerateDynamicDefine(Long monitorId) {
        Job job = this.getAppDefine("prometheus");
        List metricsDataList = this.warehouseService.queryMonitorMetricsData(monitorId);
        Metrics tmpMetrics = job.getMetrics().get(0);
        LinkedList<Metrics> metricsList = new LinkedList<Metrics>();
        for (CollectRep.MetricsData metricsData : metricsDataList) {
            List<Metrics.Field> fields = metricsData.getFields().stream().map(item -> Metrics.Field.builder().field(item.getName()).type((byte)item.getType()).label(item.getLabel()).unit(item.getUnit()).build()).collect(Collectors.toList());
            Metrics metrics = Metrics.builder().visible(true).name(metricsData.getMetrics()).fields(fields).prometheus(tmpMetrics.getPrometheus()).build();
            metricsList.add(metrics);
        }
        job.setMetrics(metricsList);
        return job;
    }

    @Override
    public Job getAppDefine(String app) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)app)) {
            throw new IllegalArgumentException("The app can not null.");
        }
        Job appDefine = this.appDefines.get(app.toLowerCase());
        if (appDefine == null) {
            throw new IllegalArgumentException("The app " + app + " not support.");
        }
        return appDefine.clone();
    }

    @Override
    public Optional<Job> getAppDefineOption(String app) {
        if (StringUtils.isNotBlank((CharSequence)app)) {
            Job appDefine = this.appDefines.get(app.toLowerCase());
            return Optional.ofNullable(appDefine);
        }
        return Optional.empty();
    }

    @Override
    public List<String> getAppDefineMetricNames(String app) {
        ArrayList<String> metricNames = new ArrayList<String>(16);
        if (StringUtils.isNotBlank((CharSequence)app)) {
            Job appDefine = this.appDefines.get(app.toLowerCase());
            if (appDefine == null) {
                throw new IllegalArgumentException("The app " + app + " not support.");
            }
            metricNames.addAll(appDefine.getMetrics().stream().map(Metrics::getName).toList());
        } else {
            this.appDefines.forEach((k, v) -> metricNames.addAll(v.getMetrics().stream().map(Metrics::getName).toList()));
        }
        return metricNames;
    }

    @Override
    public Map<String, String> getI18nResources(String lang) {
        HashMap<String, String> i18nMap = new HashMap<String, String>(128);
        for (Job job : this.appDefines.values()) {
            Map<String, String> helpLink;
            String i18nHelpLink;
            Map<String, String> help;
            String i18nHelp;
            Map<String, String> name = job.getName();
            String i18nName = CommonUtil.getLangMappingValueFromI18nMap(lang, name);
            if (i18nName != null) {
                i18nMap.put("monitor.app." + job.getApp().toLowerCase(), i18nName);
            }
            if ((i18nHelp = CommonUtil.getLangMappingValueFromI18nMap(lang, help = job.getHelp())) != null) {
                i18nMap.put("monitor.app." + job.getApp() + ".help", i18nHelp);
            }
            if ((i18nHelpLink = CommonUtil.getLangMappingValueFromI18nMap(lang, helpLink = job.getHelpLink())) != null) {
                i18nMap.put("monitor.app." + job.getApp() + ".helpLink", i18nHelpLink);
            }
            for (ParamDefine paramDefine : job.getParams()) {
                Map<String, String> paramDefineName = paramDefine.getName();
                String i18nParamName = CommonUtil.getLangMappingValueFromI18nMap(lang, paramDefineName);
                if (i18nParamName == null) continue;
                i18nMap.put("monitor.app." + job.getApp() + ".param." + paramDefine.getField(), i18nParamName);
            }
            for (Metrics metrics : job.getMetrics()) {
                Map<String, String> metricsI18nName = metrics.getI18n();
                String i18nMetricsName = CommonUtil.getLangMappingValueFromI18nMap(lang, metricsI18nName);
                if (i18nMetricsName != null) {
                    i18nMap.put("monitor.app." + job.getApp() + ".metrics." + metrics.getName(), i18nMetricsName);
                }
                if (metrics.getFields() == null) continue;
                for (Metrics.Field field : metrics.getFields()) {
                    Map<String, String> fieldI18nName = field.getI18n();
                    String i18nMetricName = CommonUtil.getLangMappingValueFromI18nMap(lang, fieldI18nName);
                    if (i18nMetricName == null) continue;
                    i18nMap.put("monitor.app." + job.getApp() + ".metrics." + metrics.getName() + ".metric." + field.getField(), i18nMetricName);
                }
            }
        }
        return i18nMap;
    }

    @Override
    public Map<String, String> getI18nApps(String lang) {
        HashMap<String, String> i18nMap = new HashMap<String, String>(128);
        for (Job job : this.appDefines.values()) {
            Map<String, String> name = job.getName();
            String i18nName = CommonUtil.getLangMappingValueFromI18nMap(lang, name);
            if (i18nName == null) continue;
            i18nMap.put(job.getApp(), i18nName);
        }
        return i18nMap;
    }

    @Override
    public List<Hierarchy> getAllAppHierarchy(String lang) {
        LinkedList<Hierarchy> hierarchies = new LinkedList<Hierarchy>();
        for (Job job : this.appDefines.values()) {
            if ("push".equalsIgnoreCase(job.getApp())) continue;
            this.queryAppHierarchy(lang, hierarchies, job);
        }
        return hierarchies;
    }

    @Override
    public List<Hierarchy> getAppHierarchy(String app, String lang) {
        LinkedList<Hierarchy> hierarchies = new LinkedList<Hierarchy>();
        Job job = this.appDefines.get(app.toLowerCase());
        if ("push".equalsIgnoreCase(job.getApp())) {
            return hierarchies;
        }
        this.queryAppHierarchy(lang, hierarchies, job);
        return hierarchies;
    }

    private void queryAppHierarchy(String lang, LinkedList<Hierarchy> hierarchies, Job job) {
        String i18nName;
        Hierarchy hierarchyApp = new Hierarchy();
        hierarchyApp.setCategory(job.getCategory());
        hierarchyApp.setValue(job.getApp());
        hierarchyApp.setHide(job.isHide());
        Map<String, String> nameMap = job.getName();
        if (nameMap != null && !nameMap.isEmpty() && (i18nName = CommonUtil.getLangMappingValueFromI18nMap(lang, nameMap)) != null) {
            hierarchyApp.setLabel(i18nName);
        }
        LinkedList<Hierarchy> hierarchyMetricList = new LinkedList<Hierarchy>();
        if ("prometheus".equalsIgnoreCase(job.getApp())) {
            List<Monitor> monitors = this.monitorDao.findMonitorsByAppEquals(job.getApp());
            for (Monitor monitor : monitors) {
                List metricsDataList = this.warehouseService.queryMonitorMetricsData(monitor.getId());
                for (CollectRep.MetricsData metricsData : metricsDataList) {
                    Hierarchy hierarchyMetric = new Hierarchy();
                    hierarchyMetric.setValue(metricsData.getMetrics());
                    hierarchyMetric.setLabel(metricsData.getMetrics());
                    List<Hierarchy> hierarchyFieldList = metricsData.getFields().stream().map(item -> {
                        Hierarchy hierarchyField = new Hierarchy();
                        hierarchyField.setValue(item.getName());
                        hierarchyField.setLabel(item.getName());
                        hierarchyField.setIsLeaf(true);
                        hierarchyField.setType((byte)item.getType());
                        hierarchyField.setUnit(item.getUnit());
                        return hierarchyField;
                    }).collect(Collectors.toList());
                    hierarchyMetric.setChildren(hierarchyFieldList);
                    this.combineHierarchyMetrics(hierarchyMetricList, hierarchyMetric);
                }
            }
            hierarchyApp.setChildren(hierarchyMetricList);
            hierarchies.addFirst(hierarchyApp);
        } else {
            if (job.getMetrics() != null) {
                for (Metrics metrics : job.getMetrics()) {
                    Hierarchy hierarchyMetric = new Hierarchy();
                    hierarchyMetric.setValue(metrics.getName());
                    String metricsI18nName = CommonUtil.getLangMappingValueFromI18nMap(lang, metrics.getI18n());
                    hierarchyMetric.setLabel(metricsI18nName != null ? metricsI18nName : metrics.getName());
                    LinkedList<Hierarchy> hierarchyFieldList = new LinkedList<Hierarchy>();
                    if (metrics.getFields() != null) {
                        for (Metrics.Field field : metrics.getFields()) {
                            Hierarchy hierarchyField = new Hierarchy();
                            hierarchyField.setValue(field.getField());
                            String metricI18nName = CommonUtil.getLangMappingValueFromI18nMap(lang, field.getI18n());
                            hierarchyField.setLabel(metricI18nName != null ? metricI18nName : field.getField());
                            hierarchyField.setIsLeaf(true);
                            hierarchyField.setType(field.getType());
                            hierarchyField.setUnit(field.getUnit());
                            hierarchyFieldList.add(hierarchyField);
                        }
                        hierarchyMetric.setChildren(hierarchyFieldList);
                    }
                    hierarchyMetricList.add(hierarchyMetric);
                }
            }
            hierarchyApp.setChildren(hierarchyMetricList);
            hierarchies.add(hierarchyApp);
        }
    }

    private void combineHierarchyMetrics(List<Hierarchy> hierarchyMetricList, Hierarchy hierarchyMetric) {
        Optional<Hierarchy> preHierarchyOptional = hierarchyMetricList.stream().filter(item -> item.getValue().equals(hierarchyMetric.getValue())).findFirst();
        if (preHierarchyOptional.isPresent()) {
            Hierarchy preHierarchy = preHierarchyOptional.get();
            List<Hierarchy> children = preHierarchy.getChildren();
            Set childrenKey = children.stream().map(Hierarchy::getValue).collect(Collectors.toSet());
            for (Hierarchy child : hierarchyMetric.getChildren()) {
                if (childrenKey.contains(child.getValue())) continue;
                children.add(child);
            }
        } else {
            hierarchyMetricList.add(hierarchyMetric);
        }
    }

    @Override
    public Map<String, Job> getAllAppDefines() {
        return this.appDefines;
    }

    @Override
    public String getMonitorDefineFileContent(String app) {
        String appDefine = this.appDefineStore.loadAppDefine(app);
        if (Objects.isNull(appDefine)) {
            appDefine = this.jarAppDefineStore.loadAppDefine(app);
        }
        if (Objects.isNull(appDefine)) {
            throw new IllegalArgumentException("can not find " + app + " define yml");
        }
        return appDefine;
    }

    @Override
    public void applyMonitorDefineYml(String ymlContent, boolean isModify) {
        Job app;
        Yaml yaml = new Yaml();
        try {
            app = (Job)yaml.loadAs(ymlContent, Job.class);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new IllegalArgumentException("parse yml error: " + e.getMessage());
        }
        this.verifyDefineAppContent(app, isModify);
        this.appDefineStore.save(app.getApp(), ymlContent);
        Job originalJob = this.appDefines.get(app.getApp().toLowerCase());
        if (Objects.nonNull(originalJob)) {
            boolean hide = originalJob.isHide();
            app.setHide(hide);
        }
        this.appDefines.put(app.getApp().toLowerCase(), app);
        SpringContextHolder.getBean(MonitorService.class).updateAppCollectJob(app);
    }

    private void verifyDefineAppContent(Job app, boolean isModify) {
        Assert.notNull((Object)app, (String)"monitoring template can not null");
        Assert.notNull((Object)app.getApp(), (String)"monitoring template require attributes app");
        Assert.notNull((Object)app.getCategory(), (String)"monitoring template require attributes category");
        Assert.notEmpty(app.getName(), (String)"monitoring template require attributes name");
        Assert.notEmpty(app.getParams(), (String)"monitoring template require attributes params");
        boolean hasParamHost = app.getParams().stream().anyMatch(item -> "host".equals(item.getField()));
        Assert.isTrue((boolean)hasParamHost, (String)"monitoring template attributes params must have param host");
        Assert.notEmpty(app.getMetrics(), (String)"monitoring template require attributes metrics");
        boolean hasAvailableMetrics = app.getMetrics().stream().anyMatch(item -> item.getPriority() == 0);
        Assert.isTrue((boolean)hasAvailableMetrics, (String)"monitoring template metrics list must have one priority 0 metrics");
        CommonUtil.validDefineI18n(app.getName(), "name");
        CommonUtil.validDefineI18n(app.getHelp(), "help");
        CommonUtil.validDefineI18n(app.getHelpLink(), "helpLink");
        for (ParamDefine param : app.getParams()) {
            CommonUtil.validDefineI18n(param.getName(), param.getField() + " param");
        }
        for (Metrics metric : app.getMetrics()) {
            CommonUtil.validDefineI18n(metric.getI18n(), metric.getName() + " metric");
            if (metric.getFields() == null) continue;
            for (Metrics.Field field : metric.getFields()) {
                CommonUtil.validDefineI18n(field.getI18n(), metric.getName() + " metric " + field.getField() + " field");
            }
        }
        if (!isModify) {
            Assert.isNull((Object)this.appDefines.get(app.getApp().toLowerCase()), (String)("monitoring template name " + app.getApp() + " already exists."));
        }
        HashSet<String> fieldsSet = new HashSet<String>(16);
        for (Metrics metrics : app.getMetrics()) {
            Assert.notEmpty(metrics.getFields(), (String)"monitoring template metrics fields can not null");
            fieldsSet.clear();
            for (Metrics.Field field : metrics.getFields()) {
                if (fieldsSet.contains(field.getField())) {
                    throw new IllegalArgumentException(app.getApp() + " " + metrics.getName() + " " + field.getField() + " can not duplicated.");
                }
                fieldsSet.add(field.getField());
            }
        }
    }

    @Override
    public void deleteMonitorDefine(String app) {
        List<Monitor> monitors = this.monitorDao.findMonitorsByAppEquals(app);
        if (monitors != null && !monitors.isEmpty()) {
            throw new IllegalArgumentException("Can not delete define which has monitoring instances.");
        }
        this.appDefineStore.delete(app);
    }

    @Override
    public void updateCustomTemplateConfig(TemplateConfig config) {
        if (config == null) {
            return;
        }
        Map<String, TemplateConfig.AppTemplate> templateMap = config.getApps();
        if (templateMap == null || templateMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, TemplateConfig.AppTemplate> entry : templateMap.entrySet()) {
            Job appDefine;
            String app = entry.getKey().toLowerCase();
            TemplateConfig.AppTemplate appTemplate = entry.getValue();
            if (appTemplate == null || (appDefine = this.appDefines.get(app)) == null) continue;
            appDefine.setHide(appTemplate.isHide());
        }
    }

    public void afterPropertiesSet() throws Exception {
        ObjectStoreDTO objectStoreConfig = (ObjectStoreDTO)this.objectStoreConfigService.getConfig();
        this.refreshStore(objectStoreConfig);
    }

    @EventListener(value={ObjectStoreConfigChangeEvent.class})
    public void onObjectStoreConfigChange(ObjectStoreConfigChangeEvent event) {
        this.refreshStore(event.getConfig());
    }

    private void refreshStore(ObjectStoreDTO<?> objectStoreConfig) {
        this.appDefineStore = objectStoreConfig == null ? new LocalFileAppDefineStoreImpl() : (objectStoreConfig.getType() == ObjectStoreDTO.Type.OBS ? new ObjectStoreAppDefineStoreImpl() : (objectStoreConfig.getType() == ObjectStoreDTO.Type.DATABASE ? new DatabaseAppDefineStoreImpl() : new LocalFileAppDefineStoreImpl()));
        boolean success = this.appDefineStore.loadAppDefines();
        if (!success) {
            new JarAppDefineStoreImpl().loadAppDefines();
        }
    }

    private class JarAppDefineStoreImpl
    implements AppDefineStore {
        private JarAppDefineStoreImpl() {
        }

        @Override
        public boolean loadAppDefines() {
            try {
                org.springframework.core.io.Resource[] resources;
                Yaml yaml = new Yaml();
                log.info("load define app yml in internal jar");
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                for (org.springframework.core.io.Resource resource : resources = resolver.getResources("classpath:define/*.yml")) {
                    try (InputStream inputStream = resource.getInputStream();){
                        Job app = (Job)yaml.loadAs(inputStream, Job.class);
                        AppServiceImpl.this.appDefines.put(app.getApp().toLowerCase(), app);
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        log.error("Ignore this template file: {}.", (Object)resource.getFilename());
                    }
                }
                return true;
            }
            catch (IOException e) {
                log.error("define app yml not exist");
                return false;
            }
        }

        @Override
        public String loadAppDefine(String app) {
            String string;
            block8: {
                log.info("load define app yml in internal jar");
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                org.springframework.core.io.Resource resource = resolver.getResource("classpath:define/app-" + app + ".yml");
                InputStream inputStream = resource.getInputStream();
                try {
                    string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                        return null;
                    }
                }
                inputStream.close();
            }
            return string;
        }

        @Override
        public void save(String app, String ymlContent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(String app) {
            throw new UnsupportedOperationException("define yml inside jars cannot be deleted");
        }
    }

    private static interface AppDefineStore {
        public boolean loadAppDefines();

        public String loadAppDefine(String var1);

        public void save(String var1, String var2);

        public void delete(String var1);
    }

    private class LocalFileAppDefineStoreImpl
    implements AppDefineStore {
        private LocalFileAppDefineStoreImpl() {
        }

        @Override
        public boolean loadAppDefines() {
            URL rootUrl = this.getClass().getClassLoader().getResource("");
            if (rootUrl == null) {
                return false;
            }
            String classpath = rootUrl.getPath();
            String defineAppPath = classpath + "define";
            File directory = new File(defineAppPath);
            if (!directory.exists() || directory.listFiles() == null) {
                rootUrl = this.getClass().getResource(File.separator);
                if (rootUrl == null) {
                    return false;
                }
                classpath = rootUrl.getPath();
                defineAppPath = classpath + "define";
                directory = new File(defineAppPath);
                if (!directory.exists() || directory.listFiles() == null) {
                    return false;
                }
            }
            log.info("load define path {}", (Object)defineAppPath);
            Yaml yaml = new Yaml();
            for (File appFile : Objects.requireNonNull(directory.listFiles())) {
                if (!appFile.exists() || !appFile.isFile()) continue;
                if (appFile.isHidden() || !appFile.getName().endsWith("yml") && !appFile.getName().endsWith("yaml")) {
                    log.error("Ignore this template file: {}.", (Object)appFile.getName());
                    continue;
                }
                try (FileInputStream fileInputStream = new FileInputStream(appFile);){
                    Job app = (Job)yaml.loadAs((InputStream)fileInputStream, Job.class);
                    if (app == null) continue;
                    AppServiceImpl.this.appDefines.put(app.getApp().toLowerCase(), app);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("Ignore this template file: {}.", (Object)appFile.getName());
                }
            }
            return true;
        }

        @Override
        public String loadAppDefine(String app) {
            String classpath = Objects.requireNonNull(this.getClass().getClassLoader().getResource("")).getPath();
            String defineAppPath = classpath + "define" + File.separator + "app-" + app + ".yml";
            File defineAppFile = new File(defineAppPath);
            if (defineAppFile.exists() && defineAppFile.isFile()) {
                log.info("load {} define app yml in file: {}", (Object)app, (Object)defineAppPath);
                try {
                    return FileUtils.readFileToString((File)defineAppFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            return null;
        }

        @Override
        public void save(String app, String ymlContent) {
            String classpath = Objects.requireNonNull(this.getClass().getClassLoader().getResource("")).getPath();
            String defineAppPath = classpath + "define" + File.separator + "app-" + app + ".yml";
            File defineAppFile = new File(defineAppPath);
            try {
                FileUtils.writeStringToFile((File)defineAppFile, (String)ymlContent, (Charset)StandardCharsets.UTF_8, (boolean)false);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new RuntimeException("flush file " + defineAppPath + " error: " + e.getMessage());
            }
        }

        @Override
        public void delete(String app) {
            String classpath = Objects.requireNonNull(this.getClass().getClassLoader().getResource("")).getPath();
            String defineAppPath = classpath + "define" + File.separator + "app-" + app + ".yml";
            File defineAppFile = new File(defineAppPath);
            if (!defineAppFile.exists() && AppServiceImpl.this.appDefines.containsKey(app.toLowerCase())) {
                throw new CommonException("the app define file is not in current file server provider");
            }
            if (defineAppFile.exists() && defineAppFile.isFile()) {
                defineAppFile.delete();
            }
            AppServiceImpl.this.appDefines.remove(app.toLowerCase());
        }
    }

    private class ObjectStoreAppDefineStoreImpl
    implements AppDefineStore {
        private ObjectStoreAppDefineStoreImpl() {
        }

        @Override
        public boolean loadAppDefines() {
            ObjectStoreService objectStoreService = this.getObjectStoreService();
            Yaml yaml = new Yaml();
            objectStoreService.list("define").forEach(it -> {
                Job app;
                if (it.getInputStream() != null && (app = (Job)yaml.loadAs(it.getInputStream(), Job.class)) != null) {
                    AppServiceImpl.this.appDefines.put(app.getApp().toLowerCase(), app);
                }
            });
            return false;
        }

        @Override
        public String loadAppDefine(String app) {
            ObjectStoreService objectStoreService = this.getObjectStoreService();
            FileDTO file = objectStoreService.download(this.getDefineAppPath(app));
            if (Objects.isNull(file)) {
                return null;
            }
            try {
                return IOUtils.toString((InputStream)file.getInputStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("load app define from object store service error", (Throwable)e);
                return null;
            }
        }

        @Override
        public void save(String app, String ymlContent) {
            ObjectStoreService objectStoreService = this.getObjectStoreService();
            objectStoreService.upload(this.getDefineAppPath(app), IOUtils.toInputStream((String)ymlContent, (Charset)StandardCharsets.UTF_8));
        }

        @Override
        public void delete(String app) {
            String defineAppPath;
            ObjectStoreService objectStoreService = this.getObjectStoreService();
            boolean exist = objectStoreService.isExist(defineAppPath = this.getDefineAppPath(app));
            if (!exist && AppServiceImpl.this.appDefines.containsKey(app.toLowerCase())) {
                throw new CommonException("the app define file is not in current file server provider");
            }
            if (exist) {
                objectStoreService.remove(defineAppPath);
            }
            AppServiceImpl.this.appDefines.remove(app.toLowerCase());
        }

        private ObjectStoreService getObjectStoreService() {
            return SpringContextHolder.getBean(ObsObjectStoreServiceImpl.class);
        }

        private String getDefineAppPath(String app) {
            return "define/app-" + app + ".yml";
        }
    }

    private class DatabaseAppDefineStoreImpl
    implements AppDefineStore {
        private DatabaseAppDefineStoreImpl() {
        }

        @Override
        public boolean loadAppDefines() {
            Yaml yaml = new Yaml();
            List defines = AppServiceImpl.this.defineDao.findAll();
            for (Define define : defines) {
                Job app = (Job)yaml.loadAs(define.getContent(), Job.class);
                if (app == null) continue;
                AppServiceImpl.this.appDefines.put(define.getApp().toLowerCase(), app);
            }
            return false;
        }

        @Override
        public String loadAppDefine(String app) {
            Optional defineOptional = AppServiceImpl.this.defineDao.findById(app);
            return defineOptional.map(Define::getContent).orElse(null);
        }

        @Override
        public void save(String app, String ymlContent) {
            Define define = new Define();
            define.setApp(app);
            define.setContent(ymlContent);
            AppServiceImpl.this.defineDao.save(define);
        }

        @Override
        public void delete(String app) {
            Optional defineOptional = AppServiceImpl.this.defineDao.findById(app);
            if (defineOptional.isEmpty() && AppServiceImpl.this.appDefines.containsKey(app.toLowerCase())) {
                throw new CommonException("the app define file is not in current file server provider");
            }
            if (defineOptional.isPresent()) {
                AppServiceImpl.this.defineDao.deleteById(app);
            }
            AppServiceImpl.this.appDefines.remove(app.toLowerCase());
        }
    }
}

