/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.pojo.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.hertzbeat.common.entity.grafana.GrafanaDashboard;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.Param;

@Schema(description="Monitoring information entities")
public class MonitorDto {
    @Schema(description="Monitor Content", accessMode=Schema.AccessMode.READ_WRITE)
    @NotNull
    @Valid
    private Monitor monitor;
    @Schema(description="Monitor Params", accessMode=Schema.AccessMode.READ_WRITE)
    @NotEmpty
    @Valid
    private List<Param> params;
    @Schema(description="Monitor Metrics", accessMode=Schema.AccessMode.READ_ONLY)
    private List<String> metrics;
    @Schema(description="pinned collector, default null if system dispatch", accessMode=Schema.AccessMode.READ_WRITE)
    private String collector;
    @Schema(description="grafana dashboard")
    private GrafanaDashboard grafanaDashboard;

    public Monitor getMonitor() {
        return this.monitor;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    public String getCollector() {
        return this.collector;
    }

    public GrafanaDashboard getGrafanaDashboard() {
        return this.grafanaDashboard;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = metrics;
    }

    public void setCollector(String collector) {
        this.collector = collector;
    }

    public void setGrafanaDashboard(GrafanaDashboard grafanaDashboard) {
        this.grafanaDashboard = grafanaDashboard;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorDto)) {
            return false;
        }
        MonitorDto other = (MonitorDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Monitor this$monitor = this.getMonitor();
        Monitor other$monitor = other.getMonitor();
        if (this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor)) {
            return false;
        }
        List<Param> this$params = this.getParams();
        List<Param> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        List<String> this$metrics = this.getMetrics();
        List<String> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        String this$collector = this.getCollector();
        String other$collector = other.getCollector();
        if (this$collector == null ? other$collector != null : !this$collector.equals(other$collector)) {
            return false;
        }
        GrafanaDashboard this$grafanaDashboard = this.getGrafanaDashboard();
        GrafanaDashboard other$grafanaDashboard = other.getGrafanaDashboard();
        return !(this$grafanaDashboard == null ? other$grafanaDashboard != null : !((Object)this$grafanaDashboard).equals(other$grafanaDashboard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitorDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Monitor $monitor = this.getMonitor();
        result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
        List<Param> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        List<String> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        String $collector = this.getCollector();
        result = result * 59 + ($collector == null ? 43 : $collector.hashCode());
        GrafanaDashboard $grafanaDashboard = this.getGrafanaDashboard();
        result = result * 59 + ($grafanaDashboard == null ? 43 : ((Object)$grafanaDashboard).hashCode());
        return result;
    }

    public String toString() {
        return "MonitorDto(monitor=" + this.getMonitor() + ", params=" + this.getParams() + ", metrics=" + this.getMetrics() + ", collector=" + this.getCollector() + ", grafanaDashboard=" + this.getGrafanaDashboard() + ")";
    }
}

