/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.config;

import org.flywaydb.core.Flyway;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, havingValue="true")
public class FlywayConfiguration {
    @Bean
    public FlywayMigrationInitializer flywayInitializer(Flyway flyway) {
        return new FlywayMigrationInitializer(flyway, f -> {});
    }

    @Bean
    @DependsOn(value={"entityManagerFactory"})
    Dummy delayedFlywayInitializer(Flyway flyway, FlywayProperties flywayProperties) {
        if (flywayProperties.isEnabled()) {
            flyway.migrate();
        }
        return new Dummy();
    }

    static class Dummy {
        Dummy() {
        }
    }
}

