/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.sd;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.MonitorBind;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.SdMonitorParam;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.util.SdMonitorOperator;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.scheduler.ManagerWorkerPool;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ServiceDiscoveryWorker
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryWorker.class);
    private final MonitorService monitorService;
    private final ParamDao paramDao;
    private final MonitorDao monitorDao;
    private final MonitorBindDao monitorBindDao;
    private final CollectorMonitorBindDao collectorMonitorBindDao;
    private final CommonDataQueue dataQueue;
    private final ManagerWorkerPool workerPool;

    public ServiceDiscoveryWorker(MonitorService monitorService, ParamDao paramDao, MonitorDao monitorDao, MonitorBindDao monitorBindDao, CollectorMonitorBindDao collectorMonitorBindDao, CommonDataQueue dataQueue, ManagerWorkerPool workerPool) {
        this.monitorService = monitorService;
        this.paramDao = paramDao;
        this.monitorDao = monitorDao;
        this.monitorBindDao = monitorBindDao;
        this.collectorMonitorBindDao = collectorMonitorBindDao;
        this.dataQueue = dataQueue;
        this.workerPool = workerPool;
    }

    public void afterPropertiesSet() {
        this.workerPool.executeJob(new SdUpdateTask());
    }

    private class SdUpdateTask
    implements Runnable {
        private SdUpdateTask() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = ServiceDiscoveryWorker.this.dataQueue.pollServiceDiscoveryData();
                    try {
                        Long monitorId = metricsData.getId();
                        Monitor mainMonitor = ServiceDiscoveryWorker.this.monitorDao.findMonitorsByIdIn(Sets.newHashSet((Object[])new Long[]{monitorId})).get(0);
                        mainMonitor.getLabels().remove("sdMainMonitor");
                        Optional<CollectorMonitorBind> collectorBind = ServiceDiscoveryWorker.this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(mainMonitor.getId());
                        String collector = collectorBind.map(CollectorMonitorBind::getCollector).orElse(null);
                        List<Param> mainMonitorParamList = ServiceDiscoveryWorker.this.paramDao.findParamsByMonitorId(mainMonitor.getId());
                        mainMonitorParamList = SdMonitorOperator.removeSdParam(mainMonitorParamList);
                        Set<Long> subMonitorIdSet = ServiceDiscoveryWorker.this.monitorBindDao.findMonitorBindByBizIdAndType(monitorId, (byte)0).stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
                        HashMap hostMonitorMap = CollectionUtils.isEmpty(subMonitorIdSet) ? Maps.newHashMap() : ServiceDiscoveryWorker.this.monitorDao.findMonitorsByIdIn(subMonitorIdSet).stream().collect(Collectors.groupingBy(Monitor::getHost));
                        RowWrapper rowWrapper = metricsData.readRow();
                        while (rowWrapper.hasNextRow()) {
                            rowWrapper = rowWrapper.nextRow();
                            String host = rowWrapper.nextCell().getValue();
                            String port = rowWrapper.nextCell().getValue();
                            List monitorList = (List)hostMonitorMap.get(host);
                            if (CollectionUtils.isEmpty((Collection)monitorList)) {
                                ServiceDiscoveryWorker.this.monitorService.addAndSaveMonitorJob(mainMonitor.clone(), SdMonitorOperator.cloneParamList(mainMonitorParamList), collector, SdMonitorParam.builder().detectedHost(host).detectedPort(port).bizId(mainMonitor.getId()).build(), null);
                                return;
                            }
                            for (Monitor monitor : monitorList) {
                                Optional<Param> samePortParam = ServiceDiscoveryWorker.this.paramDao.findParamsByMonitorId(monitor.getId()).stream().filter(param -> StringUtils.equals((CharSequence)param.getField(), (CharSequence)"port")).filter(param -> StringUtils.equals((CharSequence)param.getParamValue(), (CharSequence)port)).findFirst();
                                if (samePortParam.isEmpty()) {
                                    ServiceDiscoveryWorker.this.monitorService.addAndSaveMonitorJob(mainMonitor.clone(), SdMonitorOperator.cloneParamList(mainMonitorParamList), collector, SdMonitorParam.builder().detectedHost(host).detectedPort(port).bizId(mainMonitor.getId()).build(), null);
                                    continue;
                                }
                                ServiceDiscoveryWorker.this.monitorService.enableManageMonitors(Sets.newHashSet((Object[])new Long[]{monitor.getId()}));
                            }
                            hostMonitorMap.remove(host);
                        }
                        HashSet needCancelMonitorIdSet = Sets.newHashSet();
                        hostMonitorMap.forEach((key, value) -> needCancelMonitorIdSet.addAll(value.stream().map(Monitor::getId).collect(Collectors.toSet())));
                        ServiceDiscoveryWorker.this.monitorService.cancelManageMonitors(needCancelMonitorIdSet);
                    }
                    finally {
                        if (metricsData == null) continue;
                        metricsData.close();
                    }
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }
}

