/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.service;

import org.apache.hertzbeat.grafana.config.GrafanaProperties;
import org.apache.hertzbeat.warehouse.store.history.vm.VictoriaMetricsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class DatasourceService {
    private static final Logger log = LoggerFactory.getLogger(DatasourceService.class);
    private final GrafanaProperties grafanaProperties;
    private final VictoriaMetricsProperties warehouseProperties;
    private final RestTemplate restTemplate;

    @Autowired
    public DatasourceService(GrafanaProperties grafanaProperties, VictoriaMetricsProperties warehouseProperties, RestTemplate restTemplate) {
        this.grafanaProperties = grafanaProperties;
        this.warehouseProperties = warehouseProperties;
        this.restTemplate = restTemplate;
    }

    public void existOrCreateDatasource(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        String queryUrl = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + "/api/datasources/name/hertzbeat-victoria-metrics";
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(queryUrl, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("{} datasource exist", (Object)"hertzbeat-victoria-metrics");
            }
        }
        catch (HttpClientErrorException.NotFound notFound) {
            String createUrl = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + "/api/datasources";
            String body = String.format("{\"name\":\"%s\",\"type\":\"%s\",\"access\":\"%s\",\"url\":\"%s\",\"basicAuth\":%s}", "hertzbeat-victoria-metrics", "prometheus", "proxy", this.warehouseProperties.url(), false);
            HttpEntity createEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            try {
                ResponseEntity createResponse = this.restTemplate.postForEntity(createUrl, (Object)createEntity, String.class, new Object[0]);
                if (createResponse.getStatusCode().is2xxSuccessful()) {
                    log.info("Create datasource success");
                }
            }
            catch (Exception e) {
                log.error("Create datasource error", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("Query datasource error", (Throwable)e);
        }
    }
}

