/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.service;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.hertzbeat.common.entity.grafana.GrafanaDashboard;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.grafana.config.GrafanaProperties;
import org.apache.hertzbeat.grafana.dao.DashboardDao;
import org.apache.hertzbeat.grafana.service.ServiceAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DashboardService {
    private static final Logger log = LoggerFactory.getLogger(DashboardService.class);
    @Autowired
    private ServiceAccountService serviceAccountService;
    @Autowired
    private DashboardDao dashboardDao;
    @Autowired
    private GrafanaProperties grafanaProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> createOrUpdateDashboard(String dashboardJson, Long monitorId) {
        String token = this.serviceAccountService.getToken();
        String url = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + "/api/dashboards/db";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("dashboard", JsonUtil.fromJson((String)dashboardJson, Object.class));
        body.put("overwrite", true);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                GrafanaDashboard grafanaDashboard = (GrafanaDashboard)JsonUtil.fromJson((String)((String)response.getBody()), GrafanaDashboard.class);
                if (grafanaDashboard != null) {
                    grafanaDashboard.setEnabled(true);
                    grafanaDashboard.setUrl(this.grafanaProperties.exposeUrl() + grafanaDashboard.getUrl().replace(this.grafanaProperties.getUrl(), "") + "?kiosk=tv&refresh=15s&var-instance=" + monitorId + "&var-ds=hertzbeat-victoria-metrics");
                    grafanaDashboard.setMonitorId(monitorId);
                    this.dashboardDao.save(grafanaDashboard);
                    log.info("create dashboard success, token: {}", response.getBody());
                }
                return response;
            }
            log.error("create dashboard error: {}", (Object)response.getStatusCode());
            throw new RuntimeException("create dashboard error");
        }
        catch (Exception ex) {
            log.error("create dashboard error", (Throwable)ex);
            throw new RuntimeException("create dashboard error", ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteDashboard(Long monitorId) {
        GrafanaDashboard grafanaDashboard = this.dashboardDao.findByMonitorId(monitorId);
        if (Objects.isNull(grafanaDashboard)) {
            return;
        }
        String uid = grafanaDashboard.getUid();
        List<GrafanaDashboard> grafanaDashboards = this.dashboardDao.findByUid(uid);
        if (grafanaDashboards.size() > 1) {
            this.dashboardDao.deleteByMonitorId(monitorId);
        } else {
            String token = this.serviceAccountService.getToken();
            String url = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + String.format("/api/dashboards/uid/%s", uid);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(token);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            this.dashboardDao.deleteByMonitorId(monitorId);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("delete dashboard success");
            } else {
                log.error("delete dashboard error: {}", (Object)response.getStatusCode());
                throw new RuntimeException("delete dashboard error");
            }
        }
    }

    public GrafanaDashboard getDashboardByMonitorId(Long monitorId) {
        return this.dashboardDao.findByMonitorId(monitorId);
    }

    public void closeGrafanaDashboard(Long monitorId) {
        GrafanaDashboard grafanaDashboard = this.dashboardDao.findByMonitorId(monitorId);
        if (grafanaDashboard != null) {
            grafanaDashboard.setEnabled(false);
            this.dashboardDao.save(grafanaDashboard);
        }
    }
}

