/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.common.http;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHttpClient {
    private static final Logger log = LoggerFactory.getLogger(CommonHttpClient.class);
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager connectionManager;
    private static final int MAX_TOTAL_CONNECTIONS = 50000;
    private static final int MAX_PER_ROUTE_CONNECTIONS = 80;
    private static final int REQUIRE_CONNECT_TIMEOUT = 4000;
    private static final int CONNECT_TIMEOUT = 4000;
    private static final int SOCKET_TIMEOUT = 60000;
    private static final int INACTIVITY_VALIDATED_TIME = 10000;
    private static final String[] SUPPORTED_SSL;

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    public static void close() {
        try {
            httpClient.close();
        }
        catch (Exception e) {
            log.error("close http client error", (Throwable)e);
        }
    }

    static {
        SUPPORTED_SSL = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "SSLv3"};
        try {
            SSLContext sslContext = SSLContexts.createDefault();
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    Date now = new Date();
                    if (x509Certificates != null) {
                        for (X509Certificate certificate : x509Certificates) {
                            Date deadline = certificate.getNotAfter();
                            if (deadline == null || !now.after(deadline)) continue;
                            throw new CertificateExpiredException();
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, SUPPORTED_SSL, null, (HostnameVerifier)new NoopHostnameVerifier());
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslFactory).build();
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(4000).setConnectTimeout(4000).setSocketTimeout(60000).setRedirectsEnabled(true).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry);
            connectionManager.setMaxTotal(50000);
            connectionManager.setDefaultMaxPerRoute(80);
            connectionManager.setValidateAfterInactivity(10000);
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).evictExpiredConnections().evictIdleConnections(100L, TimeUnit.SECONDS).build();
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("http-connection-pool-cleaner-%d").setDaemon(true).build();
            ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, threadFactory);
            scheduledExecutor.scheduleWithFixedDelay(() -> {
                connectionManager.closeExpiredConnections();
                connectionManager.closeIdleConnections(40L, TimeUnit.SECONDS);
            }, 40L, 40L, TimeUnit.SECONDS);
            Runtime.getRuntime().addShutdownHook(new Thread(CommonHttpClient::close));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

