/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.db;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;
import org.apache.hertzbeat.warehouse.store.history.greptime.GreptimeProperties;
import org.apache.hertzbeat.warehouse.store.history.vm.PromQlQueryContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(prefix="warehouse.store.greptime", name={"enabled"}, havingValue="true")
public class GreptimePromqlQueryExecutor
implements QueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(GreptimePromqlQueryExecutor.class);
    private static final String QUERY_PATH = "/v1/prometheus/api/v1/query";
    private final GreptimeProperties greptimeProperties;
    private final RestTemplate restTemplate;

    public GreptimePromqlQueryExecutor(GreptimeProperties greptimeProperties, RestTemplate restTemplate) {
        this.greptimeProperties = greptimeProperties;
        this.restTemplate = restTemplate;
    }

    @Override
    public List<Map<String, Object>> execute(String query) {
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.greptimeProperties.username()) && StringUtils.hasText((String)this.greptimeProperties.password())) {
                String authStr = this.greptimeProperties.username() + ":" + this.greptimeProperties.password();
                String encodedAuth = Base64Util.encode((String)authStr);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            URI uri = UriComponentsBuilder.fromHttpUrl((String)(this.greptimeProperties.httpEndpoint() + QUERY_PATH)).queryParam("query", new Object[]{URLEncoder.encode(query, StandardCharsets.UTF_8)}).build(true).toUri();
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, PromQlQueryContent.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                    List<PromQlQueryContent.ContentData.Content> contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                    for (PromQlQueryContent.ContentData.Content content : contents) {
                        Map<String, String> labels = content.getMetric();
                        HashMap<String, Object> queryResult = new HashMap<String, Object>(8);
                        queryResult.putAll(labels);
                        if (content.getValue() != null && content.getValue().length == 2) {
                            queryResult.put("__timestamp__", content.getValue()[0]);
                            queryResult.put("__value__", content.getValue()[1]);
                        } else if (content.getValues() != null && !content.getValues().isEmpty()) {
                            LinkedList<Object> values = new LinkedList<Object>();
                            for (Object[] valueArr : content.getValues()) {
                                values.add(valueArr[1]);
                            }
                            queryResult.put("__value__", values);
                        }
                        results.add(queryResult);
                    }
                }
            } else {
                log.error("query metrics data from greptime failed. {}", (Object)responseEntity);
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        return results;
    }

    @Override
    public boolean support(String datasource) {
        return "promql".equals(datasource);
    }
}

