/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ResourceElementResolver {
    private final String name;
    private final boolean defaultName;

    ResourceElementResolver(String name, boolean defaultName) {
        this.name = name;
        this.defaultName = defaultName;
    }

    public static ResourceElementResolver forField(String fieldName) {
        return new ResourceFieldResolver(fieldName, true, fieldName);
    }

    public static ResourceElementResolver forField(String fieldName, String resourceName) {
        return new ResourceFieldResolver(resourceName, false, fieldName);
    }

    public static ResourceElementResolver forMethod(String methodName, Class<?> parameterType) {
        return new ResourceMethodResolver(ResourceElementResolver.defaultResourceNameForMethod(methodName), true, methodName, parameterType);
    }

    public static ResourceElementResolver forMethod(String methodName, Class<?> parameterType, String resourceName) {
        return new ResourceMethodResolver(resourceName, false, methodName, parameterType);
    }

    private static String defaultResourceNameForMethod(String methodName) {
        if (methodName.startsWith("set") && methodName.length() > 3) {
            return StringUtils.uncapitalizeAsProperty((String)methodName.substring(3));
        }
        return methodName;
    }

    @Nullable
    public <T> T resolve(RegisteredBean registeredBean) {
        Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
        return (T)(this.isLazyLookup(registeredBean) ? this.buildLazyResourceProxy(registeredBean) : this.resolveValue(registeredBean));
    }

    public abstract void resolveAndSet(RegisteredBean var1, Object var2);

    abstract DependencyDescriptor createDependencyDescriptor(RegisteredBean var1);

    abstract Class<?> getLookupType(RegisteredBean var1);

    abstract AnnotatedElement getAnnotatedElement(RegisteredBean var1);

    boolean isLazyLookup(RegisteredBean registeredBean) {
        AnnotatedElement ae = this.getAnnotatedElement(registeredBean);
        Lazy lazy = ae.getAnnotation(Lazy.class);
        return lazy != null && lazy.value();
    }

    private Object buildLazyResourceProxy(final RegisteredBean registeredBean) {
        final Class<?> lookupType = this.getLookupType(registeredBean);
        TargetSource ts = new TargetSource(){

            public Class<?> getTargetClass() {
                return lookupType;
            }

            public Object getTarget() {
                return ResourceElementResolver.this.resolveValue(registeredBean);
            }
        };
        ProxyFactory pf = new ProxyFactory();
        pf.setTargetSource(ts);
        if (lookupType.isInterface()) {
            pf.addInterface(lookupType);
        }
        return pf.getProxy(registeredBean.getBeanFactory().getBeanClassLoader());
    }

    private Object resolveValue(RegisteredBean registeredBean) {
        Object resource;
        Set<Object> autowiredBeanNames;
        ConfigurableListableBeanFactory factory = registeredBean.getBeanFactory();
        DependencyDescriptor descriptor = this.createDependencyDescriptor(registeredBean);
        if (this.defaultName && !factory.containsBean(this.name)) {
            autowiredBeanNames = new LinkedHashSet();
            resource = factory.resolveDependency(descriptor, registeredBean.getBeanName(), autowiredBeanNames, null);
            if (resource == null) {
                throw new NoSuchBeanDefinitionException(descriptor.getDependencyType(), "No resolvable resource object");
            }
        } else {
            resource = factory.resolveBeanByName(this.name, descriptor);
            autowiredBeanNames = Collections.singleton(this.name);
        }
        for (String string : autowiredBeanNames) {
            if (!factory.containsBean(string)) continue;
            factory.registerDependentBean(string, registeredBean.getBeanName());
        }
        return resource;
    }

    private static final class ResourceFieldResolver
    extends ResourceElementResolver {
        private final String fieldName;

        public ResourceFieldResolver(String name, boolean defaultName, String fieldName) {
            super(name, defaultName);
            this.fieldName = fieldName;
        }

        @Override
        public void resolveAndSet(RegisteredBean registeredBean, Object instance) {
            Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
            Assert.notNull((Object)instance, (String)"'instance' must not be null");
            Field field = this.getField(registeredBean);
            Object resolved = this.resolve(registeredBean);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)instance, resolved);
        }

        @Override
        protected DependencyDescriptor createDependencyDescriptor(RegisteredBean registeredBean) {
            Field field = this.getField(registeredBean);
            return new LookupDependencyDescriptor(field, field.getType(), this.isLazyLookup(registeredBean));
        }

        @Override
        protected Class<?> getLookupType(RegisteredBean registeredBean) {
            return this.getField(registeredBean).getType();
        }

        @Override
        protected AnnotatedElement getAnnotatedElement(RegisteredBean registeredBean) {
            return this.getField(registeredBean);
        }

        private Field getField(RegisteredBean registeredBean) {
            Field field = ReflectionUtils.findField((Class)registeredBean.getBeanClass(), (String)this.fieldName);
            Assert.notNull((Object)field, () -> "No field '" + this.fieldName + "' found on " + registeredBean.getBeanClass().getName());
            return field;
        }
    }

    private static final class ResourceMethodResolver
    extends ResourceElementResolver {
        private final String methodName;
        private final Class<?> lookupType;

        private ResourceMethodResolver(String name, boolean defaultName, String methodName, Class<?> lookupType) {
            super(name, defaultName);
            this.methodName = methodName;
            this.lookupType = lookupType;
        }

        @Override
        public void resolveAndSet(RegisteredBean registeredBean, Object instance) {
            Assert.notNull((Object)registeredBean, (String)"'registeredBean' must not be null");
            Assert.notNull((Object)instance, (String)"'instance' must not be null");
            Method method = this.getMethod(registeredBean);
            Object resolved = this.resolve(registeredBean);
            ReflectionUtils.makeAccessible((Method)method);
            ReflectionUtils.invokeMethod((Method)method, (Object)instance, (Object[])new Object[]{resolved});
        }

        @Override
        protected DependencyDescriptor createDependencyDescriptor(RegisteredBean registeredBean) {
            return new LookupDependencyDescriptor(this.getMethod(registeredBean), this.lookupType, this.isLazyLookup(registeredBean));
        }

        @Override
        protected Class<?> getLookupType(RegisteredBean bean2) {
            return this.lookupType;
        }

        @Override
        protected AnnotatedElement getAnnotatedElement(RegisteredBean registeredBean) {
            return this.getMethod(registeredBean);
        }

        private Method getMethod(RegisteredBean registeredBean) {
            Method method = ReflectionUtils.findMethod((Class)registeredBean.getBeanClass(), (String)this.methodName, (Class[])new Class[]{this.lookupType});
            Assert.notNull((Object)method, () -> "Method '%s' with parameter type '%s' declared on %s could not be found.".formatted(this.methodName, this.lookupType.getName(), registeredBean.getBeanClass().getName()));
            return method;
        }
    }

    static class LookupDependencyDescriptor
    extends DependencyDescriptor {
        private final Class<?> lookupType;
        private final boolean lazyLookup;

        public LookupDependencyDescriptor(Field field, Class<?> lookupType, boolean lazyLookup) {
            super(field, true);
            this.lookupType = lookupType;
            this.lazyLookup = lazyLookup;
        }

        public LookupDependencyDescriptor(Method method, Class<?> lookupType, boolean lazyLookup) {
            super(new MethodParameter(method, 0), true);
            this.lookupType = lookupType;
            this.lazyLookup = lazyLookup;
        }

        public Class<?> getDependencyType() {
            return this.lookupType;
        }

        public boolean supportsLazyResolution() {
            return !this.lazyLookup;
        }
    }
}

